/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.Map;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;

public final class AttachSettings {
    public static final String PROP_ATTACH_DIRECT = "profiler.attach.direct";
    public static final String PROP_ATTACH_REMOTE = "profiler.attach.remote";
    public static final String PROP_ATTACH_DYNAMIC_JDK16 = "profiler.attach.dynamic.jdk16";
    public static final String PROP_ATTACH_HOST = "profiler.attach.host";
    public static final String PROP_ATTACH_PORT = "profiler.attach.port";
    public static final String PROP_ATTACH_DYNAMIC_PID = "profiler.attach.dynamic.pid";
    public static final String PROP_ATTACH_DYNAMIC_PROCESS_NAME = "profiler.attach.dynamic.processName";
    public static final String PROP_ATTACH_DYNAMIC_AUTO = "profiler.attach.dynamic.auto";
    public static final String PROP_ATTACH_TARGET_TYPE = "profiler.attach.target.type";
    public static final String PROP_ATTACH_SERVER_TYPE = "profiler.attach.server.type";
    public static final String PROP_ATTACH_HOST_OS = "profiler.attach.host.os";
    private String host = "";
    private String hostOS;
    private String serverType = "";
    private String targetType = "";
    private boolean direct = true;
    private boolean dynamic16 = false;
    private boolean remote = false;
    private int pid = -1;
    private String processName;
    private boolean autoSelect;
    private int transientPort = -1;

    public void setDirect(boolean bl) {
        this.direct = bl;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDynamic16(boolean bl) {
        this.dynamic16 = bl;
    }

    public boolean isDynamic16() {
        return this.dynamic16;
    }

    public void setHost(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.host = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHostOS(String string) {
        this.hostOS = string;
    }

    public String getHostOS() {
        return this.hostOS == null ? IntegrationUtils.getLocalPlatform(-1) : this.hostOS;
    }

    public void setPid(int n) {
        this.pid = n;
    }

    public int getPid() {
        return this.pid;
    }

    public void setProcessName(String string) {
        this.processName = string;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setAutoSelectProcess(boolean bl) {
        this.autoSelect = bl;
    }

    public boolean isAutoSelectProcess() {
        return this.autoSelect;
    }

    public void setPort(int n) {
        this.transientPort = n;
    }

    public int getPort() {
        if (this.transientPort != -1) {
            return this.transientPort;
        }
        return Profiler.getDefault().getGlobalProfilingSettings().getPortNo();
    }

    public void setRemote(boolean bl) {
        this.remote = bl;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setServerType(String string) {
        this.serverType = string;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setTargetType(String string) {
        this.targetType = string;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void applySettings(ProfilerEngineSettings profilerEngineSettings) {
        profilerEngineSettings.setPortNo(this.getPort());
        if (this.remote) {
            profilerEngineSettings.setRemoteHost(this.host);
        } else {
            profilerEngineSettings.setRemoteHost("");
        }
        if (this.isDynamic16()) {
            profilerEngineSettings.setInstrumentObjectInit(true);
        } else {
            profilerEngineSettings.setInstrumentObjectInit(false);
        }
    }

    public void copyInto(AttachSettings attachSettings) {
        attachSettings.direct = this.direct;
        attachSettings.remote = this.remote;
        attachSettings.dynamic16 = this.dynamic16;
        attachSettings.pid = this.pid;
        attachSettings.processName = this.processName;
        attachSettings.autoSelect = this.autoSelect;
        attachSettings.host = this.host;
        attachSettings.targetType = this.targetType;
        attachSettings.serverType = this.serverType;
        attachSettings.hostOS = this.hostOS;
    }

    public String debug() {
        return this.toString();
    }

    public void load(Map map) {
        this.direct = Boolean.valueOf(ProfilingSettings.getProperty(map, PROP_ATTACH_DIRECT, "true"));
        this.remote = Boolean.valueOf(ProfilingSettings.getProperty(map, PROP_ATTACH_REMOTE, "false"));
        this.dynamic16 = Boolean.valueOf(ProfilingSettings.getProperty(map, PROP_ATTACH_DYNAMIC_JDK16, "false"));
        this.host = ProfilingSettings.getProperty(map, PROP_ATTACH_HOST, "");
        this.targetType = ProfilingSettings.getProperty(map, PROP_ATTACH_TARGET_TYPE, "");
        this.serverType = ProfilingSettings.getProperty(map, PROP_ATTACH_SERVER_TYPE, "");
        this.hostOS = ProfilingSettings.getProperty(map, PROP_ATTACH_HOST_OS, null);
        this.pid = Integer.parseInt(ProfilingSettings.getProperty(map, PROP_ATTACH_DYNAMIC_PID, "-1"));
        this.processName = ProfilingSettings.getProperty(map, PROP_ATTACH_DYNAMIC_PROCESS_NAME, null);
        this.autoSelect = Boolean.valueOf(ProfilingSettings.getProperty(map, PROP_ATTACH_DYNAMIC_AUTO, "false"));
    }

    public void store(Map map) {
        map.put(PROP_ATTACH_DIRECT, Boolean.toString(this.direct));
        map.put(PROP_ATTACH_REMOTE, Boolean.toString(this.remote));
        map.put(PROP_ATTACH_DYNAMIC_JDK16, Boolean.toString(this.dynamic16));
        map.put(PROP_ATTACH_HOST, this.host);
        map.put(PROP_ATTACH_TARGET_TYPE, this.targetType);
        map.put(PROP_ATTACH_SERVER_TYPE, this.serverType);
        if (this.hostOS == null) {
            map.remove(PROP_ATTACH_HOST_OS);
        } else {
            map.put(PROP_ATTACH_HOST_OS, this.hostOS);
        }
        if (this.pid == -1) {
            map.remove(PROP_ATTACH_DYNAMIC_PID);
        } else {
            map.put(PROP_ATTACH_DYNAMIC_PID, Integer.toString(this.pid));
        }
        if (this.processName == null) {
            map.remove(PROP_ATTACH_DYNAMIC_PROCESS_NAME);
        } else {
            map.put(PROP_ATTACH_DYNAMIC_PROCESS_NAME, this.processName);
        }
        if (!this.autoSelect) {
            map.remove(PROP_ATTACH_DYNAMIC_AUTO);
        } else {
            map.put(PROP_ATTACH_DYNAMIC_AUTO, Boolean.TRUE.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("target type =").append(this.targetType);
        stringBuffer.append("\n");
        stringBuffer.append("server type =").append(this.serverType);
        stringBuffer.append("\n");
        stringBuffer.append("remote =").append(this.remote);
        stringBuffer.append("\n");
        stringBuffer.append("direct =").append(this.direct);
        stringBuffer.append("\n");
        stringBuffer.append("dynamic JDK16 =").append(this.dynamic16);
        stringBuffer.append("\n");
        stringBuffer.append("pid =").append(this.pid);
        stringBuffer.append("\n");
        stringBuffer.append("process name =").append(this.processName);
        stringBuffer.append("\n");
        stringBuffer.append("auto select =").append(this.autoSelect);
        stringBuffer.append("\n");
        stringBuffer.append("host =").append(this.host);
        stringBuffer.append("\n");
        stringBuffer.append("host os =").append(this.hostOS == null ? IntegrationUtils.getLocalPlatform(-1) : this.hostOS);
        stringBuffer.append("\n");
        stringBuffer.append("transient port =").append(this.transientPort);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

