/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorContext;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationToJsonProcessor;

class AggregationDataExtractor
implements DataExtractor {
    private static final Logger LOGGER = Loggers.getLogger(AggregationDataExtractor.class);
    private static int BATCH_KEY_VALUE_PAIRS = 1000;
    private final Client client;
    private final AggregationDataExtractorContext context;
    private boolean hasNext;
    private boolean isCancelled;
    private AggregationToJsonProcessor aggregationToJsonProcessor;
    private ByteArrayOutputStream outputStream;

    AggregationDataExtractor(Client client, AggregationDataExtractorContext dataExtractorContext) {
        this.client = Objects.requireNonNull(client);
        this.context = Objects.requireNonNull(dataExtractorContext);
        this.hasNext = true;
        this.isCancelled = false;
        this.outputStream = new ByteArrayOutputStream();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        LOGGER.trace("[{}] Data extractor received cancel request", (Object)this.context.jobId);
        this.isCancelled = true;
        this.hasNext = false;
    }

    public Optional<InputStream> next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.aggregationToJsonProcessor == null) {
            Aggregations aggs = this.search();
            if (aggs == null) {
                this.hasNext = false;
                return Optional.empty();
            }
            this.initAggregationProcessor(aggs);
        }
        return Optional.ofNullable(this.processNextBatch());
    }

    private Aggregations search() throws IOException {
        LOGGER.debug("[{}] Executing aggregated search", (Object)this.context.jobId);
        SearchResponse searchResponse = this.executeSearchRequest(this.buildSearchRequest());
        LOGGER.debug("[{}] Search response was obtained", (Object)this.context.jobId);
        ExtractorUtils.checkSearchWasSuccessful((String)this.context.jobId, (SearchResponse)searchResponse);
        return this.validateAggs(searchResponse.getAggregations());
    }

    private void initAggregationProcessor(Aggregations aggs) throws IOException {
        this.aggregationToJsonProcessor = new AggregationToJsonProcessor(this.context.timeField, this.context.fields, this.context.includeDocCount, this.context.start);
        this.aggregationToJsonProcessor.process(aggs);
    }

    protected SearchResponse executeSearchRequest(SearchRequestBuilder searchRequestBuilder) {
        return (SearchResponse)ClientHelper.executeWithHeaders(this.context.headers, (String)"ml", (Client)this.client, () -> ((SearchRequestBuilder)searchRequestBuilder).get());
    }

    private SearchRequestBuilder buildSearchRequest() {
        long histogramSearchStartTime = Math.max(0L, this.context.start - this.getHistogramInterval());
        SearchRequestBuilder searchRequestBuilder = SearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.client).setIndices(this.context.indices).setTypes(this.context.types).setSize(0).setQuery(ExtractorUtils.wrapInTimeRangeQuery((QueryBuilder)this.context.query, (String)this.context.timeField, (long)histogramSearchStartTime, (long)this.context.end));
        this.context.aggs.getAggregatorFactories().forEach(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addAggregation(arg_0));
        this.context.aggs.getPipelineAggregatorFactories().forEach(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addAggregation(arg_0));
        return searchRequestBuilder;
    }

    private Aggregations validateAggs(@Nullable Aggregations aggs) {
        if (aggs == null) {
            return null;
        }
        List aggsAsList = aggs.asList();
        if (aggsAsList.isEmpty()) {
            return null;
        }
        if (aggsAsList.size() > 1) {
            throw new IllegalArgumentException("Multiple top level aggregations not supported; found: " + aggsAsList.stream().map(Aggregation::getName).collect(Collectors.toList()));
        }
        return aggs;
    }

    private InputStream processNextBatch() throws IOException {
        this.outputStream.reset();
        this.hasNext = this.aggregationToJsonProcessor.writeDocs(BATCH_KEY_VALUE_PAIRS, this.outputStream);
        return new ByteArrayInputStream(this.outputStream.toByteArray());
    }

    private long getHistogramInterval() {
        return ExtractorUtils.getHistogramIntervalMillis((AggregatorFactories.Builder)this.context.aggs);
    }

    AggregationDataExtractorContext getContext() {
        return this.context;
    }
}

