/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.undo.UndoDeleteMarked;

public class DeleteMarkedPointsFunction
extends GenericFunction {
    private boolean _splitSegments = false;
    private String _parentFunctionKey = null;

    public DeleteMarkedPointsFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.deletemarked";
    }

    public void setParentFunction(String string, boolean bl) {
        this._parentFunctionKey = string;
        this._splitSegments = bl;
    }

    public void begin() {
        UndoDeleteMarked undoDeleteMarked = new UndoDeleteMarked(this._app.getTrackInfo().getTrack());
        int n = this._app.getTrackInfo().deleteMarkedPoints(this._splitSegments);
        if (n > 0) {
            undoDeleteMarked.setNumPointsDeleted(n);
            this._app.completeFunction(undoDeleteMarked, n + " " + (n == 1 ? I18nManager.getText("confirm.deletepoint.single") : I18nManager.getText("confirm.deletepoint.multi")));
        } else {
            String string = this._parentFunctionKey == null ? this.getNameKey() : this._parentFunctionKey;
            this._app.showErrorMessage(string, "dialog.deletemarked.nonefound");
        }
    }
}

