/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.I18nManager;

public class ProgressDialog {
    private JFrame _parentFrame = null;
    private String _titleKey = null;
    private JDialog _dialog = null;
    private JProgressBar _progressBar = null;
    private boolean _cancelled = false;

    public ProgressDialog(JFrame jFrame, String string) {
        this._parentFrame = jFrame;
        this._titleKey = string;
    }

    public void show() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this._titleKey), false);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._progressBar.setMinimum(0);
        this._progressBar.setMaximum(100);
        this._progressBar.setValue(0);
        this._progressBar.setIndeterminate(true);
        this._cancelled = false;
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText("confirm.running")), "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel2.setLayout(new BorderLayout());
        this._progressBar = new JProgressBar();
        this._progressBar.setPreferredSize(new Dimension(250, 30));
        jPanel2.add((Component)this._progressBar, "Center");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialog.this._cancelled = true;
                ProgressDialog.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public void setMaximum(int n) {
        this._progressBar.setMaximum(n);
        this._progressBar.setIndeterminate(n <= 1);
    }

    public void setValue(int n) {
        this._progressBar.setValue(n);
    }

    public void dispose() {
        this._dialog.dispose();
    }

    public boolean isCancelled() {
        return this._cancelled;
    }
}

