/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.AudioList;
import tim.prune.data.DataPoint;
import tim.prune.data.PhotoList;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoDeleteOperation;

public class UndoDeleteRange
extends UndoDeleteOperation {
    private RangeInfo _rangeInfo1 = null;
    private RangeInfo _rangeInfo2 = null;
    private PhotoList _photoList = null;
    private AudioList _audioList = null;
    private String _nameKey = null;
    private int _totalDeleted = 0;

    public UndoDeleteRange(TrackInfo trackInfo, String string, int n, boolean[] blArray, int n2, boolean[] blArray2) {
        int n3;
        int n4;
        this._nameKey = string;
        boolean bl = false;
        this._totalDeleted = 0;
        if (n >= 0 && blArray != null && (n4 = blArray.length) > 0) {
            this._totalDeleted += n4;
            this._rangeInfo1 = new RangeInfo();
            this._rangeInfo1._startIndex = n;
            n3 = 0;
            while (n3 < n4 && !bl) {
                if (blArray[n3]) {
                    bl = true;
                }
                ++n3;
            }
            this._rangeInfo1._points = trackInfo.getTrack().cloneRange(n, n + n4 - 1);
            this._rangeInfo1.setNextTrackPoint(trackInfo.getTrack().getNextTrackPoint(n + n4));
        }
        if (n2 >= 0 && blArray2 != null && (n4 = blArray2.length) > 0) {
            this._totalDeleted += n4;
            this._rangeInfo2 = new RangeInfo();
            this._rangeInfo2._startIndex = n2;
            n3 = 0;
            while (n3 < n4 && !bl) {
                if (blArray2[n3]) {
                    bl = true;
                }
                ++n3;
            }
            this._rangeInfo2._points = trackInfo.getTrack().cloneRange(n2, n2 + n4 - 1);
            this._rangeInfo2.setNextTrackPoint(trackInfo.getTrack().getNextTrackPoint(n2 + n4));
        }
        if (bl) {
            this._photoList = trackInfo.getPhotoList().cloneList();
            this._audioList = trackInfo.getAudioList().cloneList();
        }
    }

    public String getDescription() {
        return String.valueOf(I18nManager.getText(this._nameKey)) + " (" + this._totalDeleted + ")";
    }

    public void performUndo(TrackInfo trackInfo) {
        if (this._photoList != null) {
            trackInfo.getPhotoList().restore(this._photoList);
        }
        if (this._audioList != null) {
            trackInfo.getAudioList().restore(this._audioList);
        }
        this.performUndo(trackInfo, this._rangeInfo1);
        this.performUndo(trackInfo, this._rangeInfo2);
        if (this._rangeInfo1 != null && this._rangeInfo1.isValid()) {
            this.modifySelection(trackInfo, this._rangeInfo1._startIndex, this._rangeInfo1.getEndIndex());
        }
        if (this._rangeInfo2 != null && this._rangeInfo2.isValid()) {
            this.modifySelection(trackInfo, this._rangeInfo2._startIndex, this._rangeInfo2.getEndIndex());
        }
    }

    private void performUndo(TrackInfo trackInfo, RangeInfo rangeInfo) {
        if (rangeInfo == null || !rangeInfo.isValid()) {
            return;
        }
        int n = rangeInfo._points.length;
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = rangeInfo._points[n2];
            if (dataPoint != null && dataPoint.hasMedia()) {
                if (dataPoint.getPhoto() != null) {
                    dataPoint.getPhoto().setDataPoint(dataPoint);
                }
                if (dataPoint.getAudio() != null) {
                    dataPoint.getAudio().setDataPoint(dataPoint);
                }
            }
            ++n2;
        }
        trackInfo.getTrack().insertRange(rangeInfo._points, rangeInfo._startIndex);
        if (rangeInfo._nextTrackPoint != null) {
            rangeInfo._nextTrackPoint.setSegmentStart(rangeInfo._segmentStart);
        }
    }

    static class RangeInfo {
        public int _startIndex = -1;
        public DataPoint[] _points = null;
        public DataPoint _nextTrackPoint = null;
        public boolean _segmentStart = false;

        RangeInfo() {
        }

        public void setNextTrackPoint(DataPoint dataPoint) {
            this._nextTrackPoint = dataPoint;
            if (dataPoint != null) {
                this._segmentStart = dataPoint.getSegmentStart();
            }
        }

        public boolean isValid() {
            return this._startIndex >= 0 && this._points != null && this._points.length > 0;
        }

        public int getEndIndex() {
            return this._startIndex + this._points.length - 1;
        }
    }
}

