/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.options;

import com.sun.tools.visualvm.core.options.GeneralOptionsPanelController;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.core.options.UISupport;
import com.sun.tools.visualvm.core.ui.components.SectionSeparator;
import com.sun.tools.visualvm.core.ui.components.Spacer;
import com.sun.tools.visualvm.uisupport.JExtendedSpinner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class GeneralOptionsPanel
extends JPanel {
    private final GeneralOptionsPanelController controller;
    private final transient ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            GeneralOptionsPanel.this.controller.changed();
        }
    };
    private JLabel monitoredHostPLabel;
    private JSpinner monitoredHostPSpinner;
    private JLabel monitoredHostPUnits;
    private JLabel threadsPLabel;
    private JSpinner threadsPSpinner;
    private JLabel threadsPUnits;
    private JLabel monitoredDataPLabel;
    private JSpinner monitoredDataPSpinner;
    private JLabel monitoredDataPUnits;
    private JLabel monitoredHostCLabel;
    private JSpinner monitoredHostCSpinner;
    private JLabel monitoredHostCUnits;
    private JLabel monitoredDataCLabel;
    private JSpinner monitoredDataCSpinner;
    private JLabel monitoredDataCUnits;
    private JLabel resetDNSALabel;
    private JButton resetDNSAButton;

    GeneralOptionsPanel(GeneralOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.startTrackingChanges();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        SectionSeparator pollingSection = UISupport.createSectionSeparator(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Polling"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)pollingSection, c);
        this.monitoredHostPLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.monitoredHostPLabel, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Monitored_Host"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 0);
        this.add((Component)this.monitoredHostPLabel, c);
        this.monitoredHostPSpinner = new JExtendedSpinner();
        this.monitoredHostPLabel.setLabelFor(this.monitoredHostPSpinner);
        this.monitoredHostPSpinner.setModel(new SpinnerNumberModel(3, 1, 99999, 1));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(3, 40, 3, 4);
        this.add((Component)this.monitoredHostPSpinner, c);
        this.monitoredHostPUnits = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.monitoredHostPUnits, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Sec"));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.monitoredHostPUnits, c);
        this.threadsPLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.threadsPLabel, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Threads"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 0);
        this.add((Component)this.threadsPLabel, c);
        this.threadsPSpinner = new JExtendedSpinner();
        this.threadsPLabel.setLabelFor(this.threadsPSpinner);
        this.threadsPSpinner.setModel(new SpinnerNumberModel(1, 1, 99999, 1));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 40, 3, 4);
        this.add((Component)this.threadsPSpinner, c);
        this.threadsPUnits = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.threadsPUnits, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Sec"));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.threadsPUnits, c);
        this.monitoredDataPLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.monitoredDataPLabel, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Monitored_Data"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 0);
        this.add((Component)this.monitoredDataPLabel, c);
        this.monitoredDataPSpinner = new JExtendedSpinner();
        this.monitoredDataPLabel.setLabelFor(this.monitoredDataPSpinner);
        this.monitoredDataPSpinner.setModel(new SpinnerNumberModel(1, 1, 99999, 1));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(3, 40, 3, 4);
        this.add((Component)this.monitoredDataPSpinner, c);
        this.monitoredDataPUnits = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.monitoredDataPUnits, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Sec"));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.monitoredDataPUnits, c);
        SectionSeparator chartsCacheSection = UISupport.createSectionSeparator(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Charts_Cache"));
        c = new GridBagConstraints();
        c.gridy = 4;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(15, 0, 5, 0);
        this.add((Component)chartsCacheSection, c);
        this.monitoredHostCLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.monitoredHostCLabel, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Monitored_Host2"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 0);
        this.add((Component)this.monitoredHostCLabel, c);
        this.monitoredHostCSpinner = new JExtendedSpinner();
        this.monitoredHostCLabel.setLabelFor(this.monitoredHostCSpinner);
        this.monitoredHostCSpinner.setModel(new SpinnerNumberModel(60, 1, 99999, 1));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.anchor = 17;
        c.insets = new Insets(3, 40, 3, 4);
        this.add((Component)this.monitoredHostCSpinner, c);
        this.monitoredHostCUnits = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.monitoredHostCUnits, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_min"));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 5;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.monitoredHostCUnits, c);
        this.monitoredDataCLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.monitoredDataCLabel, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Monitored_Data2"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 17;
        c.insets = new Insets(3, 15, 3, 0);
        this.add((Component)this.monitoredDataCLabel, c);
        this.monitoredDataCSpinner = new JExtendedSpinner();
        this.monitoredDataCLabel.setLabelFor(this.monitoredDataCSpinner);
        this.monitoredDataCSpinner.setModel(new SpinnerNumberModel(60, 1, 99999, 1));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 6;
        c.anchor = 17;
        c.insets = new Insets(3, 40, 3, 4);
        this.add((Component)this.monitoredDataCSpinner, c);
        this.monitoredDataCUnits = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.monitoredDataCUnits, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_min"));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 6;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.monitoredDataCUnits, c);
        SectionSeparator profilerSection = UISupport.createSectionSeparator(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_Miscellaneous"));
        c = new GridBagConstraints();
        c.gridy = 7;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(15, 0, 5, 0);
        this.add((Component)profilerSection, c);
        JPanel resetDNSAPanel = new JPanel(new BorderLayout());
        this.resetDNSALabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.resetDNSALabel, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"MSG_Do_Not_Show_Again"));
        resetDNSAPanel.add((Component)this.resetDNSALabel, "Center");
        this.resetDNSAButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.resetDNSAButton, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"BTN_Reset"));
        resetDNSAPanel.add((Component)this.resetDNSAButton, "East");
        c = new GridBagConstraints();
        c.gridy = 8;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(2, 15, 2, 0);
        this.add((Component)resetDNSAPanel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 0;
        this.add((Component)Spacer.create(), c);
    }

    private void resetDNSAButtonAction() {
        ProfilerIDESettings.getInstance().clearDoNotShowAgainMap();
        this.resetDNSAButton.setEnabled(false);
    }

    void load() {
        GlobalPreferences preferences = GlobalPreferences.sharedInstance();
        this.resetDNSAButton.setEnabled(true);
        this.monitoredHostPSpinner.setValue(preferences.getMonitoredHostPoll());
        this.monitoredDataPSpinner.setValue(preferences.getMonitoredDataPoll());
        this.threadsPSpinner.setValue(preferences.getThreadsPoll());
        this.monitoredHostCSpinner.setValue(preferences.getMonitoredHostCache());
        this.monitoredDataCSpinner.setValue(preferences.getMonitoredDataCache());
    }

    void store() {
        GlobalPreferences preferences = GlobalPreferences.sharedInstance();
        preferences.setMonitoredHostPoll((Integer)this.monitoredHostPSpinner.getValue());
        preferences.setMonitoredDataPoll((Integer)this.monitoredDataPSpinner.getValue());
        preferences.setThreadsPoll((Integer)this.threadsPSpinner.getValue());
        preferences.setMonitoredHostCache((Integer)this.monitoredHostCSpinner.getValue());
        preferences.setMonitoredDataCache((Integer)this.monitoredDataCSpinner.getValue());
        preferences.store();
    }

    boolean valid() {
        try {
            int mh = (Integer)this.monitoredHostPSpinner.getValue();
            int md = (Integer)this.monitoredDataPSpinner.getValue();
            int th = (Integer)this.threadsPSpinner.getValue();
            int mhc = (Integer)this.monitoredHostCSpinner.getValue();
            int mdc = (Integer)this.monitoredDataCSpinner.getValue();
            return mh > 0 && md > 0 && th > 0 && mhc > 0 && mdc > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void startTrackingChanges() {
        this.monitoredHostPSpinner.getModel().addChangeListener(this.changeListener);
        this.threadsPSpinner.getModel().addChangeListener(this.changeListener);
        this.monitoredDataPSpinner.getModel().addChangeListener(this.changeListener);
        this.monitoredHostCSpinner.getModel().addChangeListener(this.changeListener);
        this.monitoredDataCSpinner.getModel().addChangeListener(this.changeListener);
        this.resetDNSAButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralOptionsPanel.this.resetDNSAButtonAction();
            }
        });
    }
}

