/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.mimelookup.impl.CompoundFolderChildren;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.spi.CustomInstanceFactory;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class FolderPathLookup
extends AbstractLookup {
    private static final String ATTR_ORIGINAL_FILE = "originalFile";
    private static final String EXTENSION_SHADOW = "shadow";
    private static final String ATTR_INSTANCE_OF = "instanceOf";
    private static final Logger LOG = Logger.getLogger(FolderPathLookup.class.getName());
    private final InstanceContent content;
    private final CompoundFolderChildren children;
    private final PCL listener = new PCL();
    private static final Map<FileObject, InstanceItem> fo2item = new HashMap<FileObject, InstanceItem>(128);
    private static volatile Lookup.Result<CustomInstanceFactory> factories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InstanceItem getInstanceItem(FileObject fileObject, InstanceItem instanceItem) {
        InstanceItem instanceItem2;
        Object object;
        Object object2 = fileObject;
        if (EXTENSION_SHADOW.equals(fileObject.getExt()) && (object = fileObject.getAttribute(ATTR_ORIGINAL_FILE)) instanceof String) {
            try {
                instanceItem2 = fileObject.getFileSystem().getRoot().getFileObject(object.toString());
                if (instanceItem2 != null) {
                    object2 = instanceItem2;
                } else {
                    LOG.warning("Dangling shadow found: " + fileObject.getPath() + " -> " + object);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOG.log(Level.WARNING, "Unexpected error accessing config file " + fileObject, fileStateInvalidException);
            }
        }
        object = fo2item;
        synchronized (object) {
            instanceItem2 = fo2item.get(fileObject);
            if (instanceItem2 == null || instanceItem2 == instanceItem) {
                instanceItem2 = new InstanceItem((FileObject)object2);
                fo2item.put(fileObject, instanceItem2);
            }
            return instanceItem2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseInstanceItem(InstanceItem instanceItem) {
        Map<FileObject, InstanceItem> map = fo2item;
        synchronized (map) {
            InstanceItem instanceItem2 = fo2item.remove(instanceItem.getFileObject());
            if (instanceItem2 != instanceItem) {
                fo2item.put(instanceItem.getFileObject(), instanceItem2);
            }
        }
    }

    public FolderPathLookup(String[] stringArray) {
        this(stringArray, new InstanceContent());
    }

    private FolderPathLookup(String[] stringArray, InstanceContent instanceContent) {
        super((AbstractLookup.Content)instanceContent);
        this.content = instanceContent;
        this.children = new CompoundFolderChildren(stringArray, false);
        this.children.addPropertyChangeListener(this.listener);
        this.rebuild();
    }

    private void rebuild() {
        ArrayList<PairItem> arrayList = new ArrayList<PairItem>();
        for (FileObject fileObject : this.children.getChildren()) {
            if (!fileObject.isValid()) continue;
            arrayList.add(new PairItem(fileObject));
        }
        this.content.setPairs(arrayList);
    }

    private static Collection<? extends CustomInstanceFactory> getInstanceFactories() {
        Lookup.Result<CustomInstanceFactory> result = factories;
        if (result != null) {
            return result.allInstances();
        }
        final Lookup.Result[] resultArray = new Lookup.Result[1];
        Lookups.executeWith(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                resultArray[0] = factories = Lookup.getDefault().lookupResult(CustomInstanceFactory.class);
            }
        });
        return resultArray[0].allInstances();
    }

    public static final <T> T createInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        CustomInstanceFactory customInstanceFactory;
        Object object = null;
        Object object2 = FolderPathLookup.getInstanceFactories().iterator();
        while (object2.hasNext() && (object = (customInstanceFactory = object2.next()).createInstance(clazz)) == null) {
        }
        if (object == null) {
            object2 = clazz.getDeclaredConstructor(new Class[0]);
            ((Constructor)object2).setAccessible(true);
            object = ((Constructor)object2).newInstance(new Object[0]);
        }
        return (T)object;
    }

    private static final class InstanceItem {
        static final long serialVersionUID = 10L;
        private final FileObject fo;
        private transient Reference<Object> ref;

        InstanceItem(FileObject fileObject) {
            assert (fileObject != null) : "FileObject must not be null";
            this.fo = fileObject;
        }

        FileObject getFileObject() {
            return this.fo;
        }

        private synchronized Reference<Object> getRef() {
            return this.ref;
        }

        private synchronized void setRef(Reference<Object> reference) {
            this.ref = reference;
        }

        protected boolean instanceOf(Class<?> clazz) {
            Object object;
            Reference<Object> reference = this.getRef();
            Object object2 = object = reference != null ? reference.get() : null;
            if (object != null) {
                return clazz.isInstance(object);
            }
            String string = (String)this.fo.getAttribute(FolderPathLookup.ATTR_INSTANCE_OF);
            if (string != null) {
                for (String string2 : string.split(",")) {
                    try {
                        if (!clazz.isAssignableFrom(Class.forName(string2, false, InstanceItem.loader()))) continue;
                        return true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOG.log(Level.FINE, "could not load " + string2 + " for " + this.fo.getPath(), classNotFoundException);
                    }
                }
                return false;
            }
            return clazz.isAssignableFrom(this.getType());
        }

        protected boolean creatorOf(Object object) {
            Reference<Object> reference = this.getRef();
            return reference != null ? reference.get() == object : false;
        }

        public synchronized Object getInstance() {
            Reference<Object> reference = this.getRef();
            Object object = null;
            if (reference != null && (object = reference.get()) == null) {
                return FolderPathLookup.getInstanceItem(this.fo, this).getInstance();
            }
            if (object == null && (object = InstanceItem.createInstanceFor(this.fo, Object.class)) != null) {
                this.setRef(new Ref(object));
            }
            return object;
        }

        public Class<? extends Object> getType() {
            Class<? extends Object> clazz = InstanceItem.findTypeFor(this.fo);
            return clazz != null ? clazz : Void.class;
        }

        public String getId() {
            String string = this.fo.getPath();
            if (string.endsWith(".instance")) {
                string = string.substring(0, string.length() - ".instance".length());
            }
            return string;
        }

        public String getDisplayName() {
            String string = this.fo.getName();
            try {
                string = this.fo.getFileSystem().getDecorator().annotateName(string, Collections.singleton(this.fo));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOG.log(Level.WARNING, fileStateInvalidException.getMessage(), fileStateInvalidException);
            }
            return string;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            InstanceItem instanceItem = (InstanceItem)object;
            return this.fo == instanceItem.fo || this.fo != null && this.fo.equals(instanceItem.fo);
        }

        public int hashCode() {
            return this.fo.hashCode();
        }

        private static ClassLoader loader() {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = InstanceItem.class.getClassLoader();
            }
            return classLoader;
        }

        static <T> T createInstanceFor(FileObject fileObject, Class<T> clazz) {
            Object object = fileObject.getAttribute("instanceCreate");
            if (object == null) {
                try {
                    Class<? extends Object> clazz2 = InstanceItem.findTypeFor(fileObject);
                    if (clazz2 == null) {
                        return null;
                    }
                    object = FolderPathLookup.createInstance(clazz2);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    Exceptions.printStackTrace((Throwable)reflectiveOperationException);
                }
            }
            return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
        }

        private static Class<? extends Object> findTypeFor(FileObject fileObject) {
            String string = InstanceItem.getClassName(fileObject);
            if (string == null) {
                return null;
            }
            try {
                return Class.forName(string, false, InstanceItem.loader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.FINE, classNotFoundException.getMessage(), classNotFoundException);
                return null;
            }
        }

        private static String getClassName(FileObject fileObject) {
            int n;
            Object object = fileObject.getAttribute("instanceClass");
            if (object instanceof String) {
                return BaseUtilities.translate((String)((String)object));
            }
            if (object != null) {
                LOG.warning("instanceClass was a " + object.getClass().getName());
            }
            if ((object = fileObject.getAttribute("instanceCreate")) != null) {
                return object.getClass().getName();
            }
            Object object2 = fileObject.getAttributes();
            while (object2.hasMoreElements()) {
                if (!((String)object2.nextElement()).equals("instanceCreate")) continue;
                return null;
            }
            object2 = fileObject.getName();
            int n2 = ((String)object2).indexOf(91) + 1;
            if (n2 != 0) {
                LOG.log(Level.WARNING, "Cannot understand {0}", fileObject);
            }
            if ((n = ((String)object2).indexOf(93)) < 0) {
                n = ((String)object2).length();
            }
            if (n2 < n) {
                object2 = ((String)object2).substring(n2, n);
            }
            object2 = ((String)object2).replace('-', '.');
            object2 = BaseUtilities.translate((String)object2);
            return object2;
        }

        void release() {
            FolderPathLookup.releaseInstanceItem(this);
        }

        private final class Ref
        extends WeakReference<Object>
        implements Runnable {
            Ref(Object object) {
                super(object, BaseUtilities.activeReferenceQueue());
            }

            @Override
            public void run() {
                InstanceItem.this.release();
            }
        }
    }

    private static final class PairItem
    extends AbstractLookup.Pair<Object> {
        private final InstanceItem instanceItem;

        PairItem(FileObject fileObject) {
            this.instanceItem = FolderPathLookup.getInstanceItem(fileObject, null);
            assert (this.instanceItem != null) : "InstanceItem must not be null";
        }

        protected boolean instanceOf(Class<?> clazz) {
            return this.instanceItem.instanceOf(clazz);
        }

        protected boolean creatorOf(Object object) {
            return this.instanceItem.creatorOf(object);
        }

        public Object getInstance() {
            return this.instanceItem.getInstance();
        }

        public Class<? extends Object> getType() {
            return this.instanceItem.getType();
        }

        public String getId() {
            return this.instanceItem.getId();
        }

        public String getDisplayName() {
            return this.instanceItem.getDisplayName();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            PairItem pairItem = (PairItem)((Object)object);
            return this.instanceItem.equals(pairItem.instanceItem);
        }

        public int hashCode() {
            int n = 3;
            n = 11 * n + this.instanceItem.hashCode();
            return n;
        }
    }

    private class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FolderPathLookup.this.rebuild();
        }
    }
}

