/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.url.BasicURLHandler;
import org.apache.ivy.util.url.URLHandler;

public class URLHandlerDispatcher
implements URLHandler {
    private Map handlers = new HashMap();
    private URLHandler defaultHandler = new BasicURLHandler();

    @Override
    public boolean isReachable(URL url) {
        return this.getHandler(url.getProtocol()).isReachable(url);
    }

    @Override
    public boolean isReachable(URL url, int timeout) {
        return this.getHandler(url.getProtocol()).isReachable(url, timeout);
    }

    @Override
    public long getContentLength(URL url) {
        return this.getHandler(url.getProtocol()).getContentLength(url);
    }

    @Override
    public long getContentLength(URL url, int timeout) {
        return this.getHandler(url.getProtocol()).getContentLength(url, timeout);
    }

    @Override
    public long getLastModified(URL url) {
        return this.getHandler(url.getProtocol()).getLastModified(url);
    }

    @Override
    public long getLastModified(URL url, int timeout) {
        return this.getHandler(url.getProtocol()).getLastModified(url, timeout);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getHandler(url.getProtocol()).getURLInfo(url);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        return this.getHandler(url.getProtocol()).getURLInfo(url, timeout);
    }

    @Override
    public InputStream openStream(URL url) throws IOException {
        return this.getHandler(url.getProtocol()).openStream(url);
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        this.getHandler(src.getProtocol()).download(src, dest, l);
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener l) throws IOException {
        this.getHandler(dest.getProtocol()).upload(src, dest, l);
    }

    @Override
    public void setRequestMethod(int requestMethod) {
        this.defaultHandler.setRequestMethod(requestMethod);
        for (URLHandler handler : this.handlers.values()) {
            handler.setRequestMethod(requestMethod);
        }
    }

    public void setDownloader(String protocol, URLHandler downloader) {
        this.handlers.put(protocol, downloader);
    }

    public URLHandler getHandler(String protocol) {
        URLHandler downloader = (URLHandler)this.handlers.get(protocol);
        return downloader == null ? this.defaultHandler : downloader;
    }

    public URLHandler getDefault() {
        return this.defaultHandler;
    }

    public void setDefault(URLHandler default1) {
        this.defaultHandler = default1;
    }
}

