/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;

public class RollupJobCaps
implements Writeable,
ToXContentObject {
    private static ParseField JOB_ID = new ParseField("job_id", new String[0]);
    private static ParseField ROLLUP_INDEX = new ParseField("rollup_index", new String[0]);
    private static ParseField INDEX_PATTERN = new ParseField("index_pattern", new String[0]);
    private static ParseField FIELDS = new ParseField("fields", new String[0]);
    private String jobID;
    private String rollupIndex;
    private String indexPattern;
    private Map<String, RollupFieldCaps> fieldCapLookup = new HashMap<String, RollupFieldCaps>();

    public RollupJobCaps(RollupJobConfig job) {
        Map<String, Object> histoAggCap;
        this.jobID = job.getId();
        this.rollupIndex = job.getRollupIndex();
        this.indexPattern = job.getIndexPattern();
        Map<String, Object> dateHistoAggCap = job.getGroupConfig().getDateHisto().toAggCap();
        String dateField = job.getGroupConfig().getDateHisto().getField();
        RollupFieldCaps fieldCaps = this.fieldCapLookup.get(dateField);
        if (fieldCaps == null) {
            fieldCaps = new RollupFieldCaps();
        }
        fieldCaps.addAgg(dateHistoAggCap);
        this.fieldCapLookup.put(dateField, fieldCaps);
        if (job.getGroupConfig().getHisto() != null) {
            histoAggCap = job.getGroupConfig().getHisto().toAggCap();
            Arrays.stream(job.getGroupConfig().getHisto().getFields()).forEach(field -> {
                RollupFieldCaps caps = this.fieldCapLookup.get(field);
                if (caps == null) {
                    caps = new RollupFieldCaps();
                }
                caps.addAgg(histoAggCap);
                this.fieldCapLookup.put((String)field, caps);
            });
        }
        if (job.getGroupConfig().getTerms() != null) {
            histoAggCap = job.getGroupConfig().getTerms().toAggCap();
            Arrays.stream(job.getGroupConfig().getTerms().getFields()).forEach(field -> {
                RollupFieldCaps caps = this.fieldCapLookup.get(field);
                if (caps == null) {
                    caps = new RollupFieldCaps();
                }
                caps.addAgg(histoAggCap);
                this.fieldCapLookup.put((String)field, caps);
            });
        }
        if (job.getMetricsConfig().size() > 0) {
            job.getMetricsConfig().forEach(metricConfig -> {
                List<Map<String, Object>> metrics = metricConfig.toAggCap();
                metrics.forEach(m -> {
                    RollupFieldCaps caps = this.fieldCapLookup.get(metricConfig.getField());
                    if (caps == null) {
                        caps = new RollupFieldCaps();
                    }
                    caps.addAgg((Map<String, Object>)m);
                    this.fieldCapLookup.put(metricConfig.getField(), caps);
                });
            });
        }
    }

    public RollupJobCaps(StreamInput in) throws IOException {
        this.jobID = in.readString();
        this.rollupIndex = in.readString();
        this.indexPattern = in.readString();
        this.fieldCapLookup = in.readMap(StreamInput::readString, RollupFieldCaps::new);
    }

    public Map<String, RollupFieldCaps> getFieldCaps() {
        return this.fieldCapLookup;
    }

    public String getRollupIndex() {
        return this.rollupIndex;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobID);
        out.writeString(this.rollupIndex);
        out.writeString(this.indexPattern);
        out.writeMap(this.fieldCapLookup, StreamOutput::writeString, (o, value) -> value.writeTo(o));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID.getPreferredName(), this.jobID);
        builder.field(ROLLUP_INDEX.getPreferredName(), this.rollupIndex);
        builder.field(INDEX_PATTERN.getPreferredName(), this.indexPattern);
        builder.startObject(FIELDS.getPreferredName());
        for (Map.Entry<String, RollupFieldCaps> fieldCap : this.fieldCapLookup.entrySet()) {
            builder.array(fieldCap.getKey(), new Object[]{fieldCap.getValue()});
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobCaps that = (RollupJobCaps)other;
        return Objects.equals(this.jobID, that.jobID) && Objects.equals(this.rollupIndex, that.rollupIndex) && Objects.equals(this.fieldCapLookup, that.fieldCapLookup);
    }

    public int hashCode() {
        return Objects.hash(this.jobID, this.rollupIndex, this.fieldCapLookup);
    }

    public static class RollupFieldCaps
    implements Writeable,
    ToXContentObject {
        private List<Map<String, Object>> aggs = new ArrayList<Map<String, Object>>();

        RollupFieldCaps() {
        }

        RollupFieldCaps(StreamInput in) throws IOException {
            int size = in.readInt();
            this.aggs = new ArrayList<Map<String, Object>>(size);
            for (int i = 0; i < size; ++i) {
                this.aggs.add(in.readMap());
            }
        }

        void addAgg(Map<String, Object> agg) {
            this.aggs.add(agg);
        }

        public List<Map<String, Object>> getAggs() {
            return this.aggs;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.aggs.size());
            for (Map<String, Object> agg : this.aggs) {
                out.writeMap(agg);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Map<String, Object> agg : this.aggs) {
                builder.map(agg);
            }
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RollupFieldCaps that = (RollupFieldCaps)other;
            return Objects.equals(this.aggs, that.aggs);
        }

        public int hashCode() {
            return Objects.hash(this.aggs);
        }
    }
}

