/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.security.user.InternalUserSerializationHelper;
import org.elasticsearch.xpack.core.security.user.User;

public class Authentication {
    private final User user;
    private final RealmRef authenticatedBy;
    private final RealmRef lookedUpBy;
    private final Version version;

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy) {
        this(user, authenticatedBy, lookedUpBy, Version.CURRENT);
    }

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy, Version version) {
        this.user = Objects.requireNonNull(user);
        this.authenticatedBy = Objects.requireNonNull(authenticatedBy);
        this.lookedUpBy = lookedUpBy;
        this.version = version;
    }

    public Authentication(StreamInput in) throws IOException {
        this.user = InternalUserSerializationHelper.readFrom(in);
        this.authenticatedBy = new RealmRef(in);
        this.lookedUpBy = in.readBoolean() ? new RealmRef(in) : null;
        this.version = in.getVersion();
    }

    public User getUser() {
        return this.user;
    }

    public RealmRef getAuthenticatedBy() {
        return this.authenticatedBy;
    }

    public RealmRef getLookedUpBy() {
        return this.lookedUpBy;
    }

    public Version getVersion() {
        return this.version;
    }

    public static Authentication readFromContext(ThreadContext ctx) throws IOException, IllegalArgumentException {
        Authentication authentication = (Authentication)ctx.getTransient("_xpack_security_authentication");
        if (authentication != null) {
            assert (ctx.getHeader("_xpack_security_authentication") != null);
            return authentication;
        }
        String authenticationHeader = ctx.getHeader("_xpack_security_authentication");
        if (authenticationHeader == null) {
            return null;
        }
        return Authentication.deserializeHeaderAndPutInContext(authenticationHeader, ctx);
    }

    public static Authentication getAuthentication(ThreadContext context) {
        return (Authentication)context.getTransient("_xpack_security_authentication");
    }

    static Authentication deserializeHeaderAndPutInContext(String header, ThreadContext ctx) throws IOException, IllegalArgumentException {
        assert (ctx.getTransient("_xpack_security_authentication") == null);
        Authentication authentication = Authentication.decode(header);
        ctx.putTransient("_xpack_security_authentication", (Object)authentication);
        return authentication;
    }

    public static Authentication decode(String header) throws IOException {
        byte[] bytes = Base64.getDecoder().decode(header);
        StreamInput input = StreamInput.wrap((byte[])bytes);
        Version version = Version.readVersion((StreamInput)input);
        input.setVersion(version);
        return new Authentication(input);
    }

    public void writeToContext(ThreadContext ctx) throws IOException, IllegalArgumentException {
        this.ensureContextDoesNotContainAuthentication(ctx);
        String header = this.encode();
        ctx.putTransient("_xpack_security_authentication", (Object)this);
        ctx.putHeader("_xpack_security_authentication", header);
    }

    void ensureContextDoesNotContainAuthentication(ThreadContext ctx) {
        if (ctx.getTransient("_xpack_security_authentication") != null) {
            if (ctx.getHeader("_xpack_security_authentication") == null) {
                throw new IllegalStateException("authentication present as a transient but not a header");
            }
            throw new IllegalStateException("authentication is already present in the context");
        }
    }

    public String encode() throws IOException {
        BytesStreamOutput output = new BytesStreamOutput();
        output.setVersion(this.version);
        Version.writeVersion((Version)this.version, (StreamOutput)output);
        this.writeTo((StreamOutput)output);
        return Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)output.bytes()));
    }

    public void writeTo(StreamOutput out) throws IOException {
        InternalUserSerializationHelper.writeTo(this.user, out);
        this.authenticatedBy.writeTo(out);
        if (this.lookedUpBy != null) {
            out.writeBoolean(true);
            this.lookedUpBy.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authentication that = (Authentication)o;
        if (!this.user.equals(that.user)) {
            return false;
        }
        if (!this.authenticatedBy.equals(that.authenticatedBy)) {
            return false;
        }
        if (this.lookedUpBy != null ? !this.lookedUpBy.equals(that.lookedUpBy) : that.lookedUpBy != null) {
            return false;
        }
        return this.version.equals((Object)that.version);
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = 31 * result + this.authenticatedBy.hashCode();
        result = 31 * result + (this.lookedUpBy != null ? this.lookedUpBy.hashCode() : 0);
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public static class RealmRef {
        private final String nodeName;
        private final String name;
        private final String type;

        public RealmRef(String name, String type, String nodeName) {
            this.nodeName = nodeName;
            this.name = name;
            this.type = type;
        }

        public RealmRef(StreamInput in) throws IOException {
            this.nodeName = in.readString();
            this.name = in.readString();
            this.type = in.readString();
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeName);
            out.writeString(this.name);
            out.writeString(this.type);
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmRef realmRef = (RealmRef)o;
            if (!this.nodeName.equals(realmRef.nodeName)) {
                return false;
            }
            if (!this.name.equals(realmRef.name)) {
                return false;
            }
            return this.type.equals(realmRef.type);
        }

        public int hashCode() {
            int result = this.nodeName.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

