/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.And;
import org.elasticsearch.xpack.sql.expression.predicate.Or;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;

public abstract class Predicates {
    public static List<Expression> splitAnd(Expression exp) {
        if (exp instanceof And) {
            And and = (And)exp;
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.addAll(Predicates.splitAnd(and.left()));
            list.addAll(Predicates.splitAnd(and.right()));
            return list;
        }
        return Collections.singletonList(exp);
    }

    public static List<Expression> splitOr(Expression exp) {
        if (exp instanceof Or) {
            Or or = (Or)exp;
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.addAll(Predicates.splitOr(or.left()));
            list.addAll(Predicates.splitOr(or.right()));
            return list;
        }
        return Collections.singletonList(exp);
    }

    public static Expression combineOr(List<Expression> exps) {
        return Predicates.combine(exps, (l, r) -> new Or(l.location(), (Expression)l, (Expression)r));
    }

    public static Expression combineAnd(List<Expression> exps) {
        return Predicates.combine(exps, (l, r) -> new And(l.location(), (Expression)l, (Expression)r));
    }

    private static Expression combine(List<Expression> exps, BiFunction<Expression, Expression, Expression> combiner) {
        if (exps.isEmpty()) {
            return null;
        }
        ArrayList<Expression> result = new ArrayList<Expression>(exps);
        while (result.size() > 1) {
            for (int i = 0; i < result.size() - 1; ++i) {
                Expression l = (Expression)result.remove(i);
                Expression r = (Expression)result.remove(i);
                result.add(i, combiner.apply(l, r));
            }
        }
        return (Expression)result.get(0);
    }

    public static List<Expression> inCommon(List<Expression> l, List<Expression> r) {
        ArrayList common = new ArrayList(Math.min(l.size(), r.size()));
        for (Expression lExp : l) {
            for (Expression rExp : r) {
                if (!lExp.semanticEquals(rExp)) continue;
                common.add(lExp);
            }
        }
        return common.isEmpty() ? Collections.emptyList() : common;
    }

    public static List<Expression> subtract(List<Expression> from, List<Expression> r) {
        ArrayList diff = new ArrayList(Math.min(from.size(), r.size()));
        for (Expression lExp : from) {
            for (Expression rExp : r) {
                if (lExp.semanticEquals(rExp)) continue;
                diff.add(lExp);
            }
        }
        return diff.isEmpty() ? Collections.emptyList() : diff;
    }

    public static boolean canEvaluate(Expression exp, LogicalPlan plan) {
        return exp.references().subsetOf(plan.outputSet());
    }
}

