/*
 * Decompiled with CFR 0.152.
 */
package plugins.collaboration.socket;

import freemind.common.NumberProperty;
import freemind.common.StringProperty;
import freemind.controller.actions.generated.instance.CollaborationActionBase;
import freemind.controller.actions.generated.instance.CollaborationGoodbye;
import freemind.controller.actions.generated.instance.CollaborationUserInformation;
import freemind.extensions.DontSaveMarker;
import freemind.extensions.PermanentNodeHook;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.NodeView;
import java.io.IOException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import plugins.collaboration.socket.ServerCommunication;
import plugins.collaboration.socket.SocketBasics;
import plugins.collaboration.socket.TerminateableThread;

public class MindMapMaster
extends SocketBasics
implements PermanentNodeHook,
DontSaveMarker {
    public static final int SOCKET_TIMEOUT_IN_MILLIES = 500;
    MasterThread mListener = null;
    ServerSocket mServer;
    Vector mConnections = new Vector();
    protected boolean mLockEnabled = false;
    private String mLockMutex = "";
    private int mPort;
    private String mLockId;
    private long mLockedAt;
    private String mLockUserName;
    private boolean mMasterStarted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeConnection(ServerCommunication client) {
        Vector vector = this.mConnections;
        synchronized (vector) {
            this.mConnections.remove(client);
        }
        this.setTitle();
    }

    protected void setTitle() {
        this.getMindMapController().getController().setTitle();
    }

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        if (this.mMasterStarted) {
            return;
        }
        MindMapController controller = this.getMindMapController();
        final StringProperty passwordProperty = new StringProperty("plugins.collaboration.socket.SocketBasics.password.description", "plugins.collaboration.socket.SocketBasics.password");
        final StringProperty passwordProperty2 = new StringProperty("plugins.collaboration.socket.SocketBasics.password_verification_description", "plugins.collaboration.socket.SocketBasics.password_verification");
        NumberProperty portProperty = this.getPortProperty();
        Vector<Object> controls = new Vector<Object>();
        controls.add(passwordProperty);
        controls.add(passwordProperty2);
        controls.add(portProperty);
        SocketBasics.FormDialog dialog = new SocketBasics.FormDialog(controller);
        dialog.setUp(controls, new SocketBasics.FormDialogValidator(){

            @Override
            public boolean isValid() {
                SocketBasics.logger.finest("Output valid?");
                return Tools.safeEquals((String)passwordProperty.getValue(), (String)passwordProperty2.getValue());
            }
        });
        if (!dialog.isSuccess()) {
            this.switchMeOff();
            return;
        }
        this.setPortProperty(portProperty);
        this.mPassword = passwordProperty.getValue();
        logger.info("Start server...");
        this.mMasterStarted = true;
        try {
            this.mPort = this.getPortProperty().getIntValue();
            this.mServer = new ServerSocket(this.mPort);
            this.mServer.setSoTimeout(500);
            this.mListener = new MasterThread();
            this.mListener.start();
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            controller.getController().errorMessage((Object)Resources.getInstance().format("plugins.collaboration.socket.SocketBasics.socket_creation_exception", new Object[]{portProperty.getValue(), e.getMessage()}));
            this.switchMeOff();
            return;
        }
        this.registerFilter();
        logger.info("Starting server. Done.");
        this.setTitle();
    }

    public void switchMeOff() {
        final MindMapController mindMapController = this.getMindMapController();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SocketBasics.togglePermanentHook(mindMapController, "plugins/collaboration/socket/socket_master_plugin");
            }
        });
    }

    public void loadFrom(XMLElement pChild) {
    }

    public void save(XMLElement pXml) {
    }

    @Override
    public void shutdownMapHook() {
        this.deregisterFilter();
        if (this.mListener != null) {
            this.signalEndOfSession();
            this.mListener.commitSuicide();
        }
        try {
            if (this.mServer != null) {
                this.mServer.close();
            }
        }
        catch (IOException e) {
            Resources.getInstance().logException((Throwable)e);
        }
        this.mMasterStarted = false;
        super.shutdownMapHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalEndOfSession() {
        CollaborationGoodbye goodbye = new CollaborationGoodbye();
        goodbye.setUserId(Tools.getUserName());
        Vector vector = this.mConnections;
        synchronized (vector) {
            for (int i = 0; i < this.mConnections.size(); ++i) {
                ServerCommunication serverCommunication = (ServerCommunication)this.mConnections.elementAt(i);
                try {
                    serverCommunication.send((CollaborationActionBase)goodbye);
                    serverCommunication.commitSuicide();
                    serverCommunication.close();
                    continue;
                }
                catch (IOException e) {
                    Resources.getInstance().logException((Throwable)e);
                }
            }
            this.mConnections.clear();
        }
    }

    public void onAddChild(MindMapNode pAddedChildNode) {
    }

    public void onAddChildren(MindMapNode pAddedChild) {
    }

    public void onLostFocusNode(NodeView pNodeView) {
    }

    public void onNewChild(MindMapNode pNewChildNode) {
    }

    public void onRemoveChild(MindMapNode pOldChildNode) {
    }

    public void onRemoveChildren(MindMapNode pOldChildNode, MindMapNode pOldDad) {
    }

    public void onFocusNode(NodeView pNodeView) {
    }

    public void onUpdateChildrenHook(MindMapNode pUpdatedNode) {
    }

    public void onUpdateNodeHook() {
    }

    public void onViewCreatedHook(NodeView pNodeView) {
    }

    public void onViewRemovedHook(NodeView pNodeView) {
    }

    @Override
    public Integer getRole() {
        return ROLE_MASTER;
    }

    @Override
    public int getPort() {
        return this.mPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String lock(String pUserName) throws SocketBasics.UnableToGetLockException, InterruptedException {
        String string = this.mLockMutex;
        synchronized (string) {
            String lockId;
            if (this.mLockEnabled) {
                throw new SocketBasics.UnableToGetLockException();
            }
            this.mLockEnabled = true;
            this.mLockId = lockId = "Lock_" + Math.random();
            this.mLockedAt = System.currentTimeMillis();
            this.mLockUserName = pUserName;
            logger.info("New lock " + lockId + " by " + this.mLockUserName);
            return lockId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void broadcastCommand(String pDoAction, String pUndoAction, String pLockId) throws Exception {
        Vector vector = this.mConnections;
        synchronized (vector) {
            for (int i = 0; i < this.mConnections.size(); ++i) {
                ((ServerCommunication)this.mConnections.elementAt(i)).sendCommand(pDoAction, pUndoAction, pLockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unlock() {
        String string = this.mLockMutex;
        synchronized (string) {
            if (!this.mLockEnabled) {
                throw new IllegalStateException();
            }
            logger.fine("Release lock " + this.mLockId + " held by " + this.mLockUserName);
            this.clearLock();
        }
    }

    public void clearLock() {
        this.mLockEnabled = false;
        this.mLockId = "none";
        this.mLockUserName = null;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockId() {
        String string = this.mLockMutex;
        synchronized (string) {
            if (!this.mLockEnabled) {
                throw new IllegalStateException();
            }
            return this.mLockId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsers() {
        StringBuffer users = new StringBuffer(Tools.getUserName());
        Vector vector = this.mConnections;
        synchronized (vector) {
            for (int i = 0; i < this.mConnections.size(); ++i) {
                users.append(',');
                users.append(' ');
                users.append(((ServerCommunication)this.mConnections.elementAt(i)).getName());
            }
        }
        return users.toString();
    }

    @Override
    public CollaborationUserInformation getMasterInformation() {
        CollaborationUserInformation userInfo = new CollaborationUserInformation();
        userInfo.setUserIds(this.getUsers());
        userInfo.setMasterHostname(Tools.getHostName());
        userInfo.setMasterPort(this.getPort());
        userInfo.setMasterIp(Tools.getHostIpAsString());
        return userInfo;
    }

    public void processUnfinishedLinks() {
    }

    public void saveHtml(Writer pFileout) {
    }

    private class MasterThread
    extends TerminateableThread {
        private static final long TIME_BETWEEN_USER_INFORMATION_IN_MILLIES = 5000L;
        private static final long TIME_FOR_ORPHANED_LOCK = 5000L;
        private long mLastTimeUserInformationSent;

        public MasterThread() {
            super("Master");
            this.mLastTimeUserInformationSent = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean processAction() throws Exception {
            Object object;
            try {
                logger.finest("Waiting for message");
                Socket client = MindMapMaster.this.mServer.accept();
                logger.info("Received new client.");
                client.setSoTimeout(500);
                ServerCommunication c = new ServerCommunication(MindMapMaster.this, client, MindMapMaster.this.getMindMapController());
                c.start();
                object = MindMapMaster.this.mConnections;
                synchronized (object) {
                    MindMapMaster.this.mConnections.addElement(c);
                }
            }
            catch (SocketTimeoutException e) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            if (now - this.mLastTimeUserInformationSent > 5000L) {
                this.mLastTimeUserInformationSent = now;
                CollaborationUserInformation userInfo = MindMapMaster.this.getMasterInformation();
                Vector vector = MindMapMaster.this.mConnections;
                synchronized (vector) {
                    for (int i = 0; i < MindMapMaster.this.mConnections.size(); ++i) {
                        try {
                            ServerCommunication connection = (ServerCommunication)MindMapMaster.this.mConnections.elementAt(i);
                            userInfo.setMasterIp(connection.getIpToSocket());
                            connection.send((CollaborationActionBase)userInfo);
                            continue;
                        }
                        catch (Exception e) {
                            Resources.getInstance().logException((Throwable)e);
                        }
                    }
                }
            }
            object = MindMapMaster.this.mLockMutex;
            synchronized (object) {
                if (MindMapMaster.this.mLockEnabled && now - MindMapMaster.this.mLockedAt > 5000L) {
                    logger.warning("Release lock " + MindMapMaster.this.mLockId + " held by " + MindMapMaster.this.mLockUserName);
                    MindMapMaster.this.clearLock();
                }
            }
            return true;
        }
    }
}

