/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.IncrementalJsCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.TranslationResultMap;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesFqNameMap;
import org.jetbrains.kotlin.incremental.storage.SourceToFqNameMap;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"J\u0016\u0010&\u001a\u00020 2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(H\u0016J\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020+0*J\u0018\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0002H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000bj\b\u0012\u0004\u0012\u00020\u0004`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/name/FqName;", "cachesDir", "Ljava/io/File;", "(Ljava/io/File;)V", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "dirtySources", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "value", "", "header", "getHeader", "()[B", "setHeader", "([B)V", "headerFile", "getHeaderFile", "()Ljava/io/File;", "inlineFunctions", "Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "translationResults", "Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "clearCacheForRemovedClasses", "", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "compareAndUpdate", "incrementalResults", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumerImpl;", "markDirty", "removedAndCompiledSources", "", "nonDirtyPackageParts", "", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "registerOutputForFile", "srcFile", "name", "Companion", "kotlin-build-common"})
public class IncrementalJsCache
extends AbstractIncrementalCache<FqName> {
    @NotNull
    private final SourceToFqNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesFqNameMap dirtyOutputClassesMap;
    private final TranslationResultMap translationResults;
    private final InlineFunctionsMap inlineFunctions;
    private final HashSet<File> dirtySources;
    private static final String TRANSLATION_RESULT_MAP = "translation-result";
    private static final String INLINE_FUNCTIONS = "inline-functions";
    private static final String HEADER_FILE_NAME = "header.meta";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public SourceToFqNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesFqNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getHeaderFile() {
        return new File(this.getCachesDir(), HEADER_FILE_NAME);
    }

    @NotNull
    public final byte[] getHeader() {
        return FilesKt.readBytes((File)this.getHeaderFile());
    }

    public final void setHeader(@NotNull byte[] value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.getCachesDir().mkdirs();
        FilesKt.writeBytes((File)this.getHeaderFile(), (byte[])value);
    }

    @Override
    public void markDirty(@NotNull Collection<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        super.markDirty(removedAndCompiledSources);
        this.dirtySources.addAll(removedAndCompiledSources);
    }

    /*
     * WARNING - void declaration
     */
    public final void compareAndUpdate(@NotNull IncrementalResultsConsumerImpl incrementalResults, @NotNull ChangesCollector changesCollector) {
        Object srcFile;
        Object object;
        Map<File, TranslationResultValue> translatedFiles;
        Intrinsics.checkParameterIsNotNull((Object)incrementalResults, (String)"incrementalResults");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Map<File, TranslationResultValue> map2 = translatedFiles = incrementalResults.getPackageParts();
        for (Map.Entry<File, TranslationResultValue> entry : map2.entrySet()) {
            void binaryMetadata;
            Map<ClassId, ProtoData> newProtoMap;
            Object it;
            Object object2;
            byte[] binaryAst;
            block7: {
                block6: {
                    Map<ClassId, ProtoData> map3;
                    object = entry;
                    srcFile = object.getKey();
                    object = entry;
                    TranslationResultValue data = object.getValue();
                    this.dirtySources.remove(srcFile);
                    TranslationResultValue translationResultValue = data;
                    object = translationResultValue.component1();
                    binaryAst = translationResultValue.component2();
                    object2 = this.translationResults.get((File)srcFile);
                    if (object2 == null) break block6;
                    byte[] byArray = ((TranslationResultValue)object2).getMetadata();
                    object2 = byArray;
                    if (byArray != null && (object2 = IncrementalJsCacheKt.getProtoData((File)srcFile, (byte[])(it = (map3 = object2)))) != null) break block7;
                }
                object2 = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = object2;
            Map<ClassId, ProtoData> map4 = newProtoMap = IncrementalJsCacheKt.getProtoData((File)srcFile, (byte[])binaryMetadata);
            Iterator<Map.Entry<ClassId, ProtoData>> iterator2 = map4.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object3 = it = iterator2.next();
                ClassId classId = (ClassId)object3.getKey();
                object3 = it;
                ProtoData protoData = (ProtoData)object3.getValue();
                FqName fqName2 = classId.asSingleFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.asSingleFqName()");
                this.registerOutputForFile((File)srcFile, fqName2);
                if (!(protoData instanceof ClassProtoData)) continue;
                this.addToClassStorage(((ClassProtoData)protoData).getProto(), ((ClassProtoData)protoData).getNameResolver(), (File)srcFile);
            }
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, 4, null);
            }
            this.translationResults.put((File)srcFile, (byte[])binaryMetadata, binaryAst);
        }
        srcFile = incrementalResults.getInlineFunctions();
        for (Map.Entry<File, Object> entry : srcFile.entrySet()) {
            object = entry;
            srcFile = object.getKey();
            object = entry;
            Map inlineDeclarations = (Map)object.getValue();
            this.inlineFunctions.process((File)srcFile, inlineDeclarations, changesCollector);
        }
    }

    private final void registerOutputForFile(File srcFile, FqName name) {
        this.getSourceToClassesMap$kotlin_build_common().add(srcFile, name);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(name);
    }

    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Iterable $receiver$iv = this.dirtySources;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.translationResults.remove(it, changesCollector);
            this.inlineFunctions.remove(it);
        }
        this.removeAllFromClassStorage(this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses(), changesCollector);
        this.dirtySources.clear();
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
    }

    @NotNull
    public final Map<File, TranslationResultValue> nonDirtyPackageParts() {
        HashMap<File, TranslationResultValue> hashMap;
        HashMap<File, TranslationResultValue> $receiver = hashMap = new HashMap<File, TranslationResultValue>();
        for (String path2 : this.translationResults.keys()) {
            File file2 = new File(path2);
            if (this.dirtySources.contains(file2)) continue;
            TranslationResultValue translationResultValue = this.translationResults.get(path2);
            if (translationResultValue == null) {
                Intrinsics.throwNpe();
            }
            $receiver.put(file2, translationResultValue);
        }
        return hashMap;
    }

    public IncrementalJsCache(@NotNull File cachesDir) {
        Intrinsics.checkParameterIsNotNull((Object)cachesDir, (String)"cachesDir");
        super(cachesDir);
        this.sourceToClassesMap = (SourceToFqNameMap)this.registerMap((BasicMap)new SourceToFqNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getSOURCE_TO_CLASSES())));
        this.dirtyOutputClassesMap = (DirtyClassesFqNameMap)this.registerMap((BasicMap)new DirtyClassesFqNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.translationResults = (TranslationResultMap)this.registerMap((BasicMap)new TranslationResultMap(this.getStorageFile(TRANSLATION_RESULT_MAP)));
        this.inlineFunctions = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(INLINE_FUNCTIONS)));
        IncrementalJsCache incrementalJsCache = this;
        HashSet hashSet = new HashSet();
        incrementalJsCache.dirtySources = hashSet;
    }

    static {
        TRANSLATION_RESULT_MAP = TRANSLATION_RESULT_MAP;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        HEADER_FILE_NAME = HEADER_FILE_NAME;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache$Companion;", "", "()V", "HEADER_FILE_NAME", "", "INLINE_FUNCTIONS", "TRANSLATION_RESULT_MAP", "hasHeaderFile", "", "cachesDir", "Ljava/io/File;", "kotlin-build-common"})
    public static final class Companion {
        public final boolean hasHeaderFile(@NotNull File cachesDir) {
            Intrinsics.checkParameterIsNotNull((Object)cachesDir, (String)"cachesDir");
            return new File(cachesDir, HEADER_FILE_NAME).exists();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

