/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.DefaultPropertyTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u001bH\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/PropertyTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "accessorDescription", "", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "createFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "generateDefaultAccessor", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "function", "generateDefaultGetter", "generateDefaultSetter", "generateGetter", "generateSetter", "getCustomGetterDeclaration", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getCustomSetterDeclaration", "translate", "", "result", "", "translateCustomAccessor", "expression", "js.translator"})
final class PropertyTranslator
extends AbstractTranslator {
    @NotNull
    private final VariableDescriptorWithAccessors descriptor;
    @Nullable
    private final KtProperty declaration;

    public final void translate(@NotNull List<JsPropertyInitializer> result2) {
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        PropertyTranslatorKt.addGetterAndSetter(result2, this.descriptor, (Function0<? extends JsPropertyInitializer>)((Function0)new Function0<JsPropertyInitializer>(this){
            final /* synthetic */ PropertyTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return PropertyTranslator.access$generateGetter(this.this$0);
            }
            {
                this.this$0 = propertyTranslator;
                super(0);
            }
        }), (Function0<? extends JsPropertyInitializer>)((Function0)new Function0<JsPropertyInitializer>(this){
            final /* synthetic */ PropertyTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return PropertyTranslator.access$generateSetter(this.this$0);
            }
            {
                this.this$0 = propertyTranslator;
                super(0);
            }
        }));
    }

    private final JsPropertyInitializer generateGetter() {
        KtProperty ktProperty = this.declaration;
        return (ktProperty != null ? PropertyTranslatorKt.hasCustomGetter(ktProperty) : false) ? this.translateCustomAccessor(this.getCustomGetterDeclaration()) : this.generateDefaultGetter();
    }

    private final JsPropertyInitializer generateSetter() {
        KtProperty ktProperty = this.declaration;
        return (ktProperty != null ? PropertyTranslatorKt.hasCustomSetter(ktProperty) : false) ? this.translateCustomAccessor(this.getCustomSetterDeclaration()) : this.generateDefaultSetter();
    }

    private final KtPropertyAccessor getCustomGetterDeclaration() {
        KtDeclarationStub ktDeclarationStub = this.declaration;
        if (ktDeclarationStub == null || (ktDeclarationStub = ktDeclarationStub.getGetter()) == null) {
            throw (Throwable)new IllegalStateException("declaration and getter should not be null descriptor=" + this.descriptor + " declaration=" + this.declaration);
        }
        return ktDeclarationStub;
    }

    private final KtPropertyAccessor getCustomSetterDeclaration() {
        KtDeclarationStub ktDeclarationStub = this.declaration;
        if (ktDeclarationStub == null || (ktDeclarationStub = ktDeclarationStub.getSetter()) == null) {
            throw (Throwable)new IllegalStateException("declaration and setter should not be null descriptor=" + this.descriptor + " declaration=" + this.declaration);
        }
        return ktDeclarationStub;
    }

    private final JsPropertyInitializer generateDefaultGetter() {
        JsFunction jsFunction;
        VariableAccessorDescriptor variableAccessorDescriptor = this.descriptor.getGetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)new IllegalStateException("Getter descriptor should not be null");
        }
        VariableAccessorDescriptor getterDescriptor = variableAccessorDescriptor;
        JsFunction $receiver = jsFunction = this.createFunction(getterDescriptor);
        JsNameRef delegateRef = new JsNameRef(this.context().getNameForBackingField(this.descriptor), (JsExpression)new JsThisRef());
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context()");
        new DefaultPropertyTranslator(this.descriptor, translationContext, delegateRef).generateDefaultGetterFunction(getterDescriptor, $receiver);
        JsFunction defaultFunction = jsFunction;
        return this.generateDefaultAccessor(getterDescriptor, defaultFunction);
    }

    private final JsPropertyInitializer generateDefaultSetter() {
        JsFunction jsFunction;
        VariableAccessorDescriptor variableAccessorDescriptor = this.descriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)new IllegalStateException("Setter descriptor should not be null");
        }
        VariableAccessorDescriptor setterDescriptor = variableAccessorDescriptor;
        JsFunction $receiver = jsFunction = this.createFunction(setterDescriptor);
        JsNameRef delegateRef = new JsNameRef(this.context().getNameForBackingField(this.descriptor), (JsExpression)new JsThisRef());
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context()");
        new DefaultPropertyTranslator(this.descriptor, translationContext, delegateRef).generateDefaultSetterFunction(setterDescriptor, $receiver);
        JsFunction defaultFunction = jsFunction;
        return this.generateDefaultAccessor(setterDescriptor, defaultFunction);
    }

    private final JsPropertyInitializer generateDefaultAccessor(VariableAccessorDescriptor accessorDescriptor, JsFunction function2) {
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function2, accessorDescriptor, this.context());
        Intrinsics.checkExpressionValueIsNotNull((Object)jsPropertyInitializer, (String)"translateFunctionAsEcma5\u2026sorDescriptor, context())");
        return jsPropertyInitializer;
    }

    private final JsPropertyInitializer translateCustomAccessor(KtPropertyAccessor expression2) {
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(this.bindingContext(), expression2);
        JsFunction function2 = new JsFunction(this.context().getScopeForDescriptor(descriptor2), new JsBlock(), descriptor2.toString());
        function2.setSource(UtilsKt.getFinalElement(expression2));
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context()");
        FunctionDescriptor functionDescriptor = descriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"descriptor");
        List<JsParameter> list2 = function2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.parameters");
        FunctionTranslatorKt.translateFunction(FunctionTranslatorKt.translateAndAliasParameters(translationContext, functionDescriptor, list2), expression2, function2);
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function2, descriptor2, this.context());
        Intrinsics.checkExpressionValueIsNotNull((Object)jsPropertyInitializer, (String)"translateFunctionAsEcma5\u2026n, descriptor, context())");
        return jsPropertyInitializer;
    }

    private final JsFunction createFunction(VariableAccessorDescriptor descriptor2) {
        JsFunction function2 = new JsFunction(this.context().getScopeForDescriptor(descriptor2), new JsBlock(), this.accessorDescription(descriptor2));
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
        PsiElement psiElement = KotlinSourceElementKt.getPsi(sourceElement);
        function2.setSource(psiElement != null ? UtilsKt.getFinalElement(psiElement) : null);
        return function2;
    }

    private final String accessorDescription(VariableAccessorDescriptor accessorDescriptor) {
        String string;
        VariableAccessorDescriptor variableAccessorDescriptor = accessorDescriptor;
        if (variableAccessorDescriptor instanceof PropertyGetterDescriptor || variableAccessorDescriptor instanceof LocalVariableAccessorDescriptor.Getter) {
            string = "getter";
        } else if (variableAccessorDescriptor instanceof PropertySetterDescriptor || variableAccessorDescriptor instanceof LocalVariableAccessorDescriptor.Setter) {
            string = "setter";
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown accessor type " + accessorDescriptor.getClass());
        }
        String accessorType = string;
        String name = accessorDescriptor.getName().asString();
        return accessorType + " for " + name;
    }

    @NotNull
    public final VariableDescriptorWithAccessors getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public final KtProperty getDeclaration() {
        return this.declaration;
    }

    public PropertyTranslator(@NotNull VariableDescriptorWithAccessors descriptor2, @Nullable KtProperty declaration, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.descriptor = descriptor2;
        this.declaration = declaration;
    }

    @NotNull
    public static final /* synthetic */ JsPropertyInitializer access$generateGetter(PropertyTranslator $this) {
        return $this.generateGetter();
    }

    @NotNull
    public static final /* synthetic */ JsPropertyInitializer access$generateSetter(PropertyTranslator $this) {
        return $this.generateSetter();
    }
}

