/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.language.base.internal.tasks.StaleClassCleaner;

public class SimpleStaleClassCleaner
extends StaleClassCleaner {
    private final Set<File> filesToDelete;
    private final Set<File> toClean = Sets.newHashSet();
    private final Set<String> prefixes = Sets.newHashSet();
    private final Queue<File> directoriesToDelete = new PriorityQueue<File>(10, (Comparator<File>)Ordering.natural().reverse());
    private boolean didWork;

    public SimpleStaleClassCleaner(TaskOutputsInternal taskOutputs) {
        this(taskOutputs.getPreviousOutputFiles());
    }

    public SimpleStaleClassCleaner(Set<File> filesToDelete) {
        this.filesToDelete = filesToDelete;
    }

    @Override
    public void addDirToClean(File toClean) {
        this.toClean.add(toClean);
        this.prefixes.add(toClean.getAbsolutePath() + File.separator);
    }

    @Override
    public void execute() {
        for (File f : this.filesToDelete) {
            for (String prefix : this.prefixes) {
                if (!f.getAbsolutePath().startsWith(prefix) || !f.isFile()) continue;
                this.didWork |= f.delete();
                this.markParentDir(f);
            }
        }
        while (!this.directoriesToDelete.isEmpty()) {
            File directory = this.directoriesToDelete.poll();
            if (!this.isEmpty(directory)) continue;
            this.didWork |= directory.delete();
            this.markParentDir(directory);
        }
    }

    private void markParentDir(File f) {
        File parentDir = f.getParentFile();
        if (parentDir != null && !this.toClean.contains(parentDir)) {
            this.directoriesToDelete.add(parentDir);
        }
    }

    private boolean isEmpty(File parentDir) {
        String[] children = parentDir.list();
        return children != null && children.length == 0;
    }

    public boolean getDidWork() {
        return this.didWork;
    }
}

