/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.gradle.api.internal.collections.AbstractIterationOrderRetainingElementSource;
import org.gradle.api.internal.collections.IndexedElementSource;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;

public class ListElementSource<T>
extends AbstractIterationOrderRetainingElementSource<T>
implements IndexedElementSource<T> {
    private final Spec<AbstractIterationOrderRetainingElementSource.Element<T>> alwaysAccept = new Spec<AbstractIterationOrderRetainingElementSource.Element<T>>(){

        public boolean isSatisfiedBy(AbstractIterationOrderRetainingElementSource.Element<T> element) {
            return true;
        }
    };

    @Override
    public Iterator<T> iterator() {
        this.realizePending();
        return this.listIterator();
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return new RealizedElementListIterator(this.getInserted(), this.alwaysAccept);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return Lists.newArrayList(this.listIterator()).listIterator(index);
    }

    @Override
    public List<? extends T> subList(int fromIndex, int toIndex) {
        return Lists.newArrayList(this.listIterator()).subList(fromIndex, toIndex);
    }

    private List<T> asList() {
        return Lists.newArrayList(this.listIterator());
    }

    @Override
    public T get(int index) {
        return this.asList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.asList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.asList().lastIndexOf(o);
    }

    @Override
    public boolean add(T element) {
        return this.getInserted().add(new AbstractIterationOrderRetainingElementSource.CachingElement<T>(element));
    }

    @Override
    public boolean addRealized(T value) {
        return true;
    }

    @Override
    public boolean addPending(ProviderInternal<? extends T> provider) {
        return this.getInserted().add(this.cachingElement(provider));
    }

    private ListIterator<T> iteratorAt(int index) {
        ListIterator<T> iterator = this.listIterator();
        while (iterator.previousIndex() < index && iterator.hasNext()) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public void add(int index, T element) {
        ListIterator<T> iterator = this.iteratorAt(index - 1);
        if (iterator.nextIndex() != index) {
            throw new IndexOutOfBoundsException();
        }
        iterator.add(element);
    }

    @Override
    public T set(int index, T element) {
        ListIterator<T> iterator = this.iteratorAt(index - 1);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        T previous = iterator.next();
        iterator.set(element);
        return previous;
    }

    @Override
    public T remove(int index) {
        ListIterator<T> iterator = this.iteratorAt(index - 1);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        T previous = iterator.next();
        iterator.remove();
        return previous;
    }

    private static class RealizedElementListIterator<T>
    extends AbstractIterationOrderRetainingElementSource.RealizedElementCollectionIterator<T>
    implements ListIterator<T> {
        T previous;
        int listNextIndex = 0;
        int listPreviousIndex = -1;

        RealizedElementListIterator(List<AbstractIterationOrderRetainingElementSource.Element<T>> backingList, Spec<AbstractIterationOrderRetainingElementSource.Element<T>> acceptanceSpec) {
            super(backingList, acceptanceSpec);
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        private void updatePrevious() {
            for (int i = this.previousIndex - 1; i >= 0; --i) {
                AbstractIterationOrderRetainingElementSource.Element candidate = (AbstractIterationOrderRetainingElementSource.Element)this.backingList.get(i);
                if (!candidate.isRealized() || !this.acceptanceSpec.isSatisfiedBy((Object)candidate)) continue;
                Object value = candidate.getValue();
                this.previousIndex = i;
                this.previous = value;
                return;
            }
            this.previousIndex = -1;
            this.previous = null;
        }

        @Override
        public T next() {
            Object value = super.next();
            this.previous = ((AbstractIterationOrderRetainingElementSource.Element)this.backingList.get(this.previousIndex)).getValue();
            ++this.listNextIndex;
            ++this.listPreviousIndex;
            return value;
        }

        @Override
        public T previous() {
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.nextIndex = this.previousIndex;
            this.next = this.previous;
            this.updatePrevious();
            --this.listNextIndex;
            --this.listPreviousIndex;
            return (T)this.next;
        }

        @Override
        public int nextIndex() {
            return this.listNextIndex;
        }

        @Override
        public int previousIndex() {
            return this.listPreviousIndex;
        }

        @Override
        public void set(T t) {
            if (this.previousIndex < 0) {
                throw new IllegalStateException();
            }
            this.backingList.set(this.previousIndex, new AbstractIterationOrderRetainingElementSource.CachingElement<T>(t));
        }

        @Override
        public void add(T t) {
            AbstractIterationOrderRetainingElementSource.CachingElement<T> element = new AbstractIterationOrderRetainingElementSource.CachingElement<T>(t);
            this.backingList.add(this.nextIndex, element);
            ++this.nextIndex;
            this.previous = element.getValue();
            this.previousIndex = this.nextIndex;
        }

        @Override
        public void remove() {
            super.remove();
            this.previous = null;
        }
    }
}

