from typing import Any, Dict, Optional, Text
from six.moves import http_client

HAVE_HTTPS_CONNECTION = ...  # type: bool
ON_APP_ENGINE = ...  # type: Any
PORTS_BY_SECURITY = ...  # type: Any
DEFAULT_CA_CERTS_FILE = ...  # type: Any

class HostConnectionPool:
    queue = ...  # type: Any
    def __init__(self) -> None: ...
    def size(self): ...
    def put(self, conn): ...
    def get(self): ...
    def clean(self): ...

class ConnectionPool:
    CLEAN_INTERVAL = ...  # type: float
    STALE_DURATION = ...  # type: float
    host_to_pool = ...  # type: Any
    last_clean_time = ...  # type: float
    mutex = ...  # type: Any
    def __init__(self) -> None: ...
    def size(self): ...
    def get_http_connection(self, host, port, is_secure): ...
    def put_http_connection(self, host, port, is_secure, conn): ...
    def clean(self): ...

class HTTPRequest:
    method = ...  # type: Any
    protocol = ...  # type: Any
    host = ...  # type: Any
    port = ...  # type: Any
    path = ...  # type: Any
    auth_path = ...  # type: Any
    params = ...  # type: Any
    headers = ...  # type: Any
    body = ...  # type: Any
    def __init__(self, method, protocol, host, port, path, auth_path, params, headers, body) -> None: ...
    def authorize(self, connection, **kwargs): ...

class HTTPResponse(http_client.HTTPResponse):
    def __init__(self, *args, **kwargs) -> None: ...
    def read(self, amt: Optional[Any] = ...): ...

class AWSAuthConnection:
    suppress_consec_slashes = ...  # type: Any
    num_retries = ...  # type: int
    is_secure = ...  # type: Any
    https_validate_certificates = ...  # type: Any
    ca_certificates_file = ...  # type: Any
    port = ...  # type: Any
    http_exceptions = ...  # type: Any
    http_unretryable_exceptions = ...  # type: Any
    socket_exception_values = ...  # type: Any
    https_connection_factory = ...  # type: Any
    protocol = ...  # type: str
    host = ...  # type: Any
    path = ...  # type: Any
    debug = ...  # type: Any
    host_header = ...  # type: Any
    http_connection_kwargs = ...  # type: Any
    provider = ...  # type: Any
    auth_service_name = ...  # type: Any
    request_hook = ...  # type: Any
    def __init__(self, host, aws_access_key_id: Optional[Any] = ..., aws_secret_access_key: Optional[Any] = ..., is_secure: bool = ..., port: Optional[Any] = ..., proxy: Optional[Any] = ..., proxy_port: Optional[Any] = ..., proxy_user: Optional[Any] = ..., proxy_pass: Optional[Any] = ..., debug: int = ..., https_connection_factory: Optional[Any] = ..., path: str = ..., provider: str = ..., security_token: Optional[Any] = ..., suppress_consec_slashes: bool = ..., validate_certs: bool = ..., profile_name: Optional[Any] = ...) -> None: ...
    auth_region_name = ...  # type: Any
    @property
    def connection(self): ...
    @property
    def aws_access_key_id(self): ...
    @property
    def gs_access_key_id(self): ...  # type: Any
    access_key = ...  # type: Any
    @property
    def aws_secret_access_key(self): ...
    @property
    def gs_secret_access_key(self): ...
    secret_key = ...  # type: Any
    @property
    def profile_name(self): ...
    def get_path(self, path: str = ...): ...
    def server_name(self, port: Optional[Any] = ...): ...
    proxy = ...  # type: Any
    proxy_port = ...  # type: Any
    proxy_user = ...  # type: Any
    proxy_pass = ...  # type: Any
    no_proxy = ...  # type: Any
    use_proxy = ...  # type: Any
    def handle_proxy(self, proxy, proxy_port, proxy_user, proxy_pass): ...
    def get_http_connection(self, host, port, is_secure): ...
    def skip_proxy(self, host): ...
    def new_http_connection(self, host, port, is_secure): ...
    def put_http_connection(self, host, port, is_secure, connection): ...
    def proxy_ssl(self, host: Optional[Any] = ..., port: Optional[Any] = ...): ...
    def prefix_proxy_to_path(self, path, host: Optional[Any] = ...): ...
    def get_proxy_auth_header(self): ...
    def get_proxy_url_with_auth(self): ...
    def set_host_header(self, request): ...
    def set_request_hook(self, hook): ...
    def build_base_http_request(self, method, path, auth_path, params: Optional[Any] = ..., headers: Optional[Any] = ..., data: str = ..., host: Optional[Any] = ...): ...
    def make_request(self, method, path, headers: Optional[Any] = ..., data: str = ..., host: Optional[Any] = ..., auth_path: Optional[Any] = ..., sender: Optional[Any] = ..., override_num_retries: Optional[Any] = ..., params: Optional[Any] = ..., retry_handler: Optional[Any] = ...): ...
    def close(self): ...

class AWSQueryConnection(AWSAuthConnection):
    APIVersion = ...  # type: str
    ResponseError = ...  # type: Any
    def __init__(self, aws_access_key_id: Optional[Any] = ..., aws_secret_access_key: Optional[Any] = ..., is_secure: bool = ..., port: Optional[Any] = ..., proxy: Optional[Any] = ..., proxy_port: Optional[Any] = ..., proxy_user: Optional[Any] = ..., proxy_pass: Optional[Any] = ..., host: Optional[Any] = ..., debug: int = ..., https_connection_factory: Optional[Any] = ..., path: str = ..., security_token: Optional[Any] = ..., validate_certs: bool = ..., profile_name: Optional[Any] = ..., provider: str = ...) -> None: ...
    def get_utf8_value(self, value): ...
    def make_request(self, action, params: Optional[Any] = ..., path: str = ..., verb: str = ..., *args, **kwargs): ...  # type: ignore # https://github.com/python/mypy/issues/1237
    def build_list_params(self, params, items, label): ...
    def build_complex_list_params(self, params, items, label, names): ...
    def get_list(self, action, params, markers, path: str = ..., parent: Optional[Any] = ..., verb: str = ...): ...
    def get_object(self, action, params, cls, path: str = ..., parent: Optional[Any] = ..., verb: str = ...): ...
    def get_status(self, action, params, path: str = ..., parent: Optional[Any] = ..., verb: str = ...): ...
