"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const serviceManager_1 = require("../serviceManager");
const semver = require("semver");
const debug_1 = require("debug");
const debug = debug_1.default('axm:coveragefeature');
class CoverageFeature {
    constructor() {
        this.inspectorService = serviceManager_1.ServiceManager.get('inspector');
    }
    init() {
        if (semver.satisfies(process.version, '< 8.0.0') ||
            (semver.satisfies(process.version, '< 10.0.0') && !process.env.FORCE_INSPECTOR)) {
            return new Promise(resolve => {
                debug(`Coverage feature is not available for node < 8.0.0 (force inspector : ${process.env.FORCE_INSPECTOR}), current version ${process.version}`);
                resolve(`Coverage feature is not available for node < 8.0.0 (force inspector : ${process.env.FORCE_INSPECTOR}), current version ${process.version}`);
            });
        }
        this.inspectorService.createSession();
        this.inspectorService.connect();
        return this.inspectorService.post('Profiler.enable');
    }
    destroy() {
        this.inspectorService.disconnect();
    }
    start(opts) {
        this.method = !opts.method ? 'takePreciseCoverage' : opts.method;
        return this.inspectorService.post('Profiler.startPreciseCoverage', { callCount: !!opts.callCount, detailed: !!opts.detailed });
    }
    stop() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const data = yield this.getInfo();
            return JSON.stringify(data);
        });
    }
    getInfo() {
        // const self = this
        return new Promise((resolve, reject) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const data = yield this.inspectorService.post('Profiler.' + this.method);
                yield this.inspectorService.post('Profiler.stopPreciseCoverage');
                return resolve(data);
            }
            catch (err) {
                debug('Coverage profiling stopped !', err);
                return reject(err);
            }
        }));
    }
}
exports.default = CoverageFeature;
//# sourceMappingURL=data:application/json;base64,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