/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGridGUI.Application.CommunicatorSubEditor;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ListTextField;
import com.zeroc.IceGridGUI.Application.SimpleMapField;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class ServerSubEditor
extends CommunicatorSubEditor {
    private static final Object NO_DISTRIB = new Object(){

        public String toString() {
            return "None selected";
        }
    };
    private JTextField _id = new JTextField(20);
    private JTextField _exe = new JTextField(20);
    private JTextField _iceVersion = new JTextField(20);
    private JTextField _pwd = new JTextField(20);
    private ListTextField _options = new ListTextField(20);
    private JTextField _user = new JTextField(20);
    private SimpleMapField _envs;
    private JComboBox _activation;
    private JTextField _activationTimeout = new JTextField(20);
    private JTextField _deactivationTimeout = new JTextField(20);
    private JCheckBox _allocatable;
    private JCheckBox _applicationDistrib;
    private JComboBox _distrib;
    private ListTextField _distribDirs = new ListTextField(20);

    ServerSubEditor(Editor mainEditor) {
        super(mainEditor);
        this._id.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._id.setToolTipText("Must be unique within this IceGrid deployment");
        this._exe.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._exe.setToolTipText("<html>Path to this server's executable, e.g.:<br>icebox<br>java<br>myHelloServer<br>C:\\testbed\\hello\\server</html>");
        this._iceVersion.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._iceVersion.setToolTipText("<html>The Ice version used by this server;<br>blank means 'same version as the IceGrid registry'.</html>");
        this._pwd.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._pwd.setToolTipText("<html>If not set, the server will start in <i>node data dir</i>/servers/<i>server-id</i>;<br>relative directories are relative to the current directory of the icegridnode process.</html>");
        this._options.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._options.setToolTipText("<html>Command-line arguments for this server.<br>Use whitespace as separator; use double-quotes around arguments containing whitespaces</html>");
        this._user.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._user.setToolTipText("<html>Run the server using this user account.<br>This feature is only available on Unix/Linux, when the IceGrid node runs as root.</html>");
        this._envs = new SimpleMapField(mainEditor, true, "Name", "Value");
        this._activation = new JComboBox<String>(new String[]{"always", "manual", "on-demand", "session"});
        this._activation.setToolTipText("<html>always: IceGrid starts and keeps the server up all the time<br>manual: you start the server yourself<br>on-demand: IceGrid starts the server when a client needs it<br>session: IceGrid starts and shuts down the server for each session</html>");
        JTextField activationTextField = (JTextField)this._activation.getEditor().getEditorComponent();
        activationTextField.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._activationTimeout.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._activationTimeout.setToolTipText("<html>Number of seconds; if not set or set to 0, the IceGrid Node<br> uses the value of its IceGrid.Node.WaitTime property</html>");
        this._deactivationTimeout.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._deactivationTimeout.setToolTipText("<html>Number of seconds; if not set or set to 0, the IceGrid Node<br> uses the value of its IceGrid.Node.WaitTime property</html>");
        AbstractAction allocatable = new AbstractAction("Allocatable"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSubEditor.this._mainEditor.updated();
            }
        };
        allocatable.putValue("ShortDescription", "<html>Check this box to ensure that the well-known objects<br>of this server can only be allocated by one session at a time.</html>");
        this._allocatable = new JCheckBox(allocatable);
        AbstractAction appDistrib = new AbstractAction("Depends on the application distribution"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSubEditor.this._mainEditor.updated();
            }
        };
        appDistrib.putValue("ShortDescription", "<html>Check this box if this server needs to be restarted<br>each time the distribution for your application is refreshed.</html>");
        this._applicationDistrib = new JCheckBox(appDistrib);
        this._distrib = new JComboBox<Object>(new Object[]{NO_DISTRIB, "${application}.IcePatch2/server"});
        this._distrib.setToolTipText("The proxy to the IcePatch2 server holding your files");
        JTextField distribTextField = (JTextField)this._distrib.getEditor().getEditorComponent();
        distribTextField.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._distribDirs.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._distribDirs.setToolTipText("<html>Include only these directories when patching.<br>Use whitespace as separator; use double-quotes around directories containing whitespaces</html>");
    }

    ServerDescriptor getServerDescriptor() {
        return (ServerDescriptor)this._mainEditor.getSubDescriptor();
    }

    @Override
    void appendProperties(DefaultFormBuilder builder) {
        builder.append("Server ID");
        builder.append((Component)this._id, 3);
        builder.nextLine();
        super.appendProperties(builder);
        builder.appendSeparator("Activation");
        builder.append("Path to Executable");
        builder.append((Component)this._exe, 3);
        builder.nextLine();
        builder.append("Ice Version");
        builder.append((Component)this._iceVersion, 3);
        builder.nextLine();
        builder.append("Working Directory");
        builder.append((Component)this._pwd, 3);
        builder.nextLine();
        builder.append("Command Arguments");
        builder.append((Component)this._options, 3);
        builder.nextLine();
        builder.append("Run as");
        builder.append((Component)this._user, 3);
        builder.nextLine();
        builder.append("Environment Variables");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._envs);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Activation Mode");
        builder.append((Component)this._activation, 3);
        builder.nextLine();
        builder.append("Activation Timeout");
        builder.append((Component)this._activationTimeout, 3);
        builder.nextLine();
        builder.append("Deactivation Timeout");
        builder.append((Component)this._deactivationTimeout, 3);
        builder.nextLine();
        builder.append("", (Component)this._allocatable);
        builder.nextLine();
        JComponent c = builder.appendSeparator("Distribution");
        c.setToolTipText("Files specific to this server");
        builder.append("", (Component)this._applicationDistrib);
        builder.nextLine();
        builder.append("IcePatch2 Proxy");
        builder.append((Component)this._distrib, 3);
        builder.nextLine();
        builder.append("Directories");
        builder.append((Component)this._distribDirs, 3);
        builder.nextLine();
    }

    void writeDescriptor() {
        ServerDescriptor descriptor = this.getServerDescriptor();
        descriptor.id = this._id.getText().trim();
        descriptor.exe = this._exe.getText().trim();
        descriptor.iceVersion = this._iceVersion.getText().trim();
        descriptor.pwd = this._pwd.getText().trim();
        descriptor.options = this._options.getList();
        descriptor.user = this._user.getText().trim();
        descriptor.envs = new LinkedList<String>();
        for (Map.Entry<String, String> p : this._envs.get().entrySet()) {
            descriptor.envs.add(p.getKey() + "=" + p.getValue());
        }
        descriptor.activation = this._activation.getSelectedItem().toString().trim();
        descriptor.activationTimeout = this._activationTimeout.getText().trim();
        descriptor.deactivationTimeout = this._deactivationTimeout.getText().trim();
        descriptor.allocatable = this._allocatable.isSelected();
        descriptor.applicationDistrib = this._applicationDistrib.isSelected();
        descriptor.distrib.icepatch = this._distrib.getSelectedItem() == NO_DISTRIB ? "" : this._distrib.getSelectedItem().toString().trim();
        descriptor.distrib.directories = this._distribDirs.getList();
        super.writeDescriptor(descriptor);
    }

    boolean isSimpleUpdate() {
        return this.getServerDescriptor().id.equals(this._id.getText().trim());
    }

    boolean validate() {
        return this._mainEditor.check(new String[]{"Server ID", this._id.getText().trim(), "Path to Executable", this._exe.getText().trim()});
    }

    void show(boolean isEditable) {
        ServerDescriptor descriptor = this.getServerDescriptor();
        Utils.Resolver detailResolver = this._mainEditor.getDetailResolver();
        boolean bl = isEditable = isEditable && detailResolver == null;
        if (detailResolver != null) {
            this._id.setText(detailResolver.find("server"));
        } else {
            this._id.setText(descriptor.id);
        }
        this._id.setEditable(isEditable);
        this._exe.setText(Utils.substitute(descriptor.exe, detailResolver));
        this._exe.setEditable(isEditable);
        this._iceVersion.setText(Utils.substitute(descriptor.iceVersion, detailResolver));
        this._iceVersion.setEditable(isEditable);
        this._pwd.setText(Utils.substitute(descriptor.pwd, detailResolver));
        this._pwd.setEditable(isEditable);
        this._options.setList(descriptor.options, detailResolver);
        this._options.setEditable(isEditable);
        this._user.setText(Utils.substitute(descriptor.user, detailResolver));
        this._user.setEditable(isEditable);
        TreeMap<String, String> envMap = new TreeMap<String, String>();
        for (String p : descriptor.envs) {
            int equal = p.indexOf(61);
            if (equal == -1 || equal == p.length() - 1) {
                envMap.put(p, "");
                continue;
            }
            envMap.put(p.substring(0, equal), p.substring(equal + 1));
        }
        this._envs.set(envMap, detailResolver, isEditable);
        String activation = Utils.substitute(descriptor.activation, detailResolver);
        this._activation.setEnabled(true);
        this._activation.setEditable(true);
        if (activation.equals("always")) {
            this._activation.setSelectedItem("always");
        } else if (activation.equals("manual")) {
            this._activation.setSelectedItem("manual");
        } else if (activation.equals("on-demand")) {
            this._activation.setSelectedItem("on-demand");
        } else if (activation.equals("session")) {
            this._activation.setSelectedItem("session");
        } else {
            this._activation.setSelectedItem(activation);
        }
        this._activation.setEnabled(isEditable);
        this._activation.setEditable(isEditable);
        this._activationTimeout.setText(Utils.substitute(descriptor.activationTimeout, detailResolver));
        this._activationTimeout.setEditable(isEditable);
        this._deactivationTimeout.setText(Utils.substitute(descriptor.deactivationTimeout, detailResolver));
        this._deactivationTimeout.setEditable(isEditable);
        this._allocatable.setSelected(descriptor.allocatable);
        this._allocatable.setEnabled(isEditable);
        this._applicationDistrib.setSelected(descriptor.applicationDistrib);
        this._applicationDistrib.setEnabled(isEditable);
        this._distrib.setEnabled(true);
        this._distrib.setEditable(true);
        String icepatch = Utils.substitute(descriptor.distrib.icepatch, detailResolver);
        if (icepatch.equals("")) {
            this._distrib.setSelectedItem(NO_DISTRIB);
        } else {
            this._distrib.setSelectedItem(icepatch);
        }
        this._distrib.setEnabled(isEditable);
        this._distrib.setEditable(isEditable);
        this._distribDirs.setList(descriptor.distrib.directories, detailResolver);
        this._distribDirs.setEditable(isEditable);
        this.show(descriptor, isEditable);
    }
}

