/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.Ice.ToStringMode;
import com.zeroc.Ice.Util;
import com.zeroc.IceGrid.AdapterDescriptor;
import com.zeroc.IceGrid.DistributionDescriptor;
import com.zeroc.IceGrid.ObjectDescriptor;
import com.zeroc.IceGrid.PropertyDescriptor;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.TreeNodeBase;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class TreeNode
extends TreeNodeBase {
    public static final int NEW_ADAPTER = 0;
    public static final int NEW_DBENV = 1;
    public static final int NEW_NODE = 2;
    public static final int NEW_PROPERTY_SET = 3;
    public static final int NEW_REPLICA_GROUP = 4;
    public static final int NEW_SERVER = 5;
    public static final int NEW_SERVER_ICEBOX = 6;
    public static final int NEW_SERVER_FROM_TEMPLATE = 7;
    public static final int NEW_SERVICE = 8;
    public static final int NEW_SERVICE_FROM_TEMPLATE = 9;
    public static final int NEW_TEMPLATE_SERVER = 10;
    public static final int NEW_TEMPLATE_SERVER_ICEBOX = 11;
    public static final int NEW_TEMPLATE_SERVICE = 12;
    public static final int COPY = 13;
    public static final int PASTE = 14;
    public static final int DELETE = 15;
    public static final int SHOW_VARS = 16;
    public static final int SUBSTITUTE_VARS = 17;
    public static final int MOVE_UP = 18;
    public static final int MOVE_DOWN = 19;
    public static final int ACTION_COUNT = 20;

    public abstract Editor getEditor();

    protected abstract Editor createEditor();

    abstract Object getDescriptor();

    abstract void write(XMLWriter var1) throws IOException;

    public boolean isEphemeral() {
        return false;
    }

    public void destroy() {
        assert (false);
    }

    TreeNode(TreeNode parent, String id) {
        super(parent, id);
    }

    public Root getRoot() {
        assert (this._parent != null);
        return ((TreeNode)this._parent).getRoot();
    }

    TreeNode findChildLike(TreeNode other) {
        return (TreeNode)this.findChild(other.getId());
    }

    Utils.Resolver getResolver() {
        if (this.isEphemeral()) {
            return null;
        }
        return ((TreeNode)this._parent).getResolver();
    }

    TreeNode findChildWithDescriptor(Object descriptor) {
        Enumeration<javax.swing.tree.TreeNode> p = this.children();
        while (p.hasMoreElements()) {
            TreeNode node = (TreeNode)p.nextElement();
            if (node.getDescriptor() != descriptor) continue;
            return node;
        }
        return null;
    }

    static String[] createAttribute(String name, String value) {
        return new String[]{name, value};
    }

    static void writeVariables(XMLWriter writer, Map<String, String> variables) throws IOException {
        for (Map.Entry<String, String> p : variables.entrySet()) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(TreeNode.createAttribute("name", p.getKey()));
            attributes.add(TreeNode.createAttribute("value", p.getValue()));
            writer.writeElement("variable", attributes);
        }
    }

    static void writePropertySet(XMLWriter writer, PropertySetDescriptor psd, List<AdapterDescriptor> adapters, String[] logs) throws IOException {
        TreeNode.writePropertySet(writer, "", "", psd, adapters, logs);
    }

    static void writePropertySet(XMLWriter writer, String id, String idAttrName, PropertySetDescriptor psd, List<AdapterDescriptor> adapters, String[] logs) throws IOException {
        if (id.length() == 0 && psd.references.length == 0 && psd.properties.size() == 0) {
            return;
        }
        HashSet<String> hiddenPropertyNames = new HashSet<String>();
        HashSet<String> hiddenPropertyValues = new HashSet<String>();
        if (adapters != null) {
            for (AdapterDescriptor p : adapters) {
                hiddenPropertyNames.add(p.name + ".Endpoints");
                hiddenPropertyNames.add(p.name + ".ProxyOptions");
                for (ObjectDescriptor q : p.objects) {
                    hiddenPropertyValues.add(Util.identityToString(q.id, ToStringMode.Unicode));
                }
                for (ObjectDescriptor q : p.allocatables) {
                    hiddenPropertyValues.add(Util.identityToString(q.id, ToStringMode.Unicode));
                }
            }
        }
        if (logs != null) {
            for (String log : logs) {
                hiddenPropertyValues.add(log);
            }
        }
        LinkedList<String[]> attributes = new LinkedList<String[]>();
        if (id.length() > 0) {
            attributes.add(TreeNode.createAttribute(idAttrName, id));
        }
        if (psd.references.length == 0 && psd.properties.size() == 0) {
            writer.writeElement("properties", attributes);
        } else {
            writer.writeStartTag("properties", attributes);
            for (String ref : psd.references) {
                attributes.clear();
                attributes.add(TreeNode.createAttribute("refid", ref));
                writer.writeElement("properties", attributes);
            }
            for (PropertyDescriptor p : psd.properties) {
                if (hiddenPropertyNames.contains(p.name)) {
                    hiddenPropertyNames.remove(p.name);
                    continue;
                }
                if (hiddenPropertyValues.contains(p.value)) {
                    hiddenPropertyValues.remove(p.value);
                    continue;
                }
                attributes.clear();
                attributes.add(TreeNode.createAttribute("name", p.name));
                attributes.add(TreeNode.createAttribute("value", p.value));
                writer.writeElement("property", attributes);
            }
            writer.writeEndTag("properties");
        }
    }

    static void writeLogs(XMLWriter writer, String[] logs, List<PropertyDescriptor> properties) throws IOException {
        for (String log : logs) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(TreeNode.createAttribute("path", log));
            String prop = TreeNode.lookupName(log, properties);
            if (prop != null) {
                attributes.add(TreeNode.createAttribute("property", prop));
            }
            writer.writeElement("log", attributes);
        }
    }

    static String lookupName(String val, List<PropertyDescriptor> properties) {
        for (PropertyDescriptor p : properties) {
            if (!p.value.equals(val)) continue;
            return p.name;
        }
        return null;
    }

    static void writeDistribution(XMLWriter writer, DistributionDescriptor descriptor) throws IOException {
        if (descriptor.icepatch.length() > 0) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(TreeNode.createAttribute("icepatch", descriptor.icepatch));
            if (descriptor.directories.isEmpty()) {
                writer.writeElement("distrib", attributes);
            } else {
                writer.writeStartTag("distrib", attributes);
                for (String p : descriptor.directories) {
                    writer.writeElement("directory", p);
                }
                writer.writeEndTag("distrib");
            }
        }
    }

    static void writeObjects(String elt, XMLWriter writer, List<ObjectDescriptor> objects, List<PropertyDescriptor> properties) throws IOException {
        for (ObjectDescriptor p : objects) {
            String prop;
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            String strId = Util.identityToString(p.id, ToStringMode.Unicode);
            attributes.add(TreeNode.createAttribute("identity", strId));
            if (p.type.length() > 0) {
                attributes.add(TreeNode.createAttribute("type", p.type));
            }
            if (properties != null && (prop = TreeNode.lookupName(strId, properties)) != null) {
                attributes.add(TreeNode.createAttribute("property", prop));
            }
            if (p.proxyOptions != null && !p.proxyOptions.equals("")) {
                attributes.add(TreeNode.createAttribute("proxy-options", p.proxyOptions));
            }
            writer.writeElement(elt, attributes);
        }
    }

    static void writeParameters(XMLWriter writer, List<String> parameters, Map<String, String> defaultValues) throws IOException {
        for (String p : new LinkedHashSet<String>(parameters)) {
            String val = defaultValues.get(p);
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(TreeNode.createAttribute("name", p));
            if (val != null) {
                attributes.add(TreeNode.createAttribute("default", val));
            }
            writer.writeElement("parameter", attributes);
        }
    }

    static LinkedList<String[]> parameterValuesToAttributes(Map<String, String> parameterValues, List<String> parameters) {
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (String p : new LinkedHashSet<String>(parameters)) {
            String val = parameterValues.get(p);
            if (val == null) continue;
            result.add(TreeNode.createAttribute(p, val));
        }
        return result;
    }

    public boolean[] getAvailableActions() {
        return new boolean[20];
    }

    public void newAdapter() {
        assert (false);
    }

    public void newDbEnv() {
        assert (false);
    }

    public void newNode() {
        assert (false);
    }

    public void newPropertySet() {
        assert (false);
    }

    public void newReplicaGroup() {
        assert (false);
    }

    public void newServer() {
        assert (false);
    }

    public void newServerIceBox() {
        assert (false);
    }

    public void newServerFromTemplate() {
        assert (false);
    }

    public void newService() {
        assert (false);
    }

    public void newServiceFromTemplate() {
        assert (false);
    }

    public void newTemplateServer() {
        assert (false);
    }

    public void newTemplateServerIceBox() {
        assert (false);
    }

    public void newTemplateService() {
        assert (false);
    }

    public void copy() {
        assert (false);
    }

    public void paste() {
        assert (false);
    }

    public void delete() {
        boolean enabled = this.getRoot().isSelectionListenerEnabled();
        if (enabled) {
            this.getRoot().disableSelectionListener();
        }
        this.destroy();
        this.getCoordinator().getCurrentTab().showNode(null);
        if (enabled) {
            this.getRoot().enableSelectionListener();
        }
        if (this._parent != null) {
            this.getRoot().setSelectedNode((TreeNode)this._parent);
        }
    }

    public void moveUp() {
        assert (false);
    }

    public void moveDown() {
        assert (false);
    }
}

