/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class ClusterUpdateSettingsResponse
extends AcknowledgedResponse {
    private static final ParseField PERSISTENT = new ParseField("persistent", new String[0]);
    private static final ParseField TRANSIENT = new ParseField("transient", new String[0]);
    private static final ConstructingObjectParser<ClusterUpdateSettingsResponse, Void> PARSER = new ConstructingObjectParser("cluster_update_settings_response", true, a -> new ClusterUpdateSettingsResponse((Boolean)a[0]));
    Settings transientSettings;
    Settings persistentSettings;

    ClusterUpdateSettingsResponse() {
        this.persistentSettings = Settings.EMPTY;
        this.transientSettings = Settings.EMPTY;
    }

    ClusterUpdateSettingsResponse(boolean acknowledged) {
        super(acknowledged);
    }

    ClusterUpdateSettingsResponse(boolean acknowledged, Settings transientSettings, Settings persistentSettings) {
        super(acknowledged);
        this.persistentSettings = persistentSettings;
        this.transientSettings = transientSettings;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            super.readFrom(in);
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
        } else {
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.acknowledged = in.readBoolean();
        }
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            super.writeTo(out);
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
        } else {
            Settings.writeSettingsToStream(this.transientSettings, out);
            Settings.writeSettingsToStream(this.persistentSettings, out);
            out.writeBoolean(this.acknowledged);
        }
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PERSISTENT.getPreferredName());
        this.persistentSettings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(TRANSIENT.getPreferredName());
        this.transientSettings.toXContent(builder, params);
        builder.endObject();
    }

    public static ClusterUpdateSettingsResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ClusterUpdateSettingsResponse that = (ClusterUpdateSettingsResponse)o;
            return Objects.equals(this.transientSettings, that.transientSettings) && Objects.equals(this.persistentSettings, that.persistentSettings);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transientSettings, this.persistentSettings);
    }

    static {
        ClusterUpdateSettingsResponse.declareAcknowledgedField(PARSER);
        PARSER.declareObject((r, p) -> {
            r.persistentSettings = p;
        }, (p, c) -> Settings.fromXContent(p), PERSISTENT);
        PARSER.declareObject((r, t) -> {
            r.transientSettings = t;
        }, (p, c) -> Settings.fromXContent(p), TRANSIENT);
    }
}

