/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.html.Encoding;
import org.owasp.html.Handler;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.Strings;
import org.owasp.html.TCB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TCB
@NotThreadSafe
public class HtmlStreamRenderer
implements HtmlStreamEventReceiver {
    private final Appendable output;
    private final Handler<? super IOException> ioExHandler;
    private final Handler<? super String> badHtmlHandler;
    private String lastTagOpened;
    private StringBuilder pendingUnescaped;
    private boolean open;

    public static HtmlStreamRenderer create(@WillCloseWhenClosed Appendable output, Handler<? super IOException> ioExHandler, Handler<? super String> badHtmlHandler) {
        if (output instanceof Closeable) {
            return new CloseableHtmlStreamRenderer(output, ioExHandler, badHtmlHandler);
        }
        return new HtmlStreamRenderer(output, ioExHandler, badHtmlHandler);
    }

    public static HtmlStreamRenderer create(StringBuilder output, Handler<? super String> badHtmlHandler) {
        return HtmlStreamRenderer.create(output, Handler.PROPAGATE, badHtmlHandler);
    }

    private HtmlStreamRenderer(Appendable output, Handler<? super IOException> ioExHandler, Handler<? super String> badHtmlHandler) {
        this.output = output;
        this.ioExHandler = ioExHandler;
        this.badHtmlHandler = badHtmlHandler;
    }

    private final void error(String message, CharSequence identifier) {
        if (this.badHtmlHandler != Handler.DO_NOTHING) {
            this.badHtmlHandler.handle(message + " : " + identifier);
        }
    }

    @Override
    public final void openDocument() throws IllegalStateException {
        if (this.open) {
            throw new IllegalStateException();
        }
        this.open = true;
    }

    @Override
    public final void closeDocument() throws IllegalStateException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        if (this.pendingUnescaped != null) {
            this.closeTag(this.lastTagOpened);
        }
        this.open = false;
        if (this.output instanceof Flushable) {
            try {
                ((Flushable)((Object)this.output)).flush();
            }
            catch (IOException ex) {
                this.ioExHandler.handle(ex);
            }
        }
    }

    public final boolean isDocumentOpen() {
        return this.open;
    }

    @Override
    public final void openTag(String elementName, List<String> attrs) {
        try {
            this.writeOpenTag(elementName, attrs);
        }
        catch (IOException ex) {
            this.ioExHandler.handle(ex);
        }
    }

    private void writeOpenTag(String elementName, List<? extends String> attrs) throws IOException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        if (!HtmlStreamRenderer.isValidHtmlName(elementName = HtmlStreamRenderer.safeName(elementName))) {
            this.error("Invalid element name", elementName);
            return;
        }
        if (this.pendingUnescaped != null) {
            this.error("Tag content cannot appear inside CDATA element", elementName);
            return;
        }
        switch (HtmlTextEscapingMode.getModeForTag(elementName)) {
            case CDATA_SOMETIMES: 
            case CDATA: 
            case PLAIN_TEXT: {
                this.lastTagOpened = elementName;
                this.pendingUnescaped = new StringBuilder();
                break;
            }
        }
        this.output.append('<').append(elementName);
        Iterator<? extends String> attrIt = attrs.iterator();
        while (attrIt.hasNext()) {
            String name = attrIt.next();
            String value = attrIt.next();
            if (!HtmlStreamRenderer.isValidHtmlName(name = HtmlLexer.canonicalName(name))) {
                this.error("Invalid attr name", name);
                continue;
            }
            this.output.append(' ').append(name).append('=').append('\"');
            Encoding.encodeHtmlOnto(value, this.output);
            if (value.indexOf(96) != -1) {
                this.output.append(' ');
            }
            this.output.append('\"');
        }
        if (HtmlTextEscapingMode.isVoidElement(elementName)) {
            this.output.append(" /");
        }
        this.output.append('>');
    }

    @Override
    public final void closeTag(String elementName) {
        try {
            this.writeCloseTag(HtmlStreamRenderer.safeName(elementName));
        }
        catch (IOException ex) {
            this.ioExHandler.handle(ex);
        }
    }

    private final void writeCloseTag(String elementName) throws IOException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        if (!HtmlStreamRenderer.isValidHtmlName(elementName = HtmlLexer.canonicalName(elementName))) {
            this.error("Invalid element name", elementName);
            return;
        }
        if (this.pendingUnescaped != null) {
            if (!this.lastTagOpened.equals(elementName)) {
                this.error("Tag content cannot appear inside CDATA element", elementName);
                return;
            }
            StringBuilder cdataContent = this.pendingUnescaped;
            this.pendingUnescaped = null;
            Encoding.stripBannedCodeunits(cdataContent);
            int problemIndex = HtmlStreamRenderer.checkHtmlCdataCloseable(this.lastTagOpened, cdataContent);
            if (problemIndex == -1) {
                this.output.append(cdataContent);
            } else {
                this.error("Invalid CDATA text content", cdataContent.subSequence(problemIndex, Math.min(problemIndex + 10, cdataContent.length())));
            }
            if ("plaintext".equals(elementName)) {
                return;
            }
        }
        this.output.append("</").append(elementName).append(">");
    }

    @Override
    public final void text(String text) {
        try {
            this.writeText(text);
        }
        catch (IOException ex) {
            this.ioExHandler.handle(ex);
        }
    }

    private final void writeText(String text) throws IOException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        if (this.pendingUnescaped != null) {
            this.pendingUnescaped.append(text);
        } else {
            Encoding.encodeHtmlOnto(text, this.output);
        }
    }

    private static int checkHtmlCdataCloseable(String localName, StringBuilder sb) {
        int escapingTextSpanStart = -1;
        int n = sb.length();
        block4: for (int i = 0; i < n; ++i) {
            char ch = sb.charAt(i);
            switch (ch) {
                case '<': {
                    if (i + 3 < n && '!' == sb.charAt(i + 1) && '-' == sb.charAt(i + 2) && '-' == sb.charAt(i + 3)) {
                        if (escapingTextSpanStart == -1) {
                            escapingTextSpanStart = i;
                            continue block4;
                        }
                        return i;
                    }
                    if (i + 1 + localName.length() >= n || '/' != sb.charAt(i + 1) || !Strings.regionMatchesIgnoreCase(sb, i + 2, localName, 0, localName.length())) continue block4;
                    if (escapingTextSpanStart < 0) {
                        return i;
                    }
                    if ("script".equals(localName)) continue block4;
                    return i;
                }
                case '>': {
                    if (i < 2 || '-' != sb.charAt(i - 1) || '-' != sb.charAt(i - 2)) continue block4;
                    if (escapingTextSpanStart < 0) {
                        return i - 2;
                    }
                    escapingTextSpanStart = -1;
                    continue block4;
                }
            }
        }
        if (escapingTextSpanStart >= 0) {
            return escapingTextSpanStart;
        }
        return -1;
    }

    @VisibleForTesting
    static boolean isValidHtmlName(String name) {
        int n = name.length();
        if (n == 0) {
            return false;
        }
        if (n > 128) {
            return false;
        }
        boolean isNamespaced = false;
        block4: for (int i = 0; i < n; ++i) {
            char ch = name.charAt(i);
            switch (ch) {
                case ':': {
                    if (isNamespaced) {
                        return false;
                    }
                    isNamespaced = true;
                    if (i != 0 && i + 1 != n) continue block4;
                    return false;
                }
                case '-': {
                    if (i != 0 && i + 1 != n) continue block4;
                    return false;
                }
                default: {
                    if (ch <= '9') {
                        if (i != 0 && ch >= '0') continue block4;
                        return false;
                    }
                    if ('A' <= ch && ch <= 'z') {
                        if ('Z' >= ch || ch >= 'a') continue block4;
                        return false;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    static String safeName(String elementName) {
        elementName = HtmlLexer.canonicalName(elementName);
        switch (elementName.length()) {
            case 3: {
                if (!"xmp".equals(elementName)) break;
                return "pre";
            }
            case 7: {
                if (!"listing".equals(elementName)) break;
                return "pre";
            }
            case 9: {
                if (!"plaintext".equals(elementName)) break;
                return "pre";
            }
        }
        return elementName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CloseableHtmlStreamRenderer
    extends HtmlStreamRenderer
    implements Closeable {
        private final Closeable closeable;

        CloseableHtmlStreamRenderer(@WillCloseWhenClosed Appendable output, Handler<? super IOException> errorHandler, Handler<? super String> badHtmlHandler) {
            super(output, errorHandler, badHtmlHandler);
            this.closeable = (Closeable)((Object)output);
        }

        @Override
        public void close() throws IOException {
            if (this.isDocumentOpen()) {
                this.closeDocument();
            }
            this.closeable.close();
        }
    }
}

