/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;

public class RollableIndexCaps
implements Writeable,
ToXContentFragment {
    static ParseField ROLLUP_JOBS = new ParseField("rollup_jobs", new String[0]);
    private String indexName;
    private List<RollupJobCaps> jobCaps;

    public RollableIndexCaps(String indexName) {
        this.indexName = indexName;
        this.jobCaps = new ArrayList<RollupJobCaps>();
    }

    public RollableIndexCaps(StreamInput in) throws IOException {
        this.indexName = in.readString();
        this.jobCaps = in.readList(RollupJobCaps::new);
    }

    public void addJobCap(RollupJobCaps jobCap) {
        this.jobCaps.add(jobCap);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<RollupJobCaps> getJobCaps() {
        return this.jobCaps;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeList(this.jobCaps);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.indexName);
        this.jobCaps.sort(Comparator.comparing(RollupJobCaps::getJobID));
        builder.field(ROLLUP_JOBS.getPreferredName(), this.jobCaps);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollableIndexCaps that = (RollableIndexCaps)other;
        return Objects.equals(this.jobCaps, that.jobCaps) && Objects.equals(this.indexName, that.indexName);
    }

    public int hashCode() {
        return Objects.hash(this.jobCaps, this.indexName);
    }
}

