/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class ApplicationPermission {
    public static final ApplicationPermission NONE = new ApplicationPermission(Collections.emptyList());
    private final Logger logger = Loggers.getLogger(this.getClass());
    private final List<PermissionEntry> permissions;

    ApplicationPermission(List<Tuple<ApplicationPrivilege, Set<String>>> privilegesAndResources) {
        HashMap permissionsByPrivilege = new HashMap();
        privilegesAndResources.forEach(tup -> permissionsByPrivilege.compute((ApplicationPrivilege)tup.v1(), (k, existing) -> {
            Automaton patterns = Automatons.patterns((Collection)tup.v2());
            if (existing == null) {
                return new PermissionEntry((ApplicationPrivilege)k, patterns);
            }
            return new PermissionEntry((ApplicationPrivilege)k, Automatons.unionAndMinimize(Arrays.asList(((PermissionEntry)existing).resources, patterns)));
        }));
        this.permissions = Collections.unmodifiableList(new ArrayList(permissionsByPrivilege.values()));
    }

    public boolean grants(ApplicationPrivilege other, String resource) {
        Automaton resourceAutomaton = Automatons.patterns(resource);
        boolean matched = this.permissions.stream().anyMatch(e -> ((PermissionEntry)e).grants(other, resourceAutomaton));
        this.logger.trace("Permission [{}] {} grant [{} , {}]", (Object)this, (Object)(matched ? "does" : "does not"), (Object)other, (Object)resource);
        return matched;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{privileges=" + this.permissions + "}";
    }

    private static class PermissionEntry {
        private final ApplicationPrivilege privilege;
        private final Predicate<String> application;
        private final Automaton resources;

        private PermissionEntry(ApplicationPrivilege privilege, Automaton resources) {
            this.privilege = privilege;
            this.application = Automatons.predicate(privilege.getApplication());
            this.resources = resources;
        }

        private boolean grants(ApplicationPrivilege other, Automaton resource) {
            return this.application.test(other.getApplication()) && !Operations.isEmpty((Automaton)this.privilege.getAutomaton()) && Operations.subsetOf((Automaton)other.getAutomaton(), (Automaton)this.privilege.getAutomaton()) && Operations.subsetOf((Automaton)resource, (Automaton)this.resources);
        }

        public String toString() {
            return this.privilege.toString();
        }
    }
}

