/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledResponse;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestSetEnabledAction
extends SecurityBaseRestHandler {
    public RestSetEnabledAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}/_enable", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/user/{username}/_enable", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}/_disable", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/user/{username}/_disable", (RestHandler)this);
    }

    public String getName() {
        return "xpack_security_set_enabled_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean enabled = request.path().endsWith("_enable");
        assert (enabled || request.path().endsWith("_disable"));
        String username = request.param("username");
        return channel -> new SecurityClient((ElasticsearchClient)client).prepareSetEnabled(username, enabled).execute((ActionListener)new RestBuilderListener<SetEnabledResponse>(channel){

            public RestResponse buildResponse(SetEnabledResponse setEnabledResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
            }
        });
    }
}

