/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.regex;

import java.util.regex.Pattern;
import org.elasticsearch.xpack.sql.expression.BinaryExpression;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.regex.LikePattern;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Like
extends BinaryExpression {
    public Like(Location location, Expression left, LikePattern right) {
        super(location, left, right);
    }

    @Override
    protected NodeInfo<Like> info() {
        return NodeInfo.create(this, Like::new, this.left(), this.right());
    }

    @Override
    protected BinaryExpression replaceChildren(Expression newLeft, Expression newRight) {
        return new Like(this.location(), newLeft, (LikePattern)newRight);
    }

    @Override
    public LikePattern right() {
        return (LikePattern)super.right();
    }

    @Override
    public boolean foldable() {
        return this.left().foldable();
    }

    @Override
    public Object fold() {
        Pattern p = Pattern.compile(this.right().asJavaRegex());
        return p.matcher(this.left().fold().toString()).matches();
    }

    @Override
    public Like swapLeftAndRight() {
        return this;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public String symbol() {
        return "LIKE";
    }
}

