/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.CountryPrefix;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Tuple;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.utils.L10N;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.math.RandomUtils;

public class GatewayComboBox
extends JComboBox {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final String RES = "/esmska/resources/";
    private static final GatewayComboBoxRenderer cellRenderer = new GatewayComboBoxRenderer();
    private static final Gateways gateways = Gateways.getInstance();
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private String gatewayName;
    private String filter;

    public GatewayComboBox() {
        this.updateGateways();
        this.setModel(this.model);
        this.setRenderer(cellRenderer);
        if (this.model.getSize() > 0) {
            this.setSelectedIndex(0);
        }
        Gateways.getInstance().addValuedListener(new ValuedListener<Gateways.Events, Gateway>(){

            @Override
            public void eventOccured(ValuedEvent<Gateways.Events, Gateway> e) {
                switch (e.getEvent()) {
                    case ADDED_GATEWAY: 
                    case ADDED_GATEWAYS: 
                    case CLEARED_GATEWAYS: 
                    case REMOVED_GATEWAY: 
                    case REMOVED_GATEWAYS: 
                    case FAVORITES_UPDATED: 
                    case HIDDEN_UPDATED: {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GatewayComboBox.this.updateGateways();
                            }
                        });
                    }
                }
            }
        });
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                switch (e.getStateChange()) {
                    case 2: {
                        GatewayComboBox.this.setToolTipText(null);
                        break;
                    }
                    case 1: {
                        GatewayComboBox.this.setToolTipText(cellRenderer.generateTooltip(GatewayComboBox.this.getSelectedGateway()));
                    }
                }
            }
        });
    }

    public Gateway getSelectedGateway() {
        return (Gateway)this.getSelectedItem();
    }

    public String getSelectedGatewayName() {
        return this.getSelectedGateway() != null ? this.getSelectedGateway().getName() : this.gatewayName;
    }

    public void setSelectedGateway(String gatewayName) {
        this.gatewayName = gatewayName;
        Gateway gateway = gateways.get(gatewayName);
        if (this.model.getIndexOf(gateway) < 0) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(gateway);
        }
    }

    public boolean selectSuggestedGateway(String number) {
        Tuple<ArrayList<Gateway>, Boolean> tuple = gateways.suggestGateway(number);
        ArrayList<Gateway> gws = tuple.get1();
        boolean recommended = tuple.get2();
        if (gws.isEmpty()) {
            this.setSelectedGateway(null);
        } else if (!gws.contains(this.getSelectedGateway())) {
            if (recommended) {
                this.setSelectedGateway(gws.get(RandomUtils.nextInt(gws.size())).getName());
            } else {
                this.setSelectedGateway(null);
            }
        }
        return gws.size() > 1;
    }

    public void selectNextSuggestedGateway(String number) {
        ArrayList<Gateway> gws = gateways.suggestGateway(number).get1();
        if (!gws.isEmpty()) {
            int index = gws.indexOf(this.getSelectedGateway());
            index = index >= 0 ? (index + 1) % gws.size() : RandomUtils.nextInt(gws.size());
            this.setSelectedGateway(gws.get(index).getName());
        } else {
            this.setSelectedGateway(null);
        }
    }

    public void setFilter(String number) {
        this.filter = number;
        this.updateGateways();
    }

    private void updateGateways() {
        String opName = this.getSelectedGatewayName();
        this.model.removeAllElements();
        for (Gateway gw : gateways.getVisible()) {
            if (!StringUtils.isEmpty(this.filter) && !Gateways.isNumberSupported(gw, this.filter)) continue;
            this.model.addElement(gw);
        }
        this.setSelectedGateway(opName);
    }

    public static class GatewayComboBoxRenderer
    extends DefaultListCellRenderer {
        private final ListCellRenderer lafRenderer = new JList().getCellRenderer();
        private final URL keyringIconURI = this.getClass().getResource("/esmska/resources/keyring-16.png");
        private final String pattern = GatewayComboBox.access$300().getString("GatewayComboBox.gatewayTooltip");
        private final String noReg = GatewayComboBox.access$300().getString("GatewayComboBox.noRegistration");
        private final String registration = MessageFormat.format("<img src=\"{0}\"> ", this.keyringIconURI) + GatewayComboBox.access$300().getString("GatewayComboBox.needRegistration");
        private final String international = GatewayComboBox.access$300().getString("GatewayComboBox.international");

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.lafRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof Gateway)) {
                return c;
            }
            JLabel label = (JLabel)c;
            Gateway gateway = (Gateway)value;
            this.adjustLabel(label, gateway);
            return label;
        }

        public void adjustLabel(JLabel label, Gateway gateway) {
            label.setText(gateway.getName());
            label.setIcon(gateway.getIcon());
            label.setToolTipText(this.generateTooltip(gateway));
            if (gateway.isHidden()) {
                label.setForeground(SystemColor.textInactiveText);
            }
        }

        private String generateTooltip(Gateway gateway) {
            if (gateway == null) {
                return null;
            }
            String country = CountryPrefix.extractCountryCode(gateway.getName());
            String local = MessageFormat.format(l10n.getString("GatewayComboBox.onlyCountry"), country);
            String description = WordUtils.wrap(gateway.getDescription(), 50, "<br>&nbsp;&nbsp;", false);
            String tooltip = MessageFormat.format(this.pattern, gateway.getName(), gateway.getWebsite(), description, gateway.hasFeature(Gateway.Feature.LOGIN_ONLY) ? this.registration : this.noReg, Gateways.convertDelayToHumanString(gateway.getDelayBetweenMessages(), false), country.equals("INT") ? this.international : local, gateway.getVersion());
            return tooltip;
        }
    }
}

