/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.googleearth;

import com.google.earth.kml._2.AltitudeModeEnum;
import com.google.earth.kml._2.FolderType;
import com.google.earth.kml._2.KmlType;
import com.google.earth.kml._2.LinkType;
import com.google.earth.kml._2.LookAtType;
import com.google.earth.kml._2.NetworkLinkType;
import com.google.earth.kml._2.ObjectFactory;
import com.google.earth.kml._2.RefreshModeEnum;
import com.google.earth.kml._2.ViewRefreshModeEnum;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.util.ClassLoaderUtil;
import org.fibs.geotag.util.OperatingSystem;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class GoogleEarthLauncher {
    private static final I18n i18n = I18nFactory.getI18n(GoogleEarthLauncher.class);
    private static final String ERROR_MESSAGE = i18n.tr("Error attempting to launch Google Earth");
    private static ImageInfo lastImageLauched;

    private GoogleEarthLauncher() {
    }

    public static void launch(ImageInfo imageInfo) {
        lastImageLauched = imageInfo;
        double latitude = 51.477222222222224;
        double longitude = 0.0;
        double defaultAltitude = 100.0;
        double altitude = 100.0;
        if (imageInfo.hasLocation()) {
            try {
                latitude = Double.parseDouble(imageInfo.getGpsLatitude());
                longitude = Double.parseDouble(imageInfo.getGpsLongitude());
                altitude = Double.parseDouble(imageInfo.getGpsAltitude());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)KmlType.class.getPackage().getName());
            ObjectFactory factory = new ObjectFactory();
            KmlType kml = factory.createKmlType();
            FolderType folder = factory.createFolderType();
            folder.setName("Geotag " + i18n.tr("Folder"));
            folder.setOpen(true);
            LookAtType lookAt = factory.createLookAtType();
            lookAt.setLatitude(new Double(latitude));
            lookAt.setLongitude(new Double(longitude));
            lookAt.setAltitude(new Double(altitude));
            lookAt.setAltitudeMode(AltitudeModeEnum.ABSOLUTE);
            lookAt.setRange(new Double(0.0));
            folder.setLookAt(lookAt);
            NetworkLinkType networkLink = factory.createNetworkLinkType();
            networkLink.setName("Geotag " + i18n.tr("Link"));
            networkLink.setOpen(true);
            networkLink.setVisibility(true);
            LinkType link = factory.createLinkType();
            link.setRefreshMode(RefreshModeEnum.ON_CHANGE);
            link.setHref("http://127.0.0.1:4321/kml/geotag.kml");
            link.setViewRefreshMode(ViewRefreshModeEnum.ON_STOP);
            link.setViewRefreshTime(new Float(0.0f));
            link.setViewFormat("longitude=[lookatLon]&latitude=[lookatLat]");
            networkLink.setLink(link);
            folder.getFeature().add(factory.createNetworkLink(networkLink));
            kml.setFeature(factory.createFolder(folder));
            File file = new File("Geotag.kml");
            try {
                file = File.createTempFile("Geotag", ".kml");
                file.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal(factory.createKml(kml), (OutputStream)outputStream);
                ((OutputStream)outputStream).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            GoogleEarthLauncher.openKmlFile(file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public static void openKmlFile(File file) {
        try {
            if (OperatingSystem.isMacOS()) {
                Class<?> fileMgr = ClassLoaderUtil.getClassForName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, file.getPath());
            } else if (OperatingSystem.isWindows()) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file.getPath());
            } else {
                String executable = Settings.get(Settings.SETTING.GOOGLE_EARTH_PATH, "googleearth");
                if (Runtime.getRuntime().exec(new String[]{"which", executable}).waitFor() != 0) {
                    throw new Exception(String.format(i18n.tr("Could not find '%1$s' on $PATH"), executable));
                }
                Runtime.getRuntime().exec(new String[]{executable, file.getPath()});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, String.valueOf(ERROR_MESSAGE) + ":\n" + e.getLocalizedMessage());
        }
    }

    public static ImageInfo getLastImageLauched() {
        return lastImageLauched;
    }
}

