/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance.plugin;

import org.gephi.appearance.api.Interpolator;
import org.gephi.appearance.api.Ranking;
import org.gephi.appearance.spi.RankingTransformer;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;

public class RankingNodeSizeTransformer
implements RankingTransformer<Element> {
    protected float minSize = 1.0f;
    protected float maxSize = 4.0f;

    public void transform(Element element, Ranking ranking, Interpolator interpolator, Number value) {
        float rankingValue = ranking.normalize(value, interpolator);
        float size = rankingValue * (this.maxSize - this.minSize) + this.minSize;
        ((Node)element).setSize(size);
    }

    public boolean isNode() {
        return true;
    }

    public boolean isEdge() {
        return false;
    }

    public float getMaxSize() {
        return this.maxSize;
    }

    public float getMinSize() {
        return this.minSize;
    }

    public void setMaxSize(float maxSize) {
        this.maxSize = maxSize;
    }

    public void setMinSize(float minSize) {
        this.minSize = minSize;
    }
}

