/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.lexer;

import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer._JavaLexer;
import org.jetbrains.kotlin.com.intellij.lexer.LexerBase;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceHashingStrategy;

public class JavaLexer
extends LexerBase {
    private static final Set<String> KEYWORDS = ContainerUtil.newTroveSet("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null");
    private static final Set<CharSequence> JAVA9_KEYWORDS = ContainerUtil.newTroveSet(CharSequenceHashingStrategy.CASE_SENSITIVE, new CharSequence[]{"open", "module", "requires", "exports", "opens", "uses", "provides", "transitive", "to", "with"});
    private final _JavaLexer myFlexLexer;
    private CharSequence myBuffer;
    private char[] myBufferArray;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private int myTokenEndOffset;
    private IElementType myTokenType;

    public static boolean isKeyword(String id, @NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(0);
        }
        return KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_1_4) && "assert".equals(id) || level.isAtLeast(LanguageLevel.JDK_1_5) && "enum".equals(id);
    }

    public static boolean isSoftKeyword(CharSequence id, @NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(1);
        }
        return id != null && (level.isAtLeast(LanguageLevel.JDK_1_9) && JAVA9_KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_10) && "var".contentEquals(id));
    }

    public JavaLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(2);
        }
        this.myFlexLexer = new _JavaLexer(level);
    }

    @Override
    public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JavaLexer.$$$reportNull$$$0(3);
        }
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.myFlexLexer.reset(this.myBuffer, startOffset, endOffset, 0);
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public final IElementType getTokenType() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        return this.myTokenType;
    }

    @Override
    public final int getTokenStart() {
        return this.myBufferIndex;
    }

    @Override
    public final int getTokenEnd() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        return this.myTokenEndOffset;
    }

    @Override
    public final void advance() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        this.myTokenType = null;
    }

    private void _locateToken() {
        if (this.myTokenEndOffset == this.myBufferEndOffset) {
            this.myTokenType = null;
            this.myBufferIndex = this.myBufferEndOffset;
            return;
        }
        this.myBufferIndex = this.myTokenEndOffset;
        char c = this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex] : this.myBuffer.charAt(this.myBufferIndex);
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.myTokenType = TokenType.WHITE_SPACE;
                this.myTokenEndOffset = this.getWhitespaces(this.myBufferIndex + 1);
                break;
            }
            case '/': {
                char nextChar;
                if (this.myBufferIndex + 1 >= this.myBufferEndOffset) {
                    this.myTokenType = JavaTokenType.DIV;
                    this.myTokenEndOffset = this.myBufferEndOffset;
                    break;
                }
                char c2 = nextChar = this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 1] : this.myBuffer.charAt(this.myBufferIndex + 1);
                if (nextChar == '/') {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + 2);
                    break;
                }
                if (nextChar == '*') {
                    if (this.myBufferIndex + 2 >= this.myBufferEndOffset || (this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 2] : this.myBuffer.charAt(this.myBufferIndex + 2)) != '*' || this.myBufferIndex + 3 < this.myBufferEndOffset && (this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 3] : this.myBuffer.charAt(this.myBufferIndex + 3)) == '/') {
                        this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                        this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 2);
                        break;
                    }
                    this.myTokenType = JavaDocElementType.DOC_COMMENT;
                    this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 3);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\"': 
            case '\'': {
                this.myTokenType = c == '\"' ? JavaTokenType.STRING_LITERAL : JavaTokenType.CHARACTER_LITERAL;
                this.myTokenEndOffset = this.getClosingParenthesis(this.myBufferIndex + 1, c);
                break;
            }
            default: {
                this.flexLocateToken();
            }
        }
        if (this.myTokenEndOffset > this.myBufferEndOffset) {
            this.myTokenEndOffset = this.myBufferEndOffset;
        }
    }

    private int getWhitespaces(int offset2) {
        char c;
        if (offset2 >= this.myBufferEndOffset) {
            return this.myBufferEndOffset;
        }
        int pos = offset2;
        char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') {
            if (++pos == this.myBufferEndOffset) {
                return pos;
            }
            c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
        }
        return pos;
    }

    private void flexLocateToken() {
        try {
            this.myFlexLexer.goTo(this.myBufferIndex);
            this.myTokenType = this.myFlexLexer.advance();
            this.myTokenEndOffset = this.myFlexLexer.getTokenEnd();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getClosingParenthesis(int offset2, char c) {
        int pos;
        block6: {
            char cur;
            if (offset2 >= this.myBufferEndOffset) {
                return this.myBufferEndOffset;
            }
            pos = offset2;
            char c2 = cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            while (true) {
                if (cur != c && cur != '\n' && cur != '\r' && cur != '\\') {
                    if (++pos >= this.myBufferEndOffset) {
                        return this.myBufferEndOffset;
                    }
                    cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
                    continue;
                }
                if (cur != '\\') break;
                if (++pos >= this.myBufferEndOffset) {
                    return this.myBufferEndOffset;
                }
                cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
                if (cur == '\n' || cur == '\r') continue;
                if (++pos >= this.myBufferEndOffset) {
                    return this.myBufferEndOffset;
                }
                cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            }
            if (cur == c) break block6;
            --pos;
        }
        return pos + 1;
    }

    private int getClosingComment(int offset2) {
        int pos;
        for (pos = offset2; pos < this.myBufferEndOffset - 1; ++pos) {
            char c;
            char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            if (c == '*' && (this.myBufferArray != null ? this.myBufferArray[pos + 1] : this.myBuffer.charAt(pos + 1)) == '/') break;
        }
        return pos + 2;
    }

    private int getLineTerminator(int offset2) {
        int pos;
        for (pos = offset2; pos < this.myBufferEndOffset; ++pos) {
            char c;
            char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            if (c == '\r' || c == '\n') break;
        }
        return pos;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            JavaLexer.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @Override
    public final int getBufferEnd() {
        return this.myBufferEndOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/lexer/JavaLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/lexer/JavaLexer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSoftKeyword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

