/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.pico;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.kotlin.org.picocontainer.ComponentMonitor;
import org.jetbrains.kotlin.org.picocontainer.Parameter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoInitializationException;
import org.jetbrains.kotlin.org.picocontainer.PicoIntrospectionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.CyclicDependencyException;
import org.jetbrains.kotlin.org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.defaults.NotConcreteRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.jetbrains.kotlin.org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class CachingConstructorInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private static final ThreadLocal<Set<CachingConstructorInjectionComponentAdapter>> ourGuard = new ThreadLocal();
    private Object myInstance;

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(2);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(3);
        }
        super(componentKey, componentImplementation, parameters2, allowNonPublicClasses, DefaultPicoContainer.DEFAULT_DELEGATING_COMPONENT_MONITOR, DefaultPicoContainer.DEFAULT_LIFECYCLE_STRATEGY);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters2) {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(4);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(5);
        }
        this(componentKey, componentImplementation, parameters2, false);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(6);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(7);
        }
        this(componentKey, componentImplementation, (Parameter[])null);
    }

    @Override
    public Object getComponentInstance(PicoContainer container2) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object instance = this.myInstance;
        if (instance == null) {
            this.myInstance = instance = this.instantiateGuarded(container2, this.getComponentImplementation());
        }
        return instance;
    }

    private Object instantiateGuarded(PicoContainer container2, Class stackFrame) {
        Set<CachingConstructorInjectionComponentAdapter> currentStack = ourGuard.get();
        if (currentStack == null) {
            currentStack = ContainerUtil.newIdentityTroveSet();
            ourGuard.set(currentStack);
        }
        if (currentStack.contains(this)) {
            throw new CyclicDependencyException(stackFrame);
        }
        try {
            currentStack.add(this);
            Object object = this.doGetComponentInstance(container2);
            return object;
        }
        catch (CyclicDependencyException e) {
            e.push(stackFrame);
            throw e;
        }
        finally {
            currentStack.remove(this);
        }
    }

    private Object doGetComponentInstance(PicoContainer guardedContainer) {
        Constructor constructor;
        try {
            constructor = this.getGreediestSatisfiableConstructor(guardedContainer);
        }
        catch (AmbiguousComponentResolutionException e) {
            e.setComponent(this.getComponentImplementation());
            throw e;
        }
        ComponentMonitor componentMonitor = this.currentMonitor();
        try {
            Object[] parameters2 = this.getConstructorArguments(guardedContainer, constructor);
            componentMonitor.instantiating(constructor);
            long startTime = System.currentTimeMillis();
            Object inst = this.newInstance(constructor, parameters2);
            componentMonitor.instantiated(constructor, System.currentTimeMillis() - startTime);
            return inst;
        }
        catch (InvocationTargetException e) {
            componentMonitor.instantiationFailed(constructor, e);
            ExceptionUtil.rethrowUnchecked(e.getTargetException());
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            componentMonitor.instantiationFailed(constructor, e);
            throw new PicoInitializationException("Should never get here");
        }
        catch (IllegalAccessException e) {
            componentMonitor.instantiationFailed(constructor, e);
            throw new PicoInitializationException(e);
        }
    }

    @NotNull
    private Object[] getConstructorArguments(PicoContainer container2, Constructor ctor) {
        Class[] parameterTypes = ctor.getParameterTypes();
        Object[] result2 = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            result2[i] = currentParameters[i].resolveInstance(container2, this, parameterTypes[i]);
        }
        if (result2 == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(8);
        }
        return result2;
    }

    @Override
    protected Constructor getGreediestSatisfiableConstructor(PicoContainer container2) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        List<Constructor> sortedMatchingConstructors = this.getSortedMatchingConstructors();
        Constructor greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class unsatisfiedDependencyType = null;
        for (Constructor constructor : sortedMatchingConstructors) {
            boolean failedDependency = false;
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container2, this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = parameterTypes[j];
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container2);
        }
        if (greediestConstructor == null) {
            HashSet<Constructor> nonMatching = ContainerUtil.newHashSet(this.getConstructors());
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + ((Object)nonMatching).toString() + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        return greediestConstructor;
    }

    private List<Constructor> getSortedMatchingConstructors() {
        ArrayList<Constructor> matchingConstructors = new ArrayList<Constructor>();
        for (Constructor constructor : this.getConstructors()) {
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            matchingConstructors.sort((arg0, arg1) -> arg1.getParameterTypes().length - arg0.getParameterTypes().length);
        }
        return matchingConstructors;
    }

    @NotNull
    private Constructor[] getConstructors() {
        Constructor[] constructorArray = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CachingConstructorInjectionComponentAdapter.this.getComponentImplementation().getDeclaredConstructors();
            }
        });
        if (constructorArray == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(9);
        }
        return constructorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/pico/CachingConstructorInjectionComponentAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/pico/CachingConstructorInjectionComponentAdapter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorArguments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

