/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.processing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InterningStringSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.SetSerializer;

public class AnnotationProcessingData {
    private final Map<String, Set<String>> generatedTypesByOrigin;
    private final Set<String> aggregatedTypes;
    private final Set<String> generatedTypesDependingOnAllOthers;
    private final String fullRebuildCause;

    public AnnotationProcessingData() {
        this((Map<String, Set<String>>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), null);
    }

    public AnnotationProcessingData(Map<String, Set<String>> generatedTypesByOrigin, Set<String> aggregatedTypes, Set<String> generatedTypesDependingOnAllOthers, String fullRebuildCause) {
        this.generatedTypesByOrigin = ImmutableMap.copyOf(generatedTypesByOrigin);
        this.aggregatedTypes = ImmutableSet.copyOf(aggregatedTypes);
        this.generatedTypesDependingOnAllOthers = ImmutableSet.copyOf(generatedTypesDependingOnAllOthers);
        this.fullRebuildCause = fullRebuildCause;
    }

    public Map<String, Set<String>> getGeneratedTypesByOrigin() {
        return this.generatedTypesByOrigin;
    }

    public Set<String> getAggregatedTypes() {
        return this.aggregatedTypes;
    }

    public Set<String> getGeneratedTypesDependingOnAllOthers() {
        return this.generatedTypesDependingOnAllOthers;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public static final class Serializer
    extends AbstractSerializer<AnnotationProcessingData> {
        private final SetSerializer<String> typesSerializer;
        private final MapSerializer<String, Set<String>> generatedTypesSerializer;

        public Serializer(StringInterner interner) {
            InterningStringSerializer stringSerializer = new InterningStringSerializer(interner);
            this.typesSerializer = new SetSerializer((org.gradle.internal.serialize.Serializer)stringSerializer);
            this.generatedTypesSerializer = new MapSerializer((org.gradle.internal.serialize.Serializer)stringSerializer, this.typesSerializer);
        }

        public AnnotationProcessingData read(Decoder decoder) throws Exception {
            Map generatedTypes = this.generatedTypesSerializer.read(decoder);
            Set aggregatedTypes = (Set)this.typesSerializer.read(decoder);
            Set generatedTypesDependingOnAllOthers = (Set)this.typesSerializer.read(decoder);
            String fullRebuildCause = decoder.readNullableString();
            return new AnnotationProcessingData(generatedTypes, aggregatedTypes, generatedTypesDependingOnAllOthers, fullRebuildCause);
        }

        public void write(Encoder encoder, AnnotationProcessingData value) throws Exception {
            this.generatedTypesSerializer.write(encoder, value.generatedTypesByOrigin);
            this.typesSerializer.write(encoder, (Collection)value.aggregatedTypes);
            this.typesSerializer.write(encoder, (Collection)value.generatedTypesDependingOnAllOthers);
            encoder.writeNullableString((CharSequence)value.fullRebuildCause);
        }
    }
}

