/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;

class GIFWriter {
    private ImageWriter gifWriter = GIFWriter.getWriter();
    private ImageWriteParam imageWriteParam = this.gifWriter.getDefaultWriteParam();
    private IIOMetadata imageMetadata;

    public GIFWriter(ImageOutputStream outputStream, int imageType, int timeBetweenFramesInMS, boolean loopContinuous) throws IIOException, IOException {
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(imageType);
        this.imageMetadata = this.gifWriter.getDefaultImageMetadata(imageTypeSpecifier, this.imageWriteParam);
        String metadataFormatName = this.imageMetadata.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)this.imageMetadata.getAsTree(metadataFormatName);
        IIOMetadataNode graphicsControlExtensionNode = GIFWriter.getNode(root, "GraphicControlExtension");
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(timeBetweenFramesInMS / 10));
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        IIOMetadataNode appExtensionsNode = GIFWriter.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = loopContinuous ? 0 : 1;
        child.setUserObject(new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)});
        appExtensionsNode.appendChild(child);
        this.imageMetadata.setFromTree(metadataFormatName, root);
        this.gifWriter.setOutput(outputStream);
        this.gifWriter.prepareWriteSequence(null);
    }

    private static ImageWriter getWriter() throws IIOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("gif");
        if (!iterator.hasNext()) {
            throw new IIOException("Error finding GIF Image Writer");
        }
        return iterator.next();
    }

    private static IIOMetadataNode getNode(IIOMetadataNode root, String nodeName) {
        int numNodes = root.getLength();
        for (int i = 0; i < numNodes; ++i) {
            if (root.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)root.item(i);
        }
        IIOMetadataNode newNode = new IIOMetadataNode(nodeName);
        root.appendChild(newNode);
        return newNode;
    }

    public void writeToSequence(RenderedImage image) throws IOException {
        this.gifWriter.writeToSequence(new IIOImage(image, null, this.imageMetadata), this.imageWriteParam);
    }

    public void close() throws IOException {
        this.gifWriter.endWriteSequence();
    }
}

