/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.josm.data.imagery.AbstractWMSTileSource;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class WMSEndpointTileSource
extends AbstractWMSTileSource
implements TemplatedTileSource {
    private final WMSImagery wmsi;
    private final List<DefaultLayer> layers;
    private final String urlPattern;
    private static final Pattern PATTERN_PARAM = Pattern.compile("\\{([^}]+)\\}");
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();

    public WMSEndpointTileSource(ImageryInfo info, Projection tileProjection) {
        super(info, tileProjection);
        CheckParameterUtil.ensure(info, "imageryType", x -> ImageryInfo.ImageryType.WMS_ENDPOINT == x.getImageryType());
        try {
            this.wmsi = new WMSImagery(info.getUrl(), info.getCustomHttpHeaders());
        }
        catch (IOException | WMSImagery.WMSGetCapabilitiesException e) {
            throw new IllegalArgumentException(e);
        }
        this.layers = info.getDefaultLayers();
        this.initProjection();
        this.urlPattern = this.wmsi.buildGetMapUrl(this.layers, info.isTransparent());
        this.headers.putAll(info.getCustomHttpHeaders());
    }

    @Override
    public int getDefaultTileSize() {
        return WMSLayer.PROP_IMAGE_SIZE.get();
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        String bbox = this.getBbox(zoom, tilex, tiley, !this.wmsi.belowWMS130() && this.getTileProjection().switchXY());
        StringBuffer url = new StringBuffer(this.urlPattern.length());
        Matcher matcher = PATTERN_PARAM.matcher(this.urlPattern);
        while (matcher.find()) {
            String replacement;
            switch (matcher.group(1)) {
                case "proj": {
                    replacement = this.getServerCRS();
                    break;
                }
                case "bbox": {
                    replacement = bbox;
                    break;
                }
                case "width": 
                case "height": {
                    replacement = String.valueOf(this.getTileSize());
                    break;
                }
                default: {
                    replacement = '{' + matcher.group(1) + '}';
                }
            }
            matcher.appendReplacement(url, replacement);
        }
        matcher.appendTail(url);
        return url.toString();
    }

    public List<String> getServerProjections() {
        return this.wmsi.getLayers(this.layers).stream().flatMap(x -> x.getCrs().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

