/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LayeredIcon
extends JBUI.CachingScalableJBIcon<LayeredIcon> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.LayeredIcon");
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;
    private final boolean[] myDisabledLayers;
    private final int[] myHShifts;
    private final int[] myVShifts;
    private int myXShift;
    private int myYShift;
    private int myWidth;
    private int myHeight;

    public LayeredIcon(int layerCount) {
        ((JBUI.BaseScaleContext)this.getScaleContext()).addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myIcons = new Icon[layerCount];
        this.myDisabledLayers = new boolean[layerCount];
        this.myHShifts = new int[layerCount];
        this.myVShifts = new int[layerCount];
    }

    public LayeredIcon(Icon ... icons) {
        if (icons == null) {
            LayeredIcon.$$$reportNull$$$0(0);
        }
        this(icons.length);
        for (int i = 0; i < icons.length; ++i) {
            this.setIcon(icons[i], i);
        }
    }

    protected LayeredIcon(LayeredIcon icon) {
        super(icon);
        ((JBUI.BaseScaleContext)this.getScaleContext()).addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myIcons = ArrayUtil.copyOf(icon.myIcons);
        this.myScaledIcons = null;
        this.myDisabledLayers = ArrayUtil.copyOf(icon.myDisabledLayers);
        this.myHShifts = ArrayUtil.copyOf(icon.myHShifts);
        this.myVShifts = ArrayUtil.copyOf(icon.myVShifts);
        this.myXShift = icon.myXShift;
        this.myYShift = icon.myYShift;
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
    }

    @Override
    @NotNull
    public LayeredIcon copy() {
        LayeredIcon layeredIcon = new LayeredIcon(this);
        if (layeredIcon == null) {
            LayeredIcon.$$$reportNull$$$0(1);
        }
        return layeredIcon;
    }

    @NotNull
    private Icon[] myScaledIcons() {
        if (this.myScaledIcons != null) {
            if (this.myScaledIcons == null) {
                LayeredIcon.$$$reportNull$$$0(2);
            }
            return this.myScaledIcons;
        }
        this.myScaledIcons = RowIcon.scaleIcons(this.myIcons, this.getScale());
        if (this.myScaledIcons == null) {
            LayeredIcon.$$$reportNull$$$0(3);
        }
        return this.myScaledIcons;
    }

    @Override
    @NotNull
    public LayeredIcon withIconPreScaled(boolean preScaled) {
        super.withIconPreScaled(preScaled);
        this.updateSize();
        LayeredIcon layeredIcon = this;
        if (layeredIcon == null) {
            LayeredIcon.$$$reportNull$$$0(4);
        }
        return layeredIcon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LayeredIcon)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LayeredIcon icon = (LayeredIcon)o;
        if (this.myHeight != icon.myHeight) {
            return false;
        }
        if (this.myWidth != icon.myWidth) {
            return false;
        }
        if (this.myXShift != icon.myXShift) {
            return false;
        }
        if (this.myYShift != icon.myYShift) {
            return false;
        }
        if (!Arrays.equals(this.myHShifts, icon.myHShifts)) {
            return false;
        }
        if (!Arrays.equals(this.myIcons, icon.myIcons)) {
            return false;
        }
        return Arrays.equals(this.myVShifts, icon.myVShifts);
    }

    public int hashCode() {
        return 0;
    }

    public void setIcon(Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    public void setIcon(Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)icon).checkIHaventIconInsideMe(this);
        }
        this.myIcons[layer] = icon;
        this.myScaledIcons = null;
        this.myHShifts[layer] = hShift;
        this.myVShifts[layer] = vShift;
        this.updateSize();
    }

    private void checkIHaventIconInsideMe(Icon icon) {
        LOG.assertTrue(icon != this);
        for (Icon child : this.myIcons) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)child).checkIHaventIconInsideMe(icon);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ((JBUI.BaseScaleContext)this.getScaleContext()).update();
        Icon[] icons = this.myScaledIcons();
        for (int i = 0; i < icons.length; ++i) {
            Icon icon = icons[i];
            if (icon == null || this.myDisabledLayers[i]) continue;
            int xOffset = (int)Math.floor((double)x + this.scaleVal(this.myXShift + this.myHShifts(i), JBUI.ScaleType.OBJ_SCALE));
            int yOffset = (int)Math.floor((double)y + this.scaleVal(this.myYShift + this.myVShifts(i), JBUI.ScaleType.OBJ_SCALE));
            icon.paintIcon(c, g, xOffset, yOffset);
        }
    }

    @Override
    public int getIconWidth() {
        ((JBUI.BaseScaleContext)this.getScaleContext()).update();
        if (this.myWidth <= 1) {
            this.updateSize();
        }
        return (int)Math.ceil(this.scaleVal(this.myWidth, JBUI.ScaleType.OBJ_SCALE));
    }

    @Override
    public int getIconHeight() {
        ((JBUI.BaseScaleContext)this.getScaleContext()).update();
        if (this.myHeight <= 1) {
            this.updateSize();
        }
        return (int)Math.ceil(this.scaleVal(this.myHeight, JBUI.ScaleType.OBJ_SCALE));
    }

    private int myHShifts(int i) {
        return (int)Math.floor(this.scaleVal(this.myHShifts[i], JBUI.ScaleType.USR_SCALE));
    }

    private int myVShifts(int i) {
        return (int)Math.floor(this.scaleVal(this.myVShifts[i], JBUI.ScaleType.USR_SCALE));
    }

    protected void updateSize() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean allIconsAreNull = true;
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.myIcons[i];
            if (icon == null) continue;
            allIconsAreNull = false;
            int hShift = this.myHShifts(i);
            int vShift = this.myVShifts(i);
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        if (allIconsAreNull) {
            return;
        }
        this.myWidth = maxX - minX;
        this.myHeight = maxY - minY;
        if (this.myIcons.length > 1) {
            this.myXShift = -minX;
            this.myYShift = -minY;
        }
    }

    @Override
    public String toString() {
        return "Layered icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/LayeredIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/LayeredIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "myScaledIcons";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withIconPreScaled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLayers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

