/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Getter;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import java.lang.ref.ReferenceQueue;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentIntKeyRefValueHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final ConcurrentIntObjectMap<IntReference<V>> myMap = ContainerUtil.createConcurrentIntObjectMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentIntKeyRefValueHashMap() {
    }

    @NotNull
    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, @NotNull ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    @Override
    @NotNull
    public V cacheOrGet(int key, @NotNull V value) {
        IntReference<V> ref;
        boolean replaced;
        if (value == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(0);
        }
        this.processQueue();
        IntReference<V> newRef = this.createReference(key, value, this.myQueue);
        do {
            if ((ref = this.myMap.putIfAbsent(key, newRef)) == null) {
                V v2 = value;
                if (v2 == null) {
                    ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(1);
                }
                return v2;
            }
            Object old = ref.get();
            if (old == null) continue;
            Object a = old;
            if (a == null) {
                ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(2);
            }
            return (V)a;
        } while (!(replaced = this.myMap.replace(key, ref, newRef)));
        V v3 = value;
        if (v3 == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(3);
        }
        return v3;
    }

    @Override
    public boolean remove(int key, @NotNull V value) {
        if (value == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(4);
        }
        this.processQueue();
        return this.myMap.remove(key, this.createReference(key, value, this.myQueue));
    }

    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(5);
        }
        if (newValue == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(6);
        }
        this.processQueue();
        return this.myMap.replace(key, this.createReference(key, oldValue, this.myQueue), this.createReference(key, newValue, this.myQueue));
    }

    @Override
    public V put(int key, @NotNull V value) {
        if (value == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(7);
        }
        this.processQueue();
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value, this.myQueue));
        return SoftReference.deref(ref);
    }

    @Override
    public V get(int key) {
        IntReference ref = (IntReference)this.myMap.get(key);
        return (V)SoftReference.deref(ref);
    }

    @Override
    public V remove(int key) {
        this.processQueue();
        IntReference ref = (IntReference)this.myMap.remove(key);
        return (V)SoftReference.deref(ref);
    }

    @Override
    @NotNull
    public Iterable<IntObjectMap.Entry<V>> entries() {
        final Iterator entryIterator = this.myMap.entries().iterator();
        Iterable iterable = new Iterable<IntObjectMap.Entry<V>>(){

            @Override
            @NotNull
            public Iterator<IntObjectMap.Entry<V>> iterator() {
                Iterator iterator2 = new Iterator<IntObjectMap.Entry<V>>(){
                    private IntObjectMap.Entry<V> next = this.nextAliveEntry();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public IntObjectMap.Entry<V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        IntObjectMap.Entry result2 = this.next;
                        this.next = this.nextAliveEntry();
                        return result2;
                    }

                    private IntObjectMap.Entry<V> nextAliveEntry() {
                        while (entryIterator.hasNext()) {
                            IntObjectMap.Entry entry = (IntObjectMap.Entry)entryIterator.next();
                            final Object v2 = ((IntReference)entry.getValue()).get();
                            if (v2 == null) continue;
                            final int key = entry.getKey();
                            return new IntObjectMap.Entry<V>(){

                                @Override
                                public int getKey() {
                                    return key;
                                }

                                @Override
                                @NotNull
                                public V getValue() {
                                    Object object = v2;
                                    if (object == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return object;
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentIntKeyRefValueHashMap$1$1$1", "getValue"));
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentIntKeyRefValueHashMap$1", "iterator"));
            }
        };
        if (iterable == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(10);
        }
        return iterable;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.myMap.size();
    }

    @Override
    @NotNull
    public Enumeration<V> elements() {
        final Enumeration<IntReference<V>> elementRefs = this.myMap.elements();
        Enumeration enumeration = new Enumeration<V>(){
            private V next = this.findNextRef();

            private V findNextRef() {
                while (elementRefs.hasMoreElements()) {
                    IntReference result2 = (IntReference)elementRefs.nextElement();
                    Object v2 = result2.get();
                    if (v2 == null) continue;
                    return v2;
                }
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public V nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object v2 = this.next;
                this.next = this.findNextRef();
                return v2;
            }
        };
        if (enumeration == null) {
            ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(11);
        }
        return enumeration;
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value) {
        Object oldVal;
        block3: {
            IntReference<V> oldRef;
            if (value == null) {
                ConcurrentIntKeyRefValueHashMap.$$$reportNull$$$0(12);
            }
            IntReference<V> newRef = this.createReference(key, value, this.myQueue);
            do {
                this.processQueue();
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block3;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return (V)oldVal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentIntKeyRefValueHashMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentIntKeyRefValueHashMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "entries";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "elements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface IntReference<V>
    extends Getter<V> {
        public int getKey();
    }
}

