package Lire::UI::ReportConfigListWidget;

use strict;

use base qw/ Lire::UI::PolyListWidget /;

use Lire::ReportConfig;

sub update_type_popupmenu {
    my $self = $_[0];

    my $popup = $self->getobj( 'type_widget' );
    $popup->{'-values'} = [ sort @{Lire::ReportConfig->templates()} ];
    $popup->{'-labels'} = {};

    return;
}

sub new_value {
    my $self = $_[0];

    my $template = $self->getobj( 'type_widget' )->get();
    return undef unless defined $template;

    # We need to switch the spec object if we hope to
    # get the list object to accept this instance
    my $value = Lire::ReportConfig->template( $template )->clone();
    my $spec = $self->{'value'}->spec();
    $value->{'spec'} = $spec->get( ($spec->component_names())[0] );

    return $value;
}

1;
