/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;

public class ExecutionPlanItem {
    private final MojoExecution mojoExecution;

    public ExecutionPlanItem(MojoExecution mojoExecution) {
        this.mojoExecution = mojoExecution;
    }

    public static List<ExecutionPlanItem> createExecutionPlanItems(MavenProject mavenProject, List<MojoExecution> executions) {
        BuilderCommon.attachToThread(mavenProject);
        ArrayList<ExecutionPlanItem> result = new ArrayList<ExecutionPlanItem>();
        for (MojoExecution mojoExecution : executions) {
            result.add(new ExecutionPlanItem(mojoExecution));
        }
        return result;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public String getLifecyclePhase() {
        return this.mojoExecution.getLifecyclePhase();
    }

    public Plugin getPlugin() {
        MojoDescriptor mojoDescriptor = this.getMojoExecution().getMojoDescriptor();
        return mojoDescriptor.getPluginDescriptor().getPlugin();
    }

    public String toString() {
        return "ExecutionPlanItem{, mojoExecution=" + this.mojoExecution + '}' + super.toString();
    }
}

