/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import java.net.URI;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoMappedRepositoryIRIMapper
implements OWLOntologyIRIMapper {
    private final Logger logger = LoggerFactory.getLogger(AutoMappedRepositoryIRIMapper.class);
    private final OntologyCatalogManager ontologyCatalogManager;

    public AutoMappedRepositoryIRIMapper(OntologyCatalogManager ontologyCatalogManager) {
        this.ontologyCatalogManager = ontologyCatalogManager;
    }

    public IRI getDocumentIRI(IRI importedIRI) {
        URI u = this.ontologyCatalogManager.getRedirect(importedIRI.toURI());
        if (u == null) {
            this.logger.info("Imported ontology document {} was not resolved to any documents defined in the ontology catalog.", (Object)importedIRI);
            return null;
        }
        this.logger.info("Imported ontology document {} was resolved to {} by the ontology catalog.", (Object)importedIRI, (Object)u);
        return IRI.create((URI)u);
    }
}

