// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * This interface allows applications to monitor the state of object
 * adapters that are registered with IceGrid.
 **/
public interface AdapterObserver extends com.zeroc.Ice.Object
{
    /**
     * <tt>adapterInit</tt> is called after registration of
     * an observer to indicate the state of the registry.
     * @param adpts The adapters that were dynamically registered
     * with the registry (not through the deployment mechanism).
     * @param current The Current object for the invocation.
     **/
    void adapterInit(AdapterInfo[] adpts, com.zeroc.Ice.Current current);

    /**
     * The <tt>adapterAdded</tt> operation is called to notify an observer when
     * a dynamically-registered adapter was added.
     * @param info The details of the new adapter.
     * @param current The Current object for the invocation.
     **/
    void adapterAdded(AdapterInfo info, com.zeroc.Ice.Current current);

    /**
     * The adapterUpdated operation is called to notify an observer when
     * a dynamically-registered adapter was updated.
     * @param info The details of the updated adapter.
     * @param current The Current object for the invocation.
     **/
    void adapterUpdated(AdapterInfo info, com.zeroc.Ice.Current current);

    /**
     * The adapterRemoved operation is called to notify an observer when
     * a dynamically-registered adapter was removed.
     * @param id The ID of the removed adapter.
     * @param current The Current object for the invocation.
     **/
    void adapterRemoved(String id, com.zeroc.Ice.Current current);

    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceGrid::AdapterObserver"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::AdapterObserver";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_adapterInit(AdapterObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        AdapterInfo[] iceP_adpts;
        iceP_adpts = AdapterInfoSeqHelper.read(istr);
        inS.endReadParams();
        obj.adapterInit(iceP_adpts, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_adapterAdded(AdapterObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        AdapterInfo iceP_info;
        iceP_info = AdapterInfo.ice_read(istr);
        inS.endReadParams();
        obj.adapterAdded(iceP_info, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_adapterUpdated(AdapterObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        AdapterInfo iceP_info;
        iceP_info = AdapterInfo.ice_read(istr);
        inS.endReadParams();
        obj.adapterUpdated(iceP_info, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_adapterRemoved(AdapterObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        obj.adapterRemoved(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    final static String[] _iceOps =
    {
        "adapterAdded",
        "adapterInit",
        "adapterRemoved",
        "adapterUpdated",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_adapterAdded(this, in, current);
            }
            case 1:
            {
                return _iceD_adapterInit(this, in, current);
            }
            case 2:
            {
                return _iceD_adapterRemoved(this, in, current);
            }
            case 3:
            {
                return _iceD_adapterUpdated(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 7:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
