/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.structure.CallComputation;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/Substitutor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "substitutions", "", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "(Ljava/util/Map;)V", "visitAnd", "and", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitConstant", "esConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "visitEqual", "equal", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitIs", "isOperator", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitNot", "not", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitOr", "or", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitVariable", "esVariable", "resolution"})
public final class Substitutor
implements ESExpressionVisitor<Computation> {
    private final Map<ESVariable, Computation> substitutions;

    @Override
    @Nullable
    public Computation visitIs(@NotNull ESIs isOperator) {
        Intrinsics.checkParameterIsNotNull(isOperator, "isOperator");
        Computation computation = (Computation)isOperator.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), isOperator.getFunctor().invokeWithArguments(arg));
    }

    @Override
    @Nullable
    public Computation visitNot(@NotNull ESNot not) {
        Intrinsics.checkParameterIsNotNull(not, "not");
        Computation computation = (Computation)not.getArg().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), not.getFunctor().invokeWithArguments(arg));
    }

    @Override
    @Nullable
    public Computation visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkParameterIsNotNull(equal, "equal");
        Computation computation = (Computation)equal.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)equal.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), equal.getFunctor().invokeWithArguments(CollectionsKt.listOf(left, right)));
    }

    @Override
    @Nullable
    public Computation visitAnd(@NotNull ESAnd and) {
        Intrinsics.checkParameterIsNotNull(and, "and");
        Computation computation = (Computation)and.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)and.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), and.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @Nullable
    public Computation visitOr(@NotNull ESOr or2) {
        Intrinsics.checkParameterIsNotNull(or2, "or");
        Computation computation = (Computation)or2.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)or2.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), or2.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @Nullable
    public Computation visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkParameterIsNotNull(esVariable, "esVariable");
        Computation computation = this.substitutions.get(esVariable);
        if (computation == null) {
            computation = esVariable;
        }
        return computation;
    }

    @Override
    @Nullable
    public Computation visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkParameterIsNotNull(esConstant, "esConstant");
        return esConstant;
    }

    public Substitutor(@NotNull Map<ESVariable, ? extends Computation> substitutions) {
        Intrinsics.checkParameterIsNotNull(substitutions, "substitutions");
        this.substitutions = substitutions;
    }
}

