/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Identity;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.Holder;
import com.zeroc.IceInternal.Reference;
import com.zeroc.IceInternal.Time;
import java.util.HashMap;
import java.util.Map;

final class LocatorTable {
    private Map<String, EndpointTableEntry> _adapterEndpointsTable = new HashMap<String, EndpointTableEntry>();
    private Map<Identity, ReferenceTableEntry> _objectTable = new HashMap<Identity, ReferenceTableEntry>();

    LocatorTable() {
    }

    synchronized void clear() {
        this._adapterEndpointsTable.clear();
        this._objectTable.clear();
    }

    synchronized EndpointI[] getAdapterEndpoints(String adapter, int ttl, Holder<Boolean> cached) {
        if (ttl == 0) {
            cached.value = false;
            return null;
        }
        EndpointTableEntry entry = this._adapterEndpointsTable.get(adapter);
        if (entry != null) {
            cached.value = this.checkTTL(entry.time, ttl);
            return entry.endpoints;
        }
        cached.value = false;
        return null;
    }

    synchronized void addAdapterEndpoints(String adapter, EndpointI[] endpoints) {
        this._adapterEndpointsTable.put(adapter, new EndpointTableEntry(Time.currentMonotonicTimeMillis(), endpoints));
    }

    synchronized EndpointI[] removeAdapterEndpoints(String adapter) {
        EndpointTableEntry entry = this._adapterEndpointsTable.remove(adapter);
        return entry != null ? entry.endpoints : null;
    }

    synchronized Reference getObjectReference(Identity id, int ttl, Holder<Boolean> cached) {
        if (ttl == 0) {
            cached.value = false;
            return null;
        }
        ReferenceTableEntry entry = this._objectTable.get(id);
        if (entry != null) {
            cached.value = this.checkTTL(entry.time, ttl);
            return entry.reference;
        }
        cached.value = false;
        return null;
    }

    synchronized void addObjectReference(Identity id, Reference ref) {
        this._objectTable.put(id, new ReferenceTableEntry(Time.currentMonotonicTimeMillis(), ref));
    }

    synchronized Reference removeObjectReference(Identity id) {
        ReferenceTableEntry entry = this._objectTable.remove(id);
        return entry != null ? entry.reference : null;
    }

    private boolean checkTTL(long time, int ttl) {
        assert (ttl != 0);
        if (ttl < 0) {
            return true;
        }
        return Time.currentMonotonicTimeMillis() - time <= (long)ttl * 1000L;
    }

    private static final class ReferenceTableEntry {
        public final long time;
        public final Reference reference;

        public ReferenceTableEntry(long time, Reference reference) {
            this.time = time;
            this.reference = reference;
        }
    }

    private static final class EndpointTableEntry {
        public final long time;
        public final EndpointI[] endpoints;

        public EndpointTableEntry(long time, EndpointI[] endpoints) {
            this.time = time;
            this.endpoints = endpoints;
        }
    }
}

