/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ar extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0627\u0644\u0639\u0631\u0628\u064a\u0629";
        final String metaValue_bn = "\u0627\u0644\u0628\u0646\u063a\u0627\u0644\u064a\u0629";
        final String metaValue_bo = "\u0627\u0644\u062a\u0628\u062a\u064a\u0629";
        final String metaValue_el = "\u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629";
        final String metaValue_he = "\u0627\u0644\u0639\u0628\u0631\u064a\u0629";
        final String metaValue_hy = "\u0627\u0644\u0623\u0631\u0645\u064a\u0646\u064a\u0629";
        final String metaValue_ja = "\u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a\u0629";
        final String metaValue_jv = "\u0627\u0644\u062c\u0627\u0648\u064a\u0629";
        final String metaValue_ka = "\u0627\u0644\u062c\u0648\u0631\u062c\u064a\u0629";
        final String metaValue_km = "\u0627\u0644\u062e\u0645\u064a\u0631\u064a\u0629";
        final String metaValue_kn = "\u0627\u0644\u0643\u0627\u0646\u0627\u062f\u0627";
        final String metaValue_ko = "\u0627\u0644\u0643\u0648\u0631\u064a\u0629";
        final String metaValue_la = "\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629";
        final String metaValue_ml = "\u0627\u0644\u0645\u0627\u0644\u064a\u0627\u0644\u0627\u0645";
        final String metaValue_pi = "\u0627\u0644\u0628\u0627\u0644\u064a\u0629";
        final String metaValue_su = "\u0627\u0644\u0633\u0648\u0646\u062f\u0627\u0646\u064a\u0629";
        final String metaValue_ta = "\u0627\u0644\u062a\u0627\u0645\u064a\u0644\u064a\u0629";
        final String metaValue_te = "\u0627\u0644\u062a\u064a\u0644\u062c\u0648";
        final String metaValue_th = "\u0627\u0644\u062a\u0627\u064a\u0644\u0627\u0646\u062f\u064a\u0629";
        final String metaValue_chr = "\u0627\u0644\u0634\u064a\u0631\u0648\u0643\u064a";
        final String metaValue_cop = "\u0627\u0644\u0642\u0628\u0637\u064a\u0629";
        final String metaValue_got = "\u0627\u0644\u0642\u0648\u0637\u064a\u0629";
        final String metaValue_nqo = "\u0623\u0646\u0643\u0648";
        final String metaValue_peo = "\u0627\u0644\u0641\u0627\u0631\u0633\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629";
        final String metaValue_phn = "\u0627\u0644\u0641\u064a\u0646\u064a\u0642\u064a\u0629";
        final String metaValue_syr = "\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629";
        final String metaValue_vai = "\u0627\u0644\u0641\u0627\u064a";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0644\u063a\u0629 \u0627\u0644\u0643\u0648\u0644\u0648\u0646\u064a\u0627\u0646" },
            { "Ogam", "\u0627\u0644\u0623\u0648\u062c\u0647\u0627\u0645" },
            { "mwl", "\u0627\u0644\u0645\u064a\u0631\u0627\u0646\u062f\u064a\u0632" },
            { "key.colStrength", "\u0642\u0648\u0629 \u0627\u0644\u062a\u0635\u0646\u064a\u0641" },
            { "Zsym", "\u0631\u0645\u0648\u0632" },
            { "cch", "\u0627\u0644\u0623\u062a\u0633\u0627\u0645" },
            { "mwr", "\u0627\u0644\u0645\u0627\u0631\u0648\u0627\u0631\u064a\u0629" },
            { "Tagb", "\u0627\u0644\u062a\u0627\u062c\u0628\u0627\u0646\u0648\u0627" },
            { "egy", "\u0627\u0644\u0645\u0635\u0631\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "raj", "\u0627\u0644\u0631\u0627\u062c\u0627\u0633\u062b\u0627\u0646\u064a\u0629" },
            { "Phag", "\u0627\u0644\u0641\u0627\u062c\u0633\u0628\u0627" },
            { "tem", "\u0627\u0644\u062a\u064a\u0645\u0646" },
            { "teo", "\u062a\u064a\u0633\u0648" },
            { "rap", "\u0627\u0644\u0631\u0627\u0628\u0627\u0646\u064a" },
            { "ter", "\u0627\u0644\u062a\u064a\u0631\u064a\u0646\u0648" },
            { "AC", "\u062c\u0632\u064a\u0631\u0629 \u0623\u0633\u064a\u0646\u0634\u064a\u0648\u0646" },
            { "rar", "\u0627\u0644\u0631\u0627\u0631\u0648\u062a\u0648\u0646\u062c\u0627\u0646\u064a" },
            { "tet", "\u0627\u0644\u062a\u064a\u062a\u0645" },
            { "AD", "\u0623\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "nl_BE", "\u0627\u0644\u0641\u0644\u0645\u0646\u0643\u064a\u0629" },
            { "AF", "\u0623\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0623\u0646\u062a\u064a\u063a\u0648\u0627 \u0648\u0628\u0631\u0628\u0648\u062f\u0627" },
            { "type.ca.ethiopic", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u062b\u064a\u0648\u0628\u064a" },
            { "AI", "\u0623\u0646\u063a\u0648\u064a\u0644\u0627" },
            { "key.tz", "\u0627\u0644\u0645\u0646\u0637\u0642\u0629 \u0627\u0644\u0632\u0645\u0646\u064a\u0629" },
            { "AL", "\u0623\u0644\u0628\u0627\u0646\u064a\u0627" },
            { "AM", "\u0623\u0631\u0645\u064a\u0646\u064a\u0627" },
            { "Teng", "\u0627\u0644\u062a\u064a\u0646\u062c\u0648\u0627\u0631" },
            { "AO", "\u0623\u0646\u063a\u0648\u0644\u0627" },
            { "AQ", "\u0623\u0646\u062a\u0627\u0631\u0643\u062a\u064a\u0643\u0627" },
            { "AR", "\u0627\u0644\u0623\u0631\u062c\u0646\u062a\u064a\u0646" },
            { "AS", "\u0633\u0627\u0645\u0648\u0627 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a\u0629" },
            { "AT", "\u0627\u0644\u0646\u0645\u0633\u0627" },
            { "AU", "\u0623\u0633\u062a\u0631\u0627\u0644\u064a\u0627" },
            { "AW", "\u0623\u0631\u0648\u0628\u0627" },
            { "en_US", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a\u0629" },
            { "AX", "\u062c\u0632\u0631 \u0622\u0644\u0627\u0646\u062f" },
            { "key.colNormalization", "\u0627\u0644\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0645\u0648\u062d\u062f" },
            { "AZ", "\u0623\u0630\u0631\u0628\u064a\u062c\u0627\u0646" },
            { "%%AREVELA", "\u0623\u0631\u0645\u0646\u064a\u0629 \u0634\u0631\u0642\u064a\u0629" },
            { "BA", "\u0627\u0644\u0628\u0648\u0633\u0646\u0629 \u0648\u0627\u0644\u0647\u0631\u0633\u0643" },
            { "BB", "\u0628\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "ceb", "\u0627\u0644\u0633\u064a\u0628\u0648\u0646\u064a\u0629" },
            { "BD", "\u0628\u0646\u062c\u0644\u0627\u062f\u064a\u0634" },
            { "kum", "\u0627\u0644\u0642\u0645\u0648\u0642\u064a\u0629" },
            { "BE", "\u0628\u0644\u062c\u064a\u0643\u0627" },
            { "gmh", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0639\u0644\u064a\u0627 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "BF", "\u0628\u0648\u0631\u0643\u064a\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u064a\u0627" },
            { "BH", "\u0627\u0644\u0628\u062d\u0631\u064a\u0646" },
            { "BI", "\u0628\u0648\u0631\u0648\u0646\u062f\u064a" },
            { "BJ", "\u0628\u0646\u064a\u0646" },
            { "BL", "\u0633\u0627\u0646 \u0628\u0627\u0631\u062a\u0644\u064a\u0645\u064a" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "kut", "\u0627\u0644\u0643\u062a\u064a\u0646\u0627\u064a" },
            { "myv", "\u0627\u0644\u0623\u0631\u0632\u064a\u0629" },
            { "BN", "\u0628\u0631\u0648\u0646\u0627\u064a" },
            { "BO", "\u0628\u0648\u0644\u064a\u0641\u064a\u0627" },
            { "BQ", "\u0647\u0648\u0644\u0646\u062f\u0627 \u0627\u0644\u0643\u0627\u0631\u064a\u0628\u064a\u0629" },
            { "BR", "\u0627\u0644\u0628\u0631\u0627\u0632\u064a\u0644" },
            { "BS", "\u0627\u0644\u0628\u0647\u0627\u0645\u0627" },
            { "xog", "\u0627\u0644\u0633\u0648\u063a\u0627" },
            { "BT", "\u0628\u0648\u062a\u0627\u0646" },
            { "BV", "\u062c\u0632\u064a\u0631\u0629 \u0628\u0648\u0641\u064a\u0647" },
            { "BW", "\u0628\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u064a\u0644\u0627\u0631\u0648\u0633" },
            { "BZ", "\u0628\u0644\u064a\u0632" },
            { "Visp", "\u0627\u0644\u0643\u0644\u0627\u0645 \u0627\u0644\u0645\u0631\u0626\u064a" },
            { "type.ca.persian", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0641\u0627\u0631\u0633\u064a" },
            { "type.nu.hebr", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0639\u0628\u0631\u064a\u0629" },
            { "CA", "\u0643\u0646\u062f\u0627" },
            { "CC", "\u062c\u0632\u0631 \u0643\u0648\u0643\u0648\u0633 (\u0643\u064a\u0644\u064a\u0646\u063a)" },
            { "mzn", "\u0627\u0644\u0645\u0627\u0632\u0646\u062f\u0631\u0627\u0646\u064a\u0629" },
            { "CD", "\u0627\u0644\u0643\u0648\u0646\u063a\u0648 - \u0643\u064a\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0623\u0641\u0631\u064a\u0642\u064a\u0627 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "CG", "\u0627\u0644\u0643\u0648\u0646\u063a\u0648 - \u0628\u0631\u0627\u0632\u0627\u0641\u064a\u0644" },
            { "CH", "\u0633\u0648\u064a\u0633\u0631\u0627" },
            { "CI", "\u0633\u0627\u062d\u0644 \u0627\u0644\u0639\u0627\u062c" },
            { "CK", "\u062c\u0632\u0631 \u0643\u0648\u0643" },
            { "CL", "\u062a\u0634\u064a\u0644\u064a" },
            { "CM", "\u0627\u0644\u0643\u0627\u0645\u064a\u0631\u0648\u0646" },
            { "CN", "\u0627\u0644\u0635\u064a\u0646" },
            { "CO", "\u0643\u0648\u0644\u0648\u0645\u0628\u064a\u0627" },
            { "CP", "\u062c\u0632\u064a\u0631\u0629 \u0643\u0644\u064a\u0628\u064a\u0631\u062a\u0648\u0646" },
            { "CR", "\u0643\u0648\u0633\u062a\u0627\u0631\u064a\u0643\u0627" },
            { "CU", "\u0643\u0648\u0628\u0627" },
            { "CV", "\u0627\u0644\u0631\u0623\u0633 \u0627\u0644\u0623\u062e\u0636\u0631" },
            { "CW", "\u0643\u0648\u0631\u0627\u0633\u0627\u0648" },
            { "CX", "\u062c\u0632\u064a\u0631\u0629 \u0627\u0644\u0643\u0631\u064a\u0633\u0645\u0627\u0633" },
            { "CY", "\u0642\u0628\u0631\u0635" },
            { "CZ", "\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062a\u0634\u064a\u0643" },
            { "eka", "\u0627\u0644\u0625\u0643\u0627\u062c\u0643" },
            { "DE", "\u0623\u0644\u0645\u0627\u0646\u064a\u0627" },
            { "goh", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0639\u0644\u064a\u0627 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "ace", "\u0627\u0644\u0623\u062a\u0634\u064a\u0646\u064a\u0632\u064a\u0629" },
            { "cgg", "\u062a\u0634\u064a\u063a\u0627" },
            { "DG", "\u062f\u064a\u064a\u063a\u0648 \u063a\u0627\u0631\u0633\u064a\u0627" },
            { "type.nu.deva", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062f\u064a\u0641\u0627\u0646\u063a\u0627\u0631\u064a\u0629" },
            { "DJ", "\u062c\u064a\u0628\u0648\u062a\u064a" },
            { "type.colNumeric.no", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0639\u0644\u0649 \u062d\u062f\u0629" },
            { "DK", "\u0627\u0644\u062f\u0627\u0646\u0645\u0631\u0643" },
            { "ach", "\u0627\u0644\u0623\u0643\u0648\u0644\u064a\u0629" },
            { "gon", "\u0627\u0644\u062c\u0646\u062f\u064a" },
            { "Brai", "\u0627\u0644\u0628\u0631\u0627\u064a\u0644" },
            { "Brah", "\u0627\u0644\u0647\u0646\u062f\u0648\u0633\u064a\u0629" },
            { "DM", "\u062f\u0648\u0645\u064a\u0646\u064a\u0643\u0627" },
            { "type.nu.armnlow", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0623\u0631\u0645\u064a\u0646\u064a\u0629 \u0627\u0644\u0635\u063a\u064a\u0631\u0629" },
            { "DO", "\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062f\u0648\u0645\u064a\u0646\u064a\u0643" },
            { "gor", "\u0627\u0644\u062c\u0648\u0631\u0648\u0646\u062a\u0627\u0644\u0648" },
            { "got", metaValue_got },
            { "key.variableTop", "\u062a\u0635\u0646\u064a\u0641 \u0643\u0631\u0645\u0648\u0632" },
            { "zun", "\u0627\u0644\u0632\u0648\u0646\u064a\u0629" },
            { "tig", "\u0627\u0644\u062a\u063a\u0631\u064a\u0629" },
            { "DZ", "\u0627\u0644\u062c\u0632\u0627\u0626\u0631" },
            { "pag", "\u0627\u0644\u0628\u0627\u0646\u062c\u0627\u0633\u064a\u0646\u0627\u0646" },
            { "pal", "\u0627\u0644\u0628\u0647\u0644\u0648\u064a\u0629" },
            { "EA", "\u0633\u064a\u0648\u062a\u0627 \u0648\u0645\u064a\u0644\u064a\u0644\u0627" },
            { "chb", "\u0627\u0644\u062a\u0634\u064a\u0628\u0634\u0627" },
            { "pam", "\u0627\u0644\u0628\u0627\u0645\u0628\u0627\u0646\u062c\u0627" },
            { "EC", "\u0627\u0644\u0625\u0643\u0648\u0627\u062f\u0648\u0631" },
            { "pap", "\u0627\u0644\u0628\u0627\u0628\u064a\u0627\u0645\u064a\u0646\u062a\u0648" },
            { "ada", "\u0627\u0644\u0623\u062f\u0627\u0646\u062c\u0645\u064a\u0629" },
            { "EE", "\u0625\u0633\u062a\u0648\u0646\u064a\u0627" },
            { "tiv", "\u0627\u0644\u062a\u064a\u0641" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "chg", "\u0627\u0644\u062a\u0634\u0627\u062c\u0627\u062a\u0627\u064a" },
            { "pau", "\u0627\u0644\u0628\u0627\u0644\u0648\u0627\u0646" },
            { "type.colNormalization.yes", "\u062a\u0635\u0646\u064a\u0641 Unicode \u0637\u0628\u064a\u0639\u064a" },
            { "chk", "\u0627\u0644\u062a\u0634\u0643\u064a\u0632\u064a\u0629" },
            { "chn", "\u0627\u0644\u0634\u064a\u0646\u0648\u0643 \u062c\u0627\u0631\u062c\u0648\u0646" },
            { "chm", "\u0627\u0644\u0645\u0627\u0631\u064a" },
            { "chp", "\u0627\u0644\u0634\u064a\u0628\u0627\u0648\u0627\u064a\u0627\u0646" },
            { "cho", "\u0627\u0644\u0634\u0648\u0643\u062a\u0648" },
            { "chr", metaValue_chr },
            { "ER", "\u0625\u0631\u064a\u062a\u0631\u064a\u0627" },
            { "ES", "\u0625\u0633\u0628\u0627\u0646\u064a\u0627" },
            { "ET", "\u0625\u062b\u064a\u0648\u0628\u064a\u0627" },
            { "EU", "\u0627\u0644\u0627\u062a\u062d\u0627\u062f \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a" },
            { "elx", "\u0627\u0644\u0625\u0645\u0627\u064a\u062a" },
            { "type.ca.gregorian", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0645\u064a\u0644\u0627\u062f\u064a" },
            { "chy", "\u0627\u0644\u0634\u0627\u064a\u0627\u0646" },
            { "type.nu.gujr", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u063a\u0648\u062c\u0627\u0631\u0627\u062a\u064a\u0629" },
            { "Inds", "\u0627\u0646\u062f\u0633 - \u0647\u0627\u0631\u0627\u0628\u0627\u0646" },
            { "ady", "\u0627\u0644\u0623\u062f\u064a\u063a\u0629" },
            { "FI", "\u0641\u0646\u0644\u0646\u062f\u0627" },
            { "FJ", "\u0641\u064a\u062c\u064a" },
            { "FK", "\u062c\u0632\u0631 \u0641\u0648\u0643\u0644\u0627\u0646\u062f" },
            { "FM", "\u0645\u064a\u0643\u0631\u0648\u0646\u064a\u0632\u064a\u0627" },
            { "key.va", "\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0644\u063a\u0629" },
            { "FO", "\u062c\u0632\u0631 \u0641\u0627\u0631\u0648" },
            { "Taml", metaValue_ta },
            { "FR", "\u0641\u0631\u0646\u0633\u0627" },
            { "tkl", "\u0627\u0644\u062a\u0648\u0643\u064a\u0644\u0627\u0648" },
            { "grb", "\u0627\u0644\u062c\u0631\u064a\u0628\u0648" },
            { "root", "\u0627\u0644\u062c\u0630\u0631" },
            { "type.ca.indian", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0642\u0648\u0645\u064a \u0627\u0644\u0647\u0646\u062f\u064a" },
            { "grc", "\u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "GA", "\u0627\u0644\u062c\u0627\u0628\u0648\u0646" },
            { "vot", "\u0627\u0644\u0641\u0648\u062a\u064a\u0643" },
            { "GB", "\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "GD", "\u063a\u0631\u064a\u0646\u0627\u062f\u0627" },
            { "GE", "\u062c\u0648\u0631\u062c\u064a\u0627" },
            { "GF", "\u063a\u0648\u064a\u0627\u0646\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629" },
            { "GG", "\u063a\u064a\u0631\u0646\u0632\u064a" },
            { "GH", "\u063a\u0627\u0646\u0627" },
            { "Tale", "\u0627\u0644\u062a\u0627\u064a \u0644\u064a" },
            { "GI", "\u062c\u0628\u0644 \u0637\u0627\u0631\u0642" },
            { "afh", "\u0627\u0644\u0623\u0641\u0631\u064a\u0647\u064a\u0644\u064a\u0629" },
            { "GL", "\u063a\u0631\u064a\u0646\u0644\u0627\u0646\u062f" },
            { "enm", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "GM", "\u063a\u0627\u0645\u0628\u064a\u0627" },
            { "GN", "\u063a\u064a\u0646\u064a\u0627" },
            { "GP", "\u063a\u0648\u0627\u062f\u0644\u0648\u0628" },
            { "GQ", "\u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u0625\u0633\u062a\u0648\u0627\u0626\u064a\u0629" },
            { "GR", "\u0627\u0644\u064a\u0648\u0646\u0627\u0646" },
            { "GS", "\u062c\u0648\u0631\u062c\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629 \u0648\u062c\u0632\u0631 \u0633\u0627\u0646\u062f\u0648\u064a\u062a\u0634 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "GT", "\u063a\u0648\u0627\u062a\u064a\u0645\u0627\u0644\u0627" },
            { "GU", "\u063a\u0648\u0627\u0645" },
            { "GW", "\u063a\u064a\u0646\u064a\u0627 \u0628\u064a\u0633\u0627\u0648" },
            { "tli", "\u0627\u0644\u062a\u0644\u064a\u0646\u063a\u064a\u062a\u064a\u0629" },
            { "tlh", "\u0627\u0644\u0643\u0644\u064a\u0646\u062c\u0648\u0646" },
            { "Talu", "\u0627\u0644\u062a\u0627\u0649 \u0644\u0649 \u0627\u0644\u062c\u062f\u064a\u062f" },
            { "GY", "\u063a\u064a\u0627\u0646\u0627" },
            { "ckb", "\u0627\u0644\u0633\u0648\u0631\u0627\u0646\u064a\u0629 \u0627\u0644\u0643\u0631\u062f\u064a\u0629" },
            { "zxx", "\u0628\u062f\u0648\u0646 \u0645\u062d\u062a\u0648\u0649 \u0644\u063a\u0648\u064a" },
            { "de_AT", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0646\u0645\u0633\u0627\u0648\u064a\u0629" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0647\u0648\u0646\u063a \u0643\u0648\u0646\u063a \u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "HM", "\u062c\u0632\u064a\u0631\u0629 \u0647\u064a\u0631\u062f \u0648\u062c\u0632\u0631 \u0645\u0627\u0643\u062f\u0648\u0646\u0627\u0644\u062f" },
            { "HN", "\u0647\u0646\u062f\u0648\u0631\u0627\u0633" },
            { "HR", "\u0643\u0631\u0648\u0627\u062a\u064a\u0627" },
            { "agq", "\u0627\u0644\u0623\u063a\u0645" },
            { "gsw", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0633\u0648\u064a\u0633\u0631\u064a\u0629" },
            { "type.ca.islamic-umalqura", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a (\u0623\u0645 \u0627\u0644\u0642\u0631\u0649)" },
            { "HT", "\u0647\u0627\u064a\u062a\u064a" },
            { "HU", "\u0647\u0646\u063a\u0627\u0631\u064a\u0627" },
            { "tmh", "\u0627\u0644\u062a\u0627\u0645\u0627\u0634\u064a\u0643" },
            { "IC", "\u062c\u0632\u0631 \u0627\u0644\u0643\u0646\u0627\u0631\u064a" },
            { "peo", metaValue_peo },
            { "ID", "\u0625\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0627" },
            { "IE", "\u0623\u064a\u0631\u0644\u0646\u062f\u0627" },
            { "nap", "\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0646\u0627\u0628\u0648\u0644\u064a\u0629" },
            { "naq", "\u0644\u063a\u0629 \u0627\u0644\u0646\u0627\u0645\u0627" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "IL", "\u0625\u0633\u0631\u0627\u0626\u064a\u0644" },
            { "IM", "\u062c\u0632\u064a\u0631\u0629 \u0645\u0627\u0646" },
            { "IN", "\u0627\u0644\u0647\u0646\u062f" },
            { "IO", "\u0627\u0644\u0625\u0642\u0644\u064a\u0645 \u0627\u0644\u0628\u0631\u064a\u0637\u0627\u0646\u064a \u0641\u064a \u0627\u0644\u0645\u062d\u064a\u0637 \u0627\u0644\u0647\u0646\u062f\u064a" },
            { "IQ", "\u0627\u0644\u0639\u0631\u0627\u0642" },
            { "IR", "\u0625\u064a\u0631\u0627\u0646" },
            { "IS", "\u0623\u064a\u0633\u0644\u0646\u062f\u0627" },
            { "IT", "\u0625\u064a\u0637\u0627\u0644\u064a\u0627" },
            { "type.nu.thai", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u0627\u064a\u0644\u0627\u0646\u062f\u064a\u0629" },
            { "%%POSIX", "\u062d\u0627\u0633\u0648\u0628" },
            { "type.nu.beng", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0628\u0646\u063a\u0627\u0644\u064a\u0629" },
            { "JE", "\u062c\u064a\u0631\u0633\u064a" },
            { "type.ca.islamic", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0647\u062c\u0631\u064a" },
            { "Beng", metaValue_bn },
            { "JM", "\u062c\u0627\u0645\u0627\u064a\u0643\u0627" },
            { "JO", "\u0627\u0644\u0623\u0631\u062f\u0646" },
            { "JP", "\u0627\u0644\u064a\u0627\u0628\u0627\u0646" },
            { "ain", "\u0627\u0644\u0622\u064a\u0646\u0648\u064a\u0629" },
            { "guz", "\u0627\u0644\u063a\u064a\u0632\u064a\u0629" },
            { "tog", "\u062a\u0648\u0646\u062c\u0627 - \u0646\u064a\u0627\u0633\u0627" },
            { "type.nu.knda", "\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0643\u0627\u0646\u0627\u062f\u0627" },
            { "Kali", "\u0627\u0644\u0643\u064a\u0627\u0647 \u0644\u0649" },
            { "de_CH", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0639\u0644\u064a\u0627 \u0627\u0644\u0633\u0648\u064a\u0633\u0631\u064a\u0629" },
            { "type.co.phonetic", "\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0641\u0631\u0632 \u0627\u0644\u0635\u0648\u062a\u064a" },
            { "type.ca.buddhist", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0628\u0648\u0630\u064a" },
            { "KE", "\u0643\u064a\u0646\u064a\u0627" },
            { "419", "\u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629" },
            { "KG", "\u0642\u0631\u063a\u064a\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u0643\u0645\u0628\u0648\u062f\u064a\u0627" },
            { "KI", "\u0643\u064a\u0631\u064a\u0628\u0627\u062a\u064a" },
            { "KM", "\u062c\u0632\u0631 \u0627\u0644\u0642\u0645\u0631" },
            { "Knda", metaValue_kn },
            { "KN", "\u0633\u0627\u0646\u062a \u0643\u064a\u062a\u0633 \u0648\u0646\u064a\u0641\u064a\u0633" },
            { "Zinh", "\u0627\u0644\u0645\u0648\u0631\u0648\u062b" },
            { "fr_CA", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0643\u0646\u062f\u064a\u0629" },
            { "KP", "\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "KR", "\u0643\u0648\u0631\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "Plrd", "\u0627\u0644\u0635\u0648\u062a\u064a\u0627\u062a \u0627\u0644\u062c\u0645\u0627\u0621" },
            { "fr_CH", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0633\u0648\u064a\u0633\u0631\u064a\u0629" },
            { "KW", "\u0627\u0644\u0643\u0648\u064a\u062a" },
            { "tpi", "\u0627\u0644\u062a\u0648\u0643 \u0628\u064a\u0633\u064a\u0646" },
            { "KY", "\u062c\u0632\u0631 \u0627\u0644\u0643\u0627\u064a\u0645\u0646" },
            { "KZ", "\u0643\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0627\u0644\u0633\u064a\u0631\u064a\u0644\u064a\u0629" },
            { "LA", "\u0644\u0627\u0648\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "phn", metaValue_phn },
            { "LC", "\u0633\u0627\u0646\u062a \u0644\u0648\u0633\u064a\u0627" },
            { "Cyrs", "\u0627\u0644\u0633\u064a\u0631\u064a\u0644\u064a\u0629 \u0627\u0644\u0633\u0644\u0627\u0641\u064a\u0629 \u0627\u0644\u0643\u0646\u0633\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "gwi", "\u063a\u0648\u062a\u0634\u0646" },
            { "nds", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0633\u0641\u0644\u0649" },
            { "LI", "\u0644\u064a\u062e\u062a\u0646\u0634\u062a\u0627\u064a\u0646" },
            { "LK", "\u0633\u0631\u064a\u0644\u0627\u0646\u0643\u0627" },
            { "akk", "\u0627\u0644\u0623\u0643\u0627\u062f\u064a\u0629" },
            { "cop", metaValue_cop },
            { "LR", "\u0644\u064a\u0628\u064a\u0631\u064a\u0627" },
            { "LS", "\u0644\u064a\u0633\u0648\u062a\u0648" },
            { "LT", "\u0644\u064a\u062a\u0648\u0627\u0646\u064a\u0627" },
            { "LU", "\u0644\u0648\u0643\u0633\u0645\u0628\u0648\u0631\u063a" },
            { "LV", "\u0644\u0627\u062a\u0641\u064a\u0627" },
            { "Kana", "\u0627\u0644\u0643\u062a\u0643\u0627\u0646\u0627" },
            { "LY", "\u0644\u064a\u0628\u064a\u0627" },
            { "lad", "\u0627\u0644\u0644\u0627\u062f\u064a\u0646\u0648" },
            { "vun", "\u0627\u0644\u0641\u0648\u0646\u062c\u0648" },
            { "lah", "\u0627\u0644\u0644\u0627\u0647\u0646\u062f\u0627" },
            { "lag", "\u0644\u0627\u0646\u062c\u064a" },
            { "Thaa", "\u0627\u0644\u062b\u0639\u0646\u0629" },
            { "MA", "\u0627\u0644\u0645\u063a\u0631\u0628" },
            { "MC", "\u0645\u0648\u0646\u0627\u0643\u0648" },
            { "MD", "\u0645\u0648\u0644\u062f\u0627\u0641\u064a\u0627" },
            { "ME", "\u0627\u0644\u062c\u0628\u0644 \u0627\u0644\u0623\u0633\u0648\u062f" },
            { "MF", "\u0633\u0627\u0646\u062a \u0645\u0627\u0631\u062a\u0646" },
            { "lam", "\u0627\u0644\u0644\u0627\u0645\u0628\u0627" },
            { "MG", "\u0645\u062f\u063a\u0634\u0642\u0631" },
            { "Thai", metaValue_th },
            { "MH", "\u062c\u0632\u0631 \u0627\u0644\u0645\u0627\u0631\u0634\u0627\u0644" },
            { "ale", "\u0627\u0644\u0623\u0644\u064a\u0648\u062a\u064a\u0629" },
            { "type.nu.vaii", "\u0623\u0631\u0642\u0627\u0645 \u0641\u0627\u064a" },
            { "MK", "\u0645\u0642\u062f\u0648\u0646\u064a\u0627" },
            { "ML", "\u0645\u0627\u0644\u064a" },
            { "MM", "\u0645\u064a\u0627\u0646\u0645\u0627\u0631 -\u0628\u0648\u0631\u0645\u0627" },
            { "MN", "\u0645\u0646\u063a\u0648\u0644\u064a\u0627" },
            { "new", "\u0627\u0644\u0646\u0648\u0627\u0631\u064a\u0629" },
            { "MO", "\u0645\u0643\u0627\u0648 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 (\u0645\u0646\u0637\u0642\u0629 \u0625\u062f\u0627\u0631\u064a\u0629 \u062e\u0627\u0635\u0629)" },
            { "MP", "\u062c\u0632\u0631 \u0645\u0627\u0631\u064a\u0627\u0646\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "MQ", "\u0645\u0627\u0631\u062a\u064a\u0646\u064a\u0643" },
            { "MR", "\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627" },
            { "MS", "\u0645\u0648\u0646\u062a\u0633\u0631\u0627\u062a" },
            { "type.colAlternate.non-ignorable", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0631\u0645\u0648\u0632" },
            { "MT", "\u0645\u0627\u0644\u0637\u0627" },
            { "MU", "\u0645\u0648\u0631\u064a\u0634\u064a\u0648\u0633" },
            { "alt", "\u0627\u0644\u0623\u0644\u0637\u0627\u0626\u064a\u0629 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "MV", "\u062c\u0632\u0631 \u0627\u0644\u0645\u0627\u0644\u062f\u064a\u0641" },
            { "MW", "\u0645\u0644\u0627\u0648\u064a" },
            { "MX", "\u0627\u0644\u0645\u0643\u0633\u064a\u0643" },
            { "type.ca.japanese", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a" },
            { "MY", "\u0645\u0627\u0644\u064a\u0632\u064a\u0627" },
            { "MZ", "\u0645\u0648\u0632\u0645\u0628\u064a\u0642" },
            { "NA", "\u0646\u0627\u0645\u064a\u0628\u064a\u0627" },
            { "type.ca.hebrew", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0639\u0628\u0631\u064a" },
            { "type.co.dictionary", "\u062a\u0631\u062a\u064a\u0628 \u0641\u0631\u0632 \u0627\u0644\u0642\u0627\u0645\u0648\u0633" },
            { "NC", "\u0643\u0627\u0644\u064a\u062f\u0648\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629" },
            { "%%WADEGILE", "\u0627\u0644\u0645\u0646\u062f\u0631\u064a\u0646 \u0628\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629 - \u0648\u064a\u062f\u2013\u062c\u064a\u0644\u0632" },
            { "%%UCRCOR", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0645\u0631\u0627\u062c\u0639\u0629 \u0627\u0644\u0645\u0648\u062d\u062f\u0629" },
            { "NE", "\u0627\u0644\u0646\u064a\u062c\u0631" },
            { "NF", "\u062c\u0632\u064a\u0631\u0629 \u0646\u0648\u0631\u0641\u0648\u0643" },
            { "NG", "\u0646\u064a\u062c\u064a\u0631\u064a\u0627" },
            { "trv", "\u0644\u063a\u0629 \u0627\u0644\u062a\u0627\u0631\u0648\u0643\u0648" },
            { "NI", "\u0646\u064a\u0643\u0627\u0631\u0627\u063a\u0648\u0627" },
            { "Hmng", "\u0627\u0644\u0628\u0627\u0647\u0648\u0647 \u0647\u0645\u0648\u0646\u062c" },
            { "NL", "\u0647\u0648\u0644\u0646\u062f\u0627" },
            { "NO", "\u0627\u0644\u0646\u0631\u0648\u064a\u062c" },
            { "NP", "\u0646\u064a\u0628\u0627\u0644" },
            { "NR", "\u0646\u0627\u0648\u0631\u0648" },
            { "Phnx", metaValue_phn },
            { "NU", "\u0646\u064a\u0648\u064a" },
            { "rof", "\u0627\u0644\u0631\u0648\u0645\u0628\u0648" },
            { "tsi", "\u0627\u0644\u062a\u0633\u064a\u0645\u0634\u064a\u0627\u0646" },
            { "NZ", "\u0646\u064a\u0648\u0632\u064a\u0644\u0646\u062f\u0627" },
            { "rom", "\u063a\u062c\u0631\u064a" },
            { "Mero", "\u0627\u0644\u0645\u064a\u0631\u0648\u064a\u062a\u064a\u0643" },
            { "crh", "\u0644\u063a\u0629 \u062a\u062a\u0627\u0631 \u0627\u0644\u0642\u0631\u0645" },
            { "type.colAlternate.shifted", "\u062a\u0635\u0646\u064a\u0641 \u062a\u062c\u0627\u0647\u0644 \u0627\u0644\u0631\u0645\u0648\u0632" },
            { "ang", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "OM", "\u0639\u064f\u0645\u0627\u0646" },
            { "anp", "\u0627\u0644\u0623\u0646\u062c\u064a\u0643\u0627" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u0628\u0646\u0645\u0627" },
            { "type.ca.islamic-civil", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a \u0627\u0644\u0645\u062f\u0646\u064a" },
            { "csb", "\u0627\u0644\u0643\u0627\u0634\u0628\u0627\u064a\u0627\u0646" },
            { "en_GB", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0628\u0631\u064a\u0637\u0627\u0646\u064a\u0629" },
            { "PE", "\u0628\u064a\u0631\u0648" },
            { "PF", "\u0628\u0648\u0644\u064a\u0646\u064a\u0632\u064a\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629" },
            { "PG", "\u0628\u0627\u0628\u0648\u0627 \u063a\u064a\u0646\u064a\u0627 \u0627\u0644\u062c\u062f\u064a\u062f\u0629" },
            { "PH", "\u0627\u0644\u0641\u0644\u0628\u064a\u0646" },
            { "PK", "\u0628\u0627\u0643\u0633\u062a\u0627\u0646" },
            { "PL", "\u0628\u0648\u0644\u0646\u062f\u0627" },
            { "ewo", "\u0627\u0644\u0625\u064a\u0648\u0646\u062f\u0648" },
            { "PM", "\u0633\u0627\u0646\u062a \u0628\u064a\u064a\u0631 \u0648\u0645\u064a\u0643\u0648\u0644\u0648\u0646" },
            { "PN", "\u062c\u0632\u0631 \u0628\u064a\u062a\u0643\u064a\u0631\u0646" },
            { "type.colBackwards.yes", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0644\u0643\u0646\u0627\u062a \u0645\u0639\u0643\u0648\u0633\u0629" },
            { "PR", "\u0628\u0648\u0631\u062a\u0648\u0631\u064a\u0643\u0648" },
            { "Bali", metaValue_pi },
            { "PS", "\u0627\u0644\u0623\u0631\u0627\u0636\u064a \u0627\u0644\u0641\u0644\u0633\u0637\u064a\u0646\u064a\u0629" },
            { "PT", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644" },
            { "PW", "\u0628\u0627\u0644\u0627\u0648" },
            { "nia", "\u0627\u0644\u0646\u064a\u0627\u0633" },
            { "type.nu.greklow", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629 \u0627\u0644\u0635\u063a\u064a\u0631\u0629" },
            { "PY", "\u0628\u0627\u0631\u0627\u063a\u0648\u0627\u064a" },
            { "tum", "\u0627\u0644\u062a\u0627\u0645\u0628\u0648\u0643\u0627" },
            { "Hebr", metaValue_he },
            { "QA", "\u0642\u0637\u0631" },
            { "%%SCOTLAND", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0623\u0633\u0643\u062a\u0644\u0646\u062f\u0646\u064a\u0629 \u0627\u0644\u0631\u0633\u0645\u064a\u0629" },
            { "niu", "\u0627\u0644\u0646\u064a\u0648\u064a" },
            { "QO", "\u0623\u0648\u0642\u064a\u0627\u0646\u0648\u0633\u064a\u0627 \u0627\u0644\u0646\u0627\u0626\u064a\u0629" },
            { "lez", "\u0627\u0644\u0644\u064a\u0632\u062c\u064a\u0629" },
            { "tvl", "\u0627\u0644\u062a\u0648\u0641\u0627\u0644\u0648" },
            { "001", "\u0627\u0644\u0639\u0627\u0644\u0645" },
            { "002", "\u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "003", "\u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "RE", "\u0631\u0648\u064a\u0646\u064a\u0648\u0646" },
            { "type.colNormalization.no", "\u0627\u0644\u062a\u0635\u0641\u064a\u0629 \u0628\u062f\u0648\u0646 \u062a\u0633\u0648\u064a\u0629" },
            { "005", "\u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "jbo", "\u0627\u0644\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "009", "\u0623\u0648\u0642\u064a\u0627\u0646\u0648\u0633\u064a\u0627" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u064a\u0627" },
            { "RS", "\u0635\u0631\u0628\u064a\u0627" },
            { "RU", "\u0631\u0648\u0633\u064a\u0627" },
            { "RW", "\u0631\u0648\u0627\u0646\u062f\u0627" },
            { "Ugar", "\u0627\u0644\u0623\u062c\u0627\u0631\u064a\u062a\u064a\u0643\u064a\u0629" },
            { "key.colAlternate", "\u0627\u0644\u062a\u0635\u0646\u064a\u0641 \u0628\u062d\u0633\u0628 \u062a\u062c\u0627\u0647\u0644 \u0627\u0644\u0631\u0645\u0648\u0632" },
            { "Khar", "\u0627\u0644\u062e\u0627\u0631\u0648\u0634\u062a\u0649" },
            { "SA", "\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629" },
            { "pon", "\u0627\u0644\u0628\u0648\u0647\u0646\u0628\u064a\u0627\u064a\u0627\u0646" },
            { "Mand", "\u0627\u0644\u0645\u0627\u0646\u062f\u0627\u064a\u0646\u064a\u0629" },
            { "SB", "\u062c\u0632\u0631 \u0633\u0644\u064a\u0645\u0627\u0646" },
            { "twq", "\u062a\u0627\u0633\u0627\u0648\u0627\u0642" },
            { "011", "\u063a\u0631\u0628 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "SC", "\u0633\u064a\u0634\u0644" },
            { "SD", "\u0627\u0644\u0633\u0648\u062f\u0627\u0646" },
            { "013", "\u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "SE", "\u0627\u0644\u0633\u0648\u064a\u062f" },
            { "014", "\u0634\u0631\u0642 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "arc", "\u0627\u0644\u0622\u0631\u0627\u0645\u064a\u0629" },
            { "015", "\u0634\u0645\u0627\u0644 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "SG", "\u0633\u0646\u063a\u0627\u0641\u0648\u0631\u0629" },
            { "SH", "\u0633\u0627\u0646\u062a \u0647\u064a\u0644\u0646\u0627" },
            { "type.lb.strict", "\u0646\u0645\u0637 \u0641\u0635\u0644 \u0627\u0644\u0633\u0637\u0648\u0631: \u0645\u062a\u0642\u0627\u0631\u0628" },
            { "017", "\u0648\u0633\u0637 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "SI", "\u0633\u0644\u0648\u0641\u064a\u0646\u064a\u0627" },
            { "018", "\u0623\u0641\u0631\u064a\u0642\u064a\u0627 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "SJ", "\u0633\u0641\u0627\u0644\u0628\u0627\u0631\u062f \u0648\u062c\u0627\u0646 \u0645\u0627\u064a\u0627\u0646" },
            { "019", "\u0627\u0644\u0623\u0645\u0631\u064a\u0643\u062a\u0627\u0646" },
            { "SK", "\u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0627" },
            { "SL", "\u0633\u064a\u0631\u0627\u0644\u064a\u0648\u0646" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u064a\u0646\u0648" },
            { "SN", "\u0627\u0644\u0633\u0646\u063a\u0627\u0644" },
            { "SO", "\u0627\u0644\u0635\u0648\u0645\u0627\u0644" },
            { "arn", "\u0627\u0644\u0623\u0631\u0648\u0643\u0627\u0646\u064a\u0629" },
            { "arp", "\u0627\u0644\u0623\u0631\u0627\u0628\u0627\u0647\u0648" },
            { "type.nu.taml", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u0627\u0645\u064a\u0644\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "SR", "\u0633\u0648\u0631\u064a\u0646\u0627\u0645" },
            { "SS", "\u062c\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062f\u0627\u0646" },
            { "ST", "\u0633\u0627\u0648 \u062a\u0648\u0645\u064a \u0648\u0628\u0631\u064a\u0646\u0633\u064a\u0628\u064a" },
            { "SV", "\u0627\u0644\u0633\u0644\u0641\u0627\u062f\u0648\u0631" },
            { "SX", "\u0633\u064a\u0646\u062a \u0645\u0627\u0631\u062a\u0646" },
            { "SY", "\u0633\u0648\u0631\u064a\u0627" },
            { "yao", "\u0627\u0644\u064a\u0627\u0648" },
            { "SZ", "\u0633\u0648\u0627\u0632\u064a\u0644\u0627\u0646\u062f" },
            { "arw", "\u0627\u0644\u0623\u0631\u0627\u0648\u0627\u0643\u064a\u0629" },
            { "yap", "\u0627\u0644\u064a\u0627\u0628\u064a\u0632" },
            { "TA", "\u062a\u0631\u064a\u0633\u062a\u0627\u0646 \u062f\u064a \u0643\u0648\u0646\u0647\u0627" },
            { "asa", "\u0627\u0644\u0622\u0633\u0648" },
            { "type.ms.ussystem", "\u0646\u0638\u0627\u0645 \u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "021", "\u0634\u0645\u0627\u0644 \u0623\u0645\u0631\u064a\u0643\u0627" },
            { "TC", "\u062c\u0632\u0631 \u062a\u0648\u0631\u0643\u0633 \u0648\u0643\u0627\u064a\u0643\u0648\u0633" },
            { "yav", "\u064a\u0627\u0646\u062c\u0628\u0646" },
            { "TD", "\u062a\u0634\u0627\u062f" },
            { "TF", "\u0627\u0644\u0623\u0642\u0627\u0644\u064a\u0645 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629 \u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629" },
            { "TG", "\u062a\u0648\u063a\u0648" },
            { "TH", "\u062a\u0627\u064a\u0644\u0627\u0646\u062f" },
            { "TJ", "\u0637\u0627\u062c\u064a\u0643\u0633\u062a\u0627\u0646" },
            { "029", "\u0627\u0644\u0643\u0627\u0631\u064a\u0628\u064a" },
            { "TK", "\u062a\u0648\u0643\u064a\u0644\u0648" },
            { "TL", "\u062a\u064a\u0645\u0648\u0631 \u0627\u0644\u0634\u0631\u0642\u064a\u0629" },
            { "ybb", "\u064a\u0645\u0628\u0627" },
            { "type.co.searchjl", "\u0628\u062d\u062b \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u062d\u0631\u0641 \u0627\u0644\u0647\u0627\u0646\u063a\u0648\u0644 \u0627\u0644\u0633\u0627\u0643\u0646 \u0627\u0644\u0623\u0648\u0644" },
            { "TM", "\u062a\u0631\u0643\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "TO", "\u062a\u0648\u0646\u063a\u0627" },
            { "TR", "\u062a\u0631\u0643\u064a\u0627" },
            { "TT", "\u062a\u0631\u064a\u0646\u064a\u062f\u0627\u062f \u0648\u062a\u0648\u0628\u0627\u063a\u0648" },
            { "TV", "\u062a\u0648\u0641\u0627\u0644\u0648" },
            { "TW", "\u062a\u0627\u064a\u0648\u0627\u0646" },
            { "ast", "\u0627\u0644\u0623\u0633\u062a\u0631\u064a\u0629" },
            { "Orkh", "\u0627\u0644\u0623\u0648\u0631\u062e\u0648\u0646" },
            { "TZ", "\u062a\u0646\u0632\u0627\u0646\u064a\u0627" },
            { "nmg", "\u0643\u0648\u0627\u0633\u064a\u0648" },
            { "Zzzz", "\u0646\u0638\u0627\u0645 \u0643\u062a\u0627\u0628\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641" },
            { "UA", "\u0623\u0648\u0643\u0631\u0627\u0646\u064a\u0627" },
            { "rup", "\u0627\u0644\u0623\u0631\u0648\u0645\u0627\u0646\u064a\u0627\u0646" },
            { "030", "\u0634\u0631\u0642 \u0622\u0633\u064a\u0627" },
            { "tyv", "\u0627\u0644\u062a\u0648\u0641\u064a\u0629" },
            { "sw_CD", "\u0627\u0644\u0643\u0648\u0646\u063a\u0648 \u0627\u0644\u0633\u0648\u0627\u062d\u0644\u064a\u0629" },
            { "034", "\u062c\u0646\u0648\u0628 \u0622\u0633\u064a\u0627" },
            { "hai", "\u0627\u0644\u0647\u064a\u062f\u0627" },
            { "035", "\u062c\u0646\u0648\u0628 \u0634\u0631\u0642 \u0622\u0633\u064a\u0627" },
            { "UG", "\u0623\u0648\u063a\u0646\u062f\u0627" },
            { "type.co.pinyin", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0635\u064a\u0646\u064a \u0628\u0646\u064a\u064a\u0646 \u0627\u0644\u0645\u0628\u0633\u0637" },
            { "type.colHiraganaQuaternary.yes", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0643\u0627\u0646\u0627 \u0628\u0634\u0643\u0644 \u0645\u062e\u062a\u0644\u0641" },
            { "039", "\u062c\u0646\u0648\u0628 \u0623\u0648\u0631\u0648\u0628\u0627" },
            { "Sinh", "\u0627\u0644\u0633\u064a\u0646\u0647\u0627\u0644\u0627" },
            { "UM", "\u062c\u0632\u0631 \u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629 \u0627\u0644\u0646\u0627\u0626\u064a\u0629" },
            { "US", "\u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "haw", "\u0644\u063a\u0629 \u0623\u0647\u0644 \u0627\u0644\u0647\u0627\u0648\u0627\u064a" },
            { "%%1959ACAD", "\u0623\u0643\u0627\u062f\u064a\u0645\u064a" },
            { "type.co.gb2312han", "\u062a\u0631\u062a\u064a\u0628 \u0641\u0631\u0632 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0628\u0633\u0637\u0629 (GB2312)" },
            { "UY", "\u0623\u0648\u0631\u063a\u0648\u0627\u064a" },
            { "UZ", "\u0623\u0648\u0632\u0628\u0643\u0633\u062a\u0627\u0646" },
            { "tzm", "\u0627\u0644\u0623\u0645\u0627\u0632\u064a\u063a\u064a\u0629 \u0648\u0633\u0637 \u0627\u0644\u0623\u0637\u0644\u0633" },
            { "type.co.stroke", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0635\u064a\u0646\u064a \u0628\u0646\u064a\u064a\u0646 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a" },
            { "nnh", "\u0644\u063a\u0629 \u0627\u0644\u0646\u062c\u064a\u0645\u0628\u0648\u0646" },
            { "VA", "\u0627\u0644\u0641\u0627\u062a\u064a\u0643\u0627\u0646" },
            { "pro", "\u0627\u0644\u0628\u0631\u0648\u0641\u0627\u0646\u0633\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "VC", "\u0633\u0627\u0646\u062a \u0641\u0646\u0633\u0646\u062a \u0648\u063a\u0631\u0646\u0627\u062f\u064a\u0646" },
            { "VE", "\u0641\u0646\u0632\u0648\u064a\u0644\u0627" },
            { "VG", "\u062c\u0632\u0631 \u0641\u0631\u062c\u064a\u0646 \u0627\u0644\u0628\u0631\u064a\u0637\u0627\u0646\u064a\u0629" },
            { "VI", "\u062c\u0632\u0631 \u0641\u0631\u062c\u064a\u0646 \u0627\u0644\u0623\u0645\u0631\u064a\u0643\u064a\u0629" },
            { "VN", "\u0641\u064a\u062a\u0646\u0627\u0645" },
            { "type.colBackwards.no", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0644\u0643\u0646\u0627\u062a \u0628\u0634\u0643\u0644 \u0639\u0627\u062f\u064a" },
            { "VU", "\u0641\u0627\u0646\u0648\u0627\u062a\u0648" },
            { "nog", "\u0627\u0644\u0646\u0648\u062c\u0627\u064a" },
            { "rwk", "\u0627\u0644\u0631\u0648\u0627" },
            { "non", "\u0627\u0644\u0646\u0648\u0631\u0633 \u0627\u0644\u0642\u062f\u064a\u0645" },
            { "053", "\u0623\u0633\u062a\u0631\u0627\u0644\u0627\u0633\u064a\u0627" },
            { "%%AREVMDA", "\u0623\u0631\u0645\u0646\u064a\u0629 \u063a\u0631\u0628\u064a\u0629" },
            { "054", "\u0645\u064a\u0644\u0627\u0646\u064a\u0632\u064a\u0627" },
            { "WF", "\u062c\u0632\u0631 \u0648\u0627\u0644\u0633 \u0648\u0641\u0648\u062a\u0648\u0646\u0627" },
            { "type.co.traditional", "\u062a\u0631\u062a\u064a\u0628 \u062a\u0642\u0644\u064a\u062f\u064a" },
            { "057", "\u0627\u0644\u062c\u0632\u0631 \u0627\u0644\u0645\u064a\u0643\u0631\u0648\u0646\u064a\u0632\u064a\u0629" },
            { "jgo", "\u0646\u063a\u0648\u0645\u0628\u0627" },
            { "lkt", "\u0644\u0627\u0643\u0648\u062a\u0627" },
            { "type.nu.finance", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0627\u0644\u064a\u0629" },
            { "wae", "\u0627\u0644\u0648\u0627\u0644\u0633\u0631" },
            { "WS", "\u0633\u0627\u0645\u0648\u0627" },
            { "wal", "\u0627\u0644\u0648\u0644\u0627\u064a\u0627\u062a\u0627" },
            { "was", "\u0627\u0644\u0648\u0627\u0634\u0648" },
            { "war", "\u0627\u0644\u0648\u0627\u0631\u0627\u064a" },
            { "awa", "\u0627\u0644\u0623\u0648\u0627\u062f\u064a\u0629" },
            { "061", "\u0628\u0648\u0644\u064a\u0646\u064a\u0632\u064a\u0627" },
            { "XK", "\u0643\u0648\u0633\u0648\u0641\u0648" },
            { "Gujr", "\u0627\u0644\u062a\u0627\u063a\u062c\u0631\u0627\u062a\u064a\u0629" },
            { "Zxxx", "\u063a\u064a\u0631 \u0645\u0643\u062a\u0648\u0628" },
            { "wbp", "\u0648\u0627\u0631\u0644\u0628\u064a\u0631\u064a" },
            { "Batk", "\u0627\u0644\u0628\u0627\u062a\u0627\u0643" },
            { "Blis", "\u0631\u0645\u0648\u0632 \u0628\u0644\u064a\u0633" },
            { "YE", "\u0627\u0644\u064a\u0645\u0646" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0641\u0631\u0632 \u0627\u0644\u0642\u064a\u0627\u0633\u064a" },
            { "fan", "\u0627\u0644\u0641\u0627\u0646\u062c" },
            { "fat", "\u0627\u0644\u0641\u0627\u0646\u062a\u064a" },
            { "YT", "\u0645\u0627\u064a\u0648\u062a" },
            { "ZA", "\u062c\u0646\u0648\u0628 \u0623\u0641\u0631\u064a\u0642\u064a\u0627" },
            { "type.lb.loose", "\u0646\u0645\u0637 \u0641\u0635\u0644 \u0627\u0644\u0633\u0637\u0648\u0631: \u0645\u062a\u0628\u0627\u0639\u062f" },
            { "Deva", "\u0627\u0644\u062f\u064a\u0641\u0627\u0646\u0627\u062c\u0627\u0631\u064a" },
            { "type.nu.geor", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062c\u0648\u0631\u062c\u064a\u0629" },
            { "Hira", "\u0627\u0644\u0647\u064a\u0631\u0627\u062c\u0627\u0646\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u064a\u0627" },
            { "%%PINYIN", "\u0628\u064a\u0646\u064a\u064a\u0646 \u0628\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629" },
            { "ZW", "\u0632\u064a\u0645\u0628\u0627\u0628\u0648\u064a" },
            { "ZZ", "\u0645\u0646\u0637\u0642\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641\u0629" },
            { "Runr", "\u0627\u0644\u0631\u0648\u0646\u064a" },
            { "type.ms.metric", "\u0646\u0638\u0627\u0645 \u0645\u062a\u0631\u064a" },
            { "type.ca.iso8601", "\u062a\u0642\u0648\u064a\u0645 ISO-8601" },
            { "lol", "\u0645\u0646\u063a\u0648\u0644\u0649" },
            { "nso", "\u0627\u0644\u0633\u0648\u062a\u0648 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "type.nu.telu", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u064a\u0644\u0648\u063a\u0648\u064a\u0629" },
            { "loz", "\u0627\u0644\u0644\u0648\u0632\u064a" },
            { "type.colHiraganaQuaternary.no", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0643\u0627\u0646\u0627 \u0628\u0634\u0643\u0644 \u0645\u0646\u0641\u0635\u0644" },
            { "jmc", "\u0627\u0644\u0645\u0627\u062a\u0634\u0627\u0645\u064a\u0629" },
            { "type.nu.hansfin", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0628\u0633\u0637\u0629" },
            { "type.colStrength.secondary", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0644\u0643\u0646\u0627\u062a" },
            { "hil", "\u0627\u0644\u0647\u064a\u0644\u064a\u062c\u064a\u0646\u0648\u0646" },
            { "type.nu.arabext", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0647\u0646\u062f\u064a\u0629 \u0627\u0644\u0645\u0645\u062a\u062f\u0629" },
            { "nus", "\u0627\u0644\u0646\u0648\u064a\u0631" },
            { "dak", "\u0627\u0644\u062f\u0627\u0643\u0648\u062a\u0627" },
            { "type.nu.fullwide", "\u0623\u0631\u0642\u0627\u0645 \u0643\u0627\u0645\u0644\u0629 \u0627\u0644\u0639\u0631\u0636" },
            { "hit", "\u0627\u0644\u062d\u062b\u064a\u0629" },
            { "dar", "\u0627\u0644\u062f\u0627\u0631\u062c\u0648\u0627" },
            { "dav", "\u062a\u064a\u062a\u0627" },
            { "Maya", "\u0627\u0644\u0645\u0627\u064a\u0627 \u0627\u0644\u0647\u064a\u0631\u0648\u063a\u0644\u064a\u0641\u064a\u0629" },
            { "lrc", "\u0627\u0644\u0644\u0631\u064a\u0629 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "Copt", metaValue_cop },
            { "nwc", "\u0627\u0644\u0646\u0648\u0627\u0631\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "udm", "\u0627\u0644\u0623\u062f\u0645\u0631\u062a" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a (\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629)" },
            { "Limb", "\u0627\u0644\u0644\u064a\u0645\u0628\u0648" },
            { "sad", "\u0627\u0644\u0633\u0627\u0646\u062f\u0627\u0648\u064a" },
            { "type.nu.roman", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0631\u0648\u0645\u0627\u0646\u064a\u0629" },
            { "sah", "\u0627\u0644\u0633\u0627\u062e\u064a\u0629" },
            { "sam", "\u0627\u0644\u0622\u0631\u0627\u0645\u064a\u0629 \u0627\u0644\u0633\u0627\u0645\u0631\u064a\u0629" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0631\u0648" },
            { "sas", "\u0627\u0644\u0633\u0627\u0633\u0627\u0643" },
            { "sat", "\u0627\u0644\u0633\u0627\u0646\u062a\u0627\u0644\u064a" },
            { "Tfng", "\u0627\u0644\u062a\u064a\u0641\u064a\u0646\u0627\u063a" },
            { "jpr", "\u0627\u0644\u0641\u0627\u0631\u0633\u064a\u0629 \u0627\u0644\u064a\u0647\u0648\u062f\u064a\u0629" },
            { "type.nu.native", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0623\u0635\u0644\u064a\u0629" },
            { "sba", "\u0646\u0627\u0645\u0628\u064a" },
            { "Guru", "\u0627\u0644\u062c\u0631\u0645\u062e\u064a" },
            { "lua", "\u0627\u0644\u0644\u0628\u0627-\u0644\u0624\u0644\u0624" },
            { "sbp", "\u0633\u0627\u0646\u063a\u0648" },
            { "lui", "\u0627\u0644\u0644\u0648\u0633\u064a\u0646\u0648" },
            { "nyn", "\u0627\u0644\u0646\u064a\u0627\u0646\u0643\u0648\u0644" },
            { "nym", "\u0627\u0644\u0646\u064a\u0627\u0645\u0648\u064a\u0632\u064a" },
            { "lun", "\u0627\u0644\u0644\u0648\u0646\u062f\u0627" },
            { "nyo", "\u0627\u0644\u0646\u064a\u0648\u0631\u0648" },
            { "luo", "\u0627\u0644\u0644\u0648" },
            { "fil", "\u0627\u0644\u0641\u0644\u0628\u064a\u0646\u064a\u0629" },
            { "hmn", "\u0627\u0644\u0647\u0645\u0648\u0646\u062c\u064a\u0629" },
            { "del", "\u0627\u0644\u062f\u064a\u0644\u0648\u064a\u0631" },
            { "lus", "\u0627\u0644\u0645\u064a\u0632\u0648" },
            { "bal", "\u0627\u0644\u0628\u0644\u0648\u0634\u064a\u0629" },
            { "den", "\u0627\u0644\u0633\u0644\u0627\u0641\u064a\u0629" },
            { "ban", "\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0628\u0627\u0644\u064a\u0629" },
            { "uga", "\u0627\u0644\u064a\u062c\u0627\u0631\u064a\u062a\u064a\u0643" },
            { "luy", "\u0644\u063a\u0629 \u0627\u0644\u0644\u0648\u064a\u0627" },
            { "bas", "\u0627\u0644\u0628\u0627\u0633\u0627" },
            { "bax", "\u0628\u0627\u0645\u0646" },
            { "jrb", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u064a\u0647\u0648\u062f\u064a\u0629" },
            { "es_ES", "\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629 \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "nzi", "\u0627\u0644\u0646\u0632\u064a\u0645\u0627" },
            { "sco", "\u0627\u0644\u0623\u0633\u0643\u062a\u0644\u0646\u062f\u064a\u0629" },
            { "scn", "\u0627\u0644\u0635\u0642\u0644\u064a\u0629" },
            { "aa", "\u0627\u0644\u0623\u0641\u0627\u0631\u064a\u0629" },
            { "ab", "\u0627\u0644\u0623\u0628\u062e\u0627\u0632\u064a\u0629" },
            { "key.colCaseFirst", "\u0627\u0644\u062a\u0631\u062a\u064a\u0628 \u0628\u062d\u0633\u0628 \u0627\u0644\u0623\u062d\u0631\u0641 \u0627\u0644\u0643\u0628\u064a\u0631\u0629/\u0627\u0644\u0635\u063a\u064a\u0631\u0629" },
            { "ae", "\u0627\u0644\u0623\u0641\u0633\u062a\u064a\u0629" },
            { "af", "\u0627\u0644\u0623\u0641\u0631\u064a\u0642\u0627\u0646\u064a\u0629" },
            { "ak", "\u0627\u0644\u0623\u0643\u0627\u0646\u064a\u0629" },
            { "bbj", "\u0644\u063a\u0629 \u0627\u0644\u063a\u0648\u0645\u0627\u0644\u0627" },
            { "am", "\u0627\u0644\u0623\u0645\u0647\u0631\u064a\u0629" },
            { "Arab", metaValue_ar },
            { "an", "\u0627\u0644\u0623\u0631\u0627\u063a\u0648\u0646\u064a\u0629" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0627\u0644\u0643\u062a\u0643\u0627\u0646\u0627 \u0623\u0648 \u0627\u0644\u0647\u064a\u0631\u0627\u062c\u0627\u0646\u0627" },
            { "as", "\u0627\u0644\u0623\u0633\u0627\u0645\u064a\u0629" },
            { "Lina", "\u0627\u0644\u062e\u0637\u064a\u0629 \u0623" },
            { "av", "\u0627\u0644\u0623\u0648\u0627\u0631\u064a\u0629" },
            { "Linb", "\u0627\u0644\u062e\u0637\u064a\u0629 \u0628" },
            { "sdh", "\u0627\u0644\u0643\u0631\u062f\u064a\u0629 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "ay", "\u0627\u0644\u0623\u064a\u0645\u0627\u0631\u0627" },
            { "az", "\u0627\u0644\u0623\u0630\u0631\u0628\u064a\u062c\u0627\u0646\u064a\u0629" },
            { "ba", "\u0627\u0644\u0628\u0627\u0634\u0643\u064a\u0631\u064a\u0629" },
            { "type.co.unihan", "\u062a\u0631\u062a\u064a\u0628 \u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u062c\u0630\u0631 \u0648\u0627\u0644\u0636\u063a\u0637\u0627\u062a" },
            { "be", "\u0627\u0644\u0628\u064a\u0644\u0627\u0631\u0648\u0633\u064a\u0629" },
            { "bg", "\u0627\u0644\u0628\u0644\u063a\u0627\u0631\u064a\u0629" },
            { "bi", "\u0627\u0644\u0628\u064a\u0633\u0644\u0627\u0645\u064a\u0629" },
            { "bm", "\u0627\u0644\u0628\u0627\u0645\u0628\u0627\u0631\u0627" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u0627\u0644\u062f\u0648\u062c\u0631\u064a\u0628" },
            { "br", "\u0627\u0644\u0628\u0631\u064a\u062a\u0648\u0646\u064a\u0629" },
            { "bs", "\u0627\u0644\u0628\u0648\u0633\u0646\u064a\u0629" },
            { "see", "\u0627\u0644\u0633\u0646\u064a\u0643\u0627" },
            { "Mymr", "\u0627\u0644\u0645\u064a\u0627\u0646\u0645\u0627\u0631" },
            { "type.nu.laoo", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0644\u0627\u0648\u064a\u0629" },
            { "seh", "\u0633\u064a\u0646\u0627" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0627\u0644\u0633\u064a\u0644\u0643\u0628" },
            { "ca", "\u0627\u0644\u0643\u062a\u0627\u0644\u0627\u0646\u064a\u0629" },
            { "ses", "\u0643\u0648\u064a\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u064a\u0646\u064a" },
            { "ce", "\u0627\u0644\u0634\u064a\u0634\u0627\u0646\u064a\u0629" },
            { "ch", "\u0627\u0644\u062a\u0634\u0627\u0645\u0648\u0631\u0648" },
            { "%%REVISED", "\u062a\u0647\u062c\u0626\u0629 \u062a\u0645\u062a \u0645\u0631\u0627\u062c\u0639\u062a\u0647\u0627" },
            { "co", "\u0627\u0644\u0643\u0648\u0631\u0633\u064a\u0643\u064a\u0629" },
            { "Orya", "\u0627\u0644\u0623\u0648\u0631\u064a\u0627" },
            { "cr", "\u0627\u0644\u0643\u0631\u0649" },
            { "cs", "\u0627\u0644\u062a\u0634\u064a\u0643\u064a\u0629" },
            { "cu", "\u0633\u0644\u0627\u0641\u064a\u0629 \u0643\u0646\u0633\u064a\u0629" },
            { "cv", "\u0627\u0644\u062a\u0634\u0648\u0641\u0627\u0634\u064a" },
            { "cy", "\u0627\u0644\u0648\u0644\u0632\u064a\u0629" },
            { "type.nu.ethi", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0625\u062b\u064a\u0648\u0628\u064a\u0629" },
            { "Yiii", "\u0627\u0644\u064a\u064a" },
            { "da", "\u0627\u0644\u062f\u0627\u0646\u0645\u0627\u0631\u0643\u064a\u0629" },
            { "pt_PT", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u064a\u0629 \u0627\u0644\u0623\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "de", "\u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629" },
            { "bej", "\u0627\u0644\u0628\u064a\u062c\u0627" },
            { "din", "\u0627\u0644\u062f\u0646\u0643\u0627" },
            { "Bugi", "\u0627\u0644\u0628\u062c\u064a\u0646\u064a\u0632" },
            { "bem", "\u0627\u0644\u0628\u064a\u0645\u0628\u0627" },
            { "sga", "\u0627\u0644\u0623\u064a\u0631\u0644\u0646\u062f\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "type.nu.mong", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u063a\u0648\u0644\u064a\u0629" },
            { "dv", "\u0627\u0644\u0645\u0627\u0644\u062f\u064a\u0641\u064a\u0629" },
            { "es_419", "\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629 \u0623\u0645\u0631\u064a\u0643\u0627 \u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629" },
            { "dz", "\u0627\u0644\u0632\u0648\u0646\u062e\u0627\u064a\u0629" },
            { "bez", "\u0628\u064a\u0646\u0627" },
            { "type.ca.chinese", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0635\u064a\u0646\u064a" },
            { "dje", "\u0627\u0644\u0632\u0627\u0631\u0645\u064a\u0629" },
            { "type.nu.grek", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u064a\u0648\u0646\u0627\u0646\u064a\u0629" },
            { "ee", "\u0627\u0644\u0625\u064a\u0648\u064a" },
            { "bfd", "\u0644\u063a\u0629 \u0627\u0644\u0628\u0627\u0641\u0648\u062a" },
            { "type.lb.normal", "\u0646\u0645\u0637 \u0641\u0635\u0644 \u0627\u0644\u0633\u0637\u0648\u0631: \u0639\u0627\u062f\u064a" },
            { "ro_MD", "\u0627\u0644\u0645\u0648\u0644\u062f\u0648\u0641\u064a\u0629" },
            { "el", metaValue_el },
            { "en", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629" },
            { "eo", "\u0627\u0644\u0625\u0633\u0628\u0631\u0627\u0646\u062a\u0648" },
            { "type.co.big5han", "\u062a\u0631\u062a\u064a\u0628 \u0641\u0631\u0632 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629 (Big5)" },
            { "es", "\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629" },
            { "et", "\u0627\u0644\u0625\u0633\u062a\u0648\u0646\u064a\u0629" },
            { "eu", "\u0644\u063a\u0629 \u0627\u0644\u0628\u0627\u0633\u0643" },
            { "Buhd", "\u0627\u0644\u0628\u0647\u064a\u062f\u064a\u0629" },
            { "Hang", "\u0627\u0644\u0647\u0627\u0646\u063a\u0648\u0644" },
            { "shi", "\u062a\u0634\u0644\u062d\u064a\u062a" },
            { "hsb", "\u0627\u0644\u0635\u0631\u0628\u064a\u0629 \u0627\u0644\u0639\u0644\u064a\u0627" },
            { "Hani", "\u0627\u0644\u0647\u0627\u0646" },
            { "shn", "\u0627\u0644\u0634\u0627\u0646\u064a\u0629" },
            { "Hano", "\u0627\u0644\u0647\u0627\u0646\u0648\u0646\u0648" },
            { "fa", "\u0627\u0644\u0641\u0627\u0631\u0633\u064a\u0629" },
            { "Hans", "\u0627\u0644\u0645\u0628\u0633\u0637\u0629" },
            { "type.nu.latn", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "Hant", "\u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "ff", "\u0627\u0644\u0641\u0644\u0629" },
            { "shu", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u062a\u0634\u0627\u062f\u064a\u0629" },
            { "fi", "\u0627\u0644\u0641\u0646\u0644\u0646\u062f\u064a\u0629" },
            { "fj", "\u0627\u0644\u0641\u064a\u062c\u064a\u0629" },
            { "fon", "\u0627\u0644\u0641\u0648\u0646" },
            { "bgn", "\u0627\u0644\u0628\u0644\u0648\u0634\u064a\u0629 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "yue", "\u0627\u0644\u0643\u064e\u0646\u0652\u062a\u064f\u0648\u0646\u064a\u0629" },
            { "fo", "\u0627\u0644\u0641\u0627\u0631\u0648\u064a\u0632" },
            { "umb", "\u0627\u0644\u0623\u0645\u0628\u0646\u062f\u0648" },
            { "fr", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629" },
            { "sid", "\u0627\u0644\u0633\u064a\u062f\u0627\u0645\u0648" },
            { "fy", "\u0627\u0644\u0641\u0631\u064a\u0632\u064a\u0627\u0646" },
            { "ga", "\u0627\u0644\u0623\u064a\u0631\u0644\u0646\u062f\u064a\u0629" },
            { "gd", "\u0627\u0644\u063a\u064a\u0644\u064a\u0629 \u0627\u0644\u0623\u0633\u0643\u062a\u0644\u0646\u062f\u064a\u0629" },
            { "key.colCaseLevel", "\u0627\u0644\u062a\u0635\u0646\u064a\u0641 \u0628\u062d\u0633\u0628 \u062d\u0633\u0627\u0633\u064a\u0629 \u062d\u0627\u0644\u0629 \u0627\u0644\u0623\u062d\u0631\u0641" },
            { "gl", "\u0627\u0644\u062c\u0627\u0644\u064a\u0643\u064a\u0629" },
            { "gn", "\u0627\u0644\u062c\u0648\u0627\u0631\u0627\u0646\u064a" },
            { "bho", "\u0627\u0644\u0628\u0647\u0648\u062c\u0628\u0648\u0631\u064a\u0629" },
            { "und", "\u0644\u063a\u0629 \u063a\u064a\u0631 \u0645\u0639\u0631\u0648\u0641\u0629" },
            { "type.ca.ethiopic-amete-alem", "\u062a\u0642\u0648\u064a\u0645 \u0623\u0645\u064a\u062a\u064a \u0623\u0644\u064a\u0645 \u0627\u0644\u0625\u062b\u064a\u0648\u0628\u064a" },
            { "gu", "\u0627\u0644\u063a\u0648\u062c\u0627\u0631\u0627\u062a\u064a\u0629" },
            { "type.ca.islamic-tbla", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a (\u0645\u062c\u062f\u0648\u0644\u060c \u0627\u0644\u0639\u0635\u0631 \u0627\u0644\u0641\u0644\u0643\u064a)" },
            { "gv", "\u0627\u0644\u0645\u0646\u0643\u064a\u0629" },
            { "ha", "\u0627\u0644\u0647\u0648\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u0627\u0644\u0647\u0646\u062f\u064a\u0629" },
            { "hup", "\u0627\u0644\u0647\u0628\u0627" },
            { "bik", "\u0627\u0644\u0628\u064a\u0643\u0648\u0644\u064a\u0629" },
            { "bin", "\u0627\u0644\u0628\u064a\u0646\u064a\u0629" },
            { "ho", "\u0627\u0644\u0647\u064a\u0631\u064a \u0645\u0648\u062a\u0648" },
            { "hr", "\u0627\u0644\u0643\u0631\u0648\u0627\u062a\u064a\u0629" },
            { "ht", "\u0627\u0644\u0647\u0627\u064a\u062a\u064a\u0629" },
            { "hu", "\u0627\u0644\u0647\u0646\u063a\u0627\u0631\u064a\u0629" },
            { "hy", metaValue_hy },
            { "hz", "\u0627\u0644\u0647\u064a\u0631\u064a\u0631\u0648" },
            { "ia", "\u0627\u0644\u0644\u0651\u063a\u0629 \u0627\u0644\u0648\u0633\u064a\u0637\u0629" },
            { "id", "\u0627\u0644\u0625\u0646\u062f\u0648\u0646\u064a\u0633\u064a\u0629" },
            { "type.nu.tibt", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u0628\u062a\u064a\u0629" },
            { "ie", "\u0627\u0644\u0625\u0646\u062a\u0631\u0644\u064a\u0646\u062c" },
            { "ig", "\u0627\u0644\u0625\u064a\u062c\u0628\u0648" },
            { "ii", "\u0627\u0644\u0633\u064a\u062a\u0634\u064a\u0648\u0646 \u064a\u064a" },
            { "frm", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "ik", "\u0627\u0644\u0625\u064a\u0646\u0628\u064a\u0627\u0643" },
            { "fro", "\u0627\u0644\u0641\u0631\u0646\u0633\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "io", "\u0627\u0644\u0625\u064a\u062f\u0648" },
            { "frs", "\u0627\u0644\u0641\u0631\u064a\u0632\u064a\u0646\u064a\u0629 \u0627\u0644\u0634\u0631\u0642\u064a\u0629" },
            { "frr", "\u0627\u0644\u0641\u0631\u064a\u0632\u064a\u0646\u064a\u0629 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629" },
            { "is", "\u0627\u0644\u0623\u064a\u0633\u0644\u0627\u0646\u062f\u064a\u0629" },
            { "it", "\u0627\u0644\u0625\u064a\u0637\u0627\u0644\u064a\u0629" },
            { "iu", "\u0627\u0644\u0625\u064a\u0646\u0643\u062a\u064a\u062a\u062a" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "Sara", "\u0627\u0644\u0633\u0627\u0631\u0627\u062a\u064a" },
            { "doi", "\u0627\u0644\u062f\u0648\u062c\u0631\u064a\u0629" },
            { "bkm", "\u0644\u063a\u0629 \u0627\u0644\u0643\u0648\u0645" },
            { "sma", "\u0627\u0644\u0633\u0627\u0645\u064a \u0627\u0644\u062c\u0646\u0648\u0628\u064a" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0627\u0644\u0634\u0648\u0627\u0646\u064a" },
            { "mad", "\u0627\u0644\u0645\u0627\u062f\u0631\u064a\u0632" },
            { "smj", "\u0627\u0644\u0644\u0648\u0644 \u0633\u0627\u0645\u064a" },
            { "mag", "\u0627\u0644\u0645\u0627\u062c\u0627" },
            { "mai", "\u0627\u0644\u0645\u0627\u064a\u062b\u064a\u0644\u064a" },
            { "smn", "\u0627\u0644\u0625\u064a\u0646\u0627\u0631\u064a \u0633\u0627\u0645\u064a" },
            { "ka", metaValue_ka },
            { "bla", "\u0627\u0644\u0633\u064a\u0643\u0633\u064a\u0643\u064a\u0629" },
            { "mak", "\u0627\u0644\u0645\u0627\u0643\u0627\u0633\u0627\u0631" },
            { "sms", "\u0627\u0644\u0633\u0643\u0648\u0644\u062a \u0633\u0627\u0645\u064a" },
            { "man", "\u0627\u0644\u0645\u0627\u0646\u062f\u064a\u0646\u063a" },
            { "kg", "\u0627\u0644\u0643\u0648\u0646\u063a\u0648" },
            { "Goth", metaValue_got },
            { "ki", "\u0627\u0644\u0643\u064a\u0643\u064a\u0648" },
            { "mas", "\u0627\u0644\u0645\u0627\u0633\u0627\u064a" },
            { "kj", "\u0627\u0644\u0643\u064a\u0648\u0646\u064a\u0627\u0645\u0627" },
            { "kk", "\u0627\u0644\u0643\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646\u064a\u0629" },
            { "kl", "\u0627\u0644\u0643\u0627\u0644\u0627\u0644\u064a\u0633\u062a" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "type.colStrength.identical", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0643\u0644" },
            { "ko", metaValue_ko },
            { "kr", "\u0627\u0644\u0643\u0627\u0646\u064a\u0648\u0631\u064a" },
            { "ks", "\u0627\u0644\u0643\u0634\u0645\u064a\u0631\u064a\u0629" },
            { "Cirt", "\u0627\u0644\u0633\u064a\u0631\u062b" },
            { "Lepc", "\u0627\u0644\u0644\u064a\u0628\u062a\u0634\u0627 - \u0631\u0648\u0646\u062c" },
            { "ku", "\u0627\u0644\u0643\u0631\u062f\u064a\u0629" },
            { "kv", "\u0627\u0644\u0643\u0648\u0645\u064a" },
            { "kw", "\u0627\u0644\u0643\u0648\u0631\u0646\u064a\u0629" },
            { "ky", "\u0627\u0644\u0642\u0631\u063a\u064a\u0632\u064a\u0629" },
            { "snk", "\u0627\u0644\u0633\u0648\u0646\u064a\u0646\u0643" },
            { "type.colStrength.primary", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u062d\u0631\u0648\u0641 \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629 \u0641\u0642\u0637" },
            { "la", metaValue_la },
            { "lb", "\u0627\u0644\u0644\u0648\u0643\u0633\u0645\u0628\u0631\u062c\u064a\u0629" },
            { "type.nu.mlym", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0644\u0627\u064a\u0644\u0627\u0645\u064a\u0629" },
            { "lg", "\u0627\u0644\u062c\u0627\u0646\u062f\u0627" },
            { "Roro", "\u0631\u0646\u062c\u0648\u0631\u0646\u062c\u0648" },
            { "li", "\u0627\u0644\u0644\u064a\u0645\u0628\u0631\u062c\u064a\u0634\u064a\u0629" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0627\u0644\u0644\u064a\u0646\u062c\u0627\u0644\u0627" },
            { "fur", "\u0627\u0644\u0641\u0631\u064a\u0644\u0627\u064a\u0627\u0646" },
            { "type.colCaseLevel.no", "\u062a\u0635\u0646\u064a\u0641 \u0628\u062d\u0633\u0628 \u0627\u0644\u0623\u062d\u0631\u0641 \u063a\u064a\u0631 \u0627\u0644\u062d\u0633\u0627\u0633\u0629 \u0644\u062d\u0627\u0644\u0629 \u0627\u0644\u0623\u062d\u0631\u0641" },
            { "lo", "\u0627\u0644\u0644\u0627\u0648\u064a\u0629" },
            { "type.ms.uksystem", "\u0646\u0638\u0627\u0645 \u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629" },
            { "type.colStrength.tertiary", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0644\u0643\u0646\u0627\u062a/\u0627\u0644\u062d\u0627\u0644\u0629/\u0627\u0644\u0639\u0631\u0636" },
            { "lt", "\u0627\u0644\u0644\u062a\u0648\u0627\u0646\u064a\u0629" },
            { "lu", "\u0627\u0644\u0644\u0628\u0627-\u0643\u0627\u062a\u0627\u0646\u062c\u0627" },
            { "lv", "\u0627\u0644\u0644\u0627\u062a\u0641\u064a\u0629" },
            { "sog", "\u0627\u0644\u0633\u0648\u062c\u062f\u064a\u0646" },
            { "ListCompositionPattern", "{0}\u060c {1}" },
            { "mg", "\u0627\u0644\u0645\u0627\u0644\u0627\u062c\u0627\u0634\u064a\u0629" },
            { "mh", "\u0627\u0644\u0645\u0627\u0631\u0634\u0627\u0644\u064a\u0629" },
            { "type.co.ducet", "\u062a\u0631\u062a\u064a\u0628 \u0641\u0631\u0632 Unicode \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a" },
            { "mi", "\u0627\u0644\u0645\u0627\u0648\u0631\u064a\u0629" },
            { "mk", "\u0627\u0644\u0645\u0642\u062f\u0648\u0646\u064a\u0629" },
            { "ml", metaValue_ml },
            { "mn", "\u0627\u0644\u0645\u0646\u063a\u0648\u0644\u064a\u0629" },
            { "mr", "\u0627\u0644\u0645\u0627\u0631\u0627\u062b\u064a" },
            { "ms", "\u0644\u063a\u0629 \u0627\u0644\u0645\u0644\u0627\u064a\u0648" },
            { "mt", "\u0627\u0644\u0645\u0627\u0644\u0637\u064a\u0629" },
            { "my", "\u0627\u0644\u0628\u0648\u0631\u0645\u064a\u0629" },
            { "Armn", metaValue_hy },
            { "mdf", "\u0627\u0644\u0645\u0648\u0643\u0634\u0627" },
            { "mde", "\u0645\u0627\u0628\u0627" },
            { "dsb", "\u0627\u0644\u0635\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0641\u0644\u0649" },
            { "na", "\u0627\u0644\u0646\u0648\u0631\u0648" },
            { "type.co.search", "\u0628\u062d\u062b \u0644\u0623\u063a\u0631\u0627\u0636 \u0639\u0627\u0645\u0629" },
            { "nb", "\u0627\u0644\u0628\u0648\u0643\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u0646\u0631\u0648\u064a\u062c\u064a\u0629" },
            { "nd", "\u0627\u0644\u0646\u062f\u064a\u0628\u064a\u0644 \u0627\u0644\u0634\u0645\u0627\u0644\u064a" },
            { "ne", "\u0627\u0644\u0646\u064a\u0628\u0627\u0644\u064a\u0629" },
            { "ng", "\u0627\u0644\u0646\u062f\u0648\u0646\u062c\u0627" },
            { "mdr", "\u0627\u0644\u0645\u0627\u0646\u062f\u0627\u0631" },
            { "nl", "\u0627\u0644\u0647\u0648\u0644\u0646\u062f\u064a\u0629" },
            { "nn", "\u0627\u0644\u0646\u064a\u0646\u0648\u0631\u0633\u0643 \u0627\u0644\u0646\u0631\u0648\u064a\u062c\u064a" },
            { "no", "\u0627\u0644\u0646\u0631\u0648\u064a\u062c\u064a\u0629" },
            { "nr", "\u0627\u0644\u0646\u062f\u064a\u0628\u064a\u0644 \u0627\u0644\u062c\u0646\u0648\u0628\u064a" },
            { "nv", "\u0627\u0644\u0646\u0627\u0641\u0627\u062c\u0648" },
            { "kaa", "\u0627\u0644\u0643\u0627\u0631\u0627-\u0643\u0627\u0644\u0628\u0627\u0643" },
            { "ny", "\u0627\u0644\u0646\u064a\u0627\u0646\u062c\u0627" },
            { "kac", "\u0627\u0644\u0643\u0627\u062a\u0634\u064a\u0646" },
            { "kab", "\u0627\u0644\u0642\u0628\u064a\u0644\u064a\u0629" },
            { "%%POLYTON", "\u0645\u062a\u0639\u062f\u062f \u0627\u0644\u0646\u063a\u0645\u0627\u062a" },
            { "type.colCaseFirst.lower", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0623\u062d\u0631\u0641 \u0627\u0644\u0635\u063a\u064a\u0631\u0629 \u0623\u0648\u0644\u0627\u064b" },
            { "oc", "\u0627\u0644\u0623\u0648\u0643\u064a\u062a\u0627\u0646\u064a\u0629" },
            { "kaj", "\u0627\u0644\u062c\u0648" },
            { "kam", "\u0627\u0644\u0643\u0627\u0645\u0628\u0627" },
            { "men", "\u0627\u0644\u0645\u064a\u0646\u062f" },
            { "oj", "\u0627\u0644\u0623\u0648\u062c\u064a\u0628\u0648\u0627" },
            { "mer", "\u0627\u0644\u0645\u064a\u0631\u0648" },
            { "type.nu.armn", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0623\u0631\u0645\u064a\u0646\u064a\u0629" },
            { "om", "\u0627\u0644\u0623\u0648\u0631\u0648\u0645\u0648" },
            { "kaw", "\u0627\u0644\u0643\u0648\u064a" },
            { "or", "\u0627\u0644\u0623\u0648\u0631\u064a\u064a\u0627" },
            { "os", "\u0627\u0644\u0623\u0648\u0633\u064a\u062a\u064a\u0643" },
            { "kbd", "\u0627\u0644\u0643\u0627\u0628\u0627\u0631\u062f\u0627\u064a\u0627\u0646" },
            { "mfe", "\u0627\u0644\u0645\u0648\u0631\u0633\u064a\u0627\u0646\u064a\u0629" },
            { "srn", "\u0627\u0644\u0633\u0631\u0627\u0646\u0627\u0646 \u062a\u0648\u0646\u062c\u0648" },
            { "pa", "\u0627\u0644\u0628\u0646\u062c\u0627\u0628\u064a\u0629" },
            { "dua", "\u0627\u0644\u062f\u064a\u0648\u0644\u0627" },
            { "srr", "\u0627\u0644\u0633\u0631\u0631" },
            { "kbl", "\u0643\u0627\u0646\u0645\u0628\u0648" },
            { "pi", metaValue_pi },
            { "pl", "\u0627\u0644\u0628\u0648\u0644\u0646\u062f\u064a\u0629" },
            { "dum", "\u0627\u0644\u0647\u0648\u0644\u0646\u062f\u064a\u0629 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "type.ca.dangi", "\u062a\u0642\u0648\u064a\u0645 \u062f\u0627\u0646\u062c\u064a" },
            { "ps", "\u0627\u0644\u0628\u0634\u062a\u0648\u0646\u064a\u0629" },
            { "pt", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u064a\u0629" },
            { "mga", "\u0627\u0644\u0623\u064a\u0631\u0644\u0646\u062f\u064a\u0629 \u0627\u0644\u0648\u0633\u0637\u0649" },
            { "key.co", "\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0641\u0631\u0632" },
            { "pt_BR", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u064a\u0629 \u0627\u0644\u0628\u0631\u0627\u0632\u064a\u0644\u064a\u0629" },
            { "kcg", "\u0627\u0644\u062a\u0627\u064a\u0627\u0628\u064a\u0629" },
            { "mgh", "\u0645\u0627\u062e\u0627\u0648\u0627-\u0645\u064a\u062a\u0648" },
            { "bra", "\u0627\u0644\u0628\u0631\u0627\u062c\u064a\u0629" },
            { "key.ca", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645" },
            { "Laoo", "\u0627\u0644\u0644\u0627\u0648" },
            { "mgo", "\u0645\u064a\u062a\u0627" },
            { "type.hc.h23", "\u0646\u0638\u0627\u0645 24 \u0633\u0627\u0639\u0629 (0\u201323)" },
            { "type.hc.h24", "\u0646\u0638\u0627\u0645 24 \u0633\u0627\u0639\u0629 (1\u201324)" },
            { "ssy", "\u0644\u063a\u0629 \u0627\u0644\u0633\u0627\u0647\u0648" },
            { "type.nu.mymr", "\u0623\u0631\u0642\u0627\u0645 \u0645\u064a\u0627\u0646\u0645\u0627\u0631" },
            { "qu", "\u0627\u0644\u0643\u0648\u064a\u062a\u0634\u0648\u0627" },
            { "zap", "\u0627\u0644\u0632\u0627\u0628\u0648\u062a\u064a\u0643" },
            { "brx", "\u0627\u0644\u0628\u0648\u062f\u0648" },
            { "Lana", "\u0627\u0644\u0627\u0646\u0627" },
            { "kde", "\u0645\u0627\u0643\u0648\u0646\u062f\u0647" },
            { "Ethi", "\u0627\u0644\u0623\u062b\u064a\u0648\u0628\u064a\u0629" },
            { "type.hc.h12", "\u0646\u0638\u0627\u0645 12 \u0633\u0627\u0639\u0629 (1\u201312)" },
            { "type.hc.h11", "\u0646\u0638\u0627\u0645 12 \u0633\u0627\u0639\u0629 (0\u201311)" },
            { "rm", "\u0627\u0644\u0631\u0648\u0645\u0627\u0646\u0634\u064a\u0629" },
            { "rn", "\u0627\u0644\u0631\u0646\u062f\u064a" },
            { "key.cu", "\u0627\u0644\u0639\u0645\u0644\u0629" },
            { "ro", "\u0627\u0644\u0631\u0648\u0645\u0627\u0646\u064a\u0629" },
            { "type.nu.orya", "\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0623\u0648\u0631\u064a\u0627" },
            { "type.nu.hanidec", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0639\u0634\u0631\u064a\u0629 \u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "ru", "\u0627\u0644\u0631\u0648\u0633\u064a\u0629" },
            { "bss", "\u0623\u0643\u0648\u0633" },
            { "rw", "\u0627\u0644\u0643\u064a\u0646\u064a\u0627\u0631\u0648\u0627\u0646\u062f\u0627" },
            { "zbl", "\u0631\u0645\u0648\u0632 \u0627\u0644\u0645\u0639\u0627\u064a\u064a\u0631 \u0627\u0644\u0623\u0633\u0627\u0633\u064a\u0629" },
            { "kea", "\u0643\u0627\u0628\u0648\u0641\u064a\u0631\u062f\u064a\u0627\u0646\u0648" },
            { "mic", "\u0627\u0644\u0645\u064a\u0643\u0645\u0627\u0643\u064a\u0648\u0646\u064a\u0629" },
            { "suk", "\u0627\u0644\u0633\u0648\u0643\u0648\u0645\u0627" },
            { "en_AU", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0623\u0633\u062a\u0631\u0627\u0644\u064a\u0629" },
            { "sa", "\u0627\u0644\u0633\u0646\u0633\u0643\u0631\u064a\u062a\u064a\u0629" },
            { "%%UCCOR", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0645\u0648\u062d\u062f\u0629" },
            { "sc", "\u0627\u0644\u0633\u0631\u062f\u064a\u0646\u064a\u0629" },
            { "sus", "\u0627\u0644\u0633\u0648\u0633\u0648" },
            { "sd", "\u0627\u0644\u0633\u0646\u062f\u064a\u0629" },
            { "se", "\u0627\u0644\u0633\u0627\u0645\u064a \u0627\u0644\u0634\u0645\u0627\u0644\u064a" },
            { "min", "\u0627\u0644\u0645\u064a\u0646\u0627\u0646\u062c\u0643\u0627\u0628\u0627\u0648" },
            { "sg", "\u0627\u0644\u0633\u0627\u0646\u062c\u0648" },
            { "sh", "\u0635\u0631\u0628\u064a\u0629-\u0643\u0631\u0648\u0627\u062a\u064a\u0629" },
            { "si", "\u0627\u0644\u0633\u0646\u0647\u0627\u0644\u064a\u0629" },
            { "sux", "\u0627\u0644\u0633\u0648\u0645\u0627\u0631\u064a\u0629" },
            { "sk", "\u0627\u0644\u0633\u0644\u0648\u0641\u0627\u0643\u064a\u0629" },
            { "sl", "\u0627\u0644\u0633\u0644\u0648\u0641\u0627\u0646\u064a\u0629" },
            { "sm", "\u0627\u0644\u0633\u0627\u0645\u0648\u0627\u0626\u064a\u0629" },
            { "sn", "\u0627\u0644\u0634\u0648\u0646\u0627" },
            { "so", "\u0627\u0644\u0635\u0648\u0645\u0627\u0644\u064a\u0629" },
            { "type.nu.arab", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0647\u0646\u062f\u064a\u0629" },
            { "sq", "\u0627\u0644\u0623\u0644\u0628\u0627\u0646\u064a\u0629" },
            { "sr", "\u0627\u0644\u0635\u0631\u0628\u064a\u0629" },
            { "ss", "\u0627\u0644\u0633\u0648\u0627\u062a\u064a" },
            { "Java", metaValue_jv },
            { "st", "\u0627\u0644\u0633\u0648\u062a\u0648 \u0627\u0644\u062c\u0646\u0648\u0628\u064a\u0629" },
            { "su", metaValue_su },
            { "%%NEDIS", "\u0644\u0647\u062c\u0629 \u0646\u0627\u062a\u064a\u0633\u0648\u0646" },
            { "sv", "\u0627\u0644\u0633\u0648\u064a\u062f\u064a\u0629" },
            { "sw", "\u0627\u0644\u0633\u0648\u0627\u062d\u0644\u064a\u0629" },
            { "type.nu.hantfin", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "ibb", "\u0627\u0644\u0625\u064a\u0628\u064a\u0628\u064a\u0648\u064a\u0629" },
            { "iba", "\u0627\u0644\u0625\u064a\u0628\u0627\u0646" },
            { "ta", metaValue_ta },
            { "142", "\u0622\u0633\u064a\u0627" },
            { "bua", "\u0627\u0644\u0628\u0631\u064a\u0627\u062a\u064a\u0629" },
            { "143", "\u0648\u0633\u0637 \u0622\u0633\u064a\u0627" },
            { "te", metaValue_te },
            { "145", "\u063a\u0631\u0628 \u0622\u0633\u064a\u0627" },
            { "tg", "\u0627\u0644\u0637\u0627\u062c\u064a\u0643\u064a\u0629" },
            { "th", metaValue_th },
            { "ti", "\u0627\u0644\u062a\u063a\u0631\u064a\u0646\u064a\u0629" },
            { "bug", "\u0627\u0644\u0628\u062c\u064a\u0646\u064a\u0632\u064a\u0629" },
            { "kfo", "\u0627\u0644\u0643\u0648\u0631\u0648" },
            { "type.colNumeric.yes", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0628\u0627\u0644\u0639\u062f\u062f" },
            { "en_CA", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629 \u0627\u0644\u0643\u0646\u062f\u064a\u0629" },
            { "tk", "\u0627\u0644\u062a\u0631\u0643\u0645\u0627\u0646\u064a\u0629" },
            { "tl", "\u0627\u0644\u062a\u0627\u063a\u0627\u0644\u0648\u063a\u064a\u0629" },
            { "tn", "\u0627\u0644\u062a\u0633\u0648\u0627\u0646\u064a\u0629" },
            { "to", "\u0627\u0644\u062a\u0648\u0646\u063a\u064a\u0629" },
            { "bum", "\u0644\u063a\u0629 \u0627\u0644\u0628\u0648\u0644\u0648" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0646\u064a\u0627" },
            { "type.nu.jpan", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a\u0629" },
            { "tr", "\u0627\u0644\u062a\u0631\u0643\u064a\u0629" },
            { "ts", "\u0627\u0644\u0633\u0648\u0646\u062c\u0627" },
            { "swb", "\u0627\u0644\u0642\u0645\u0631\u064a\u0629" },
            { "tt", "\u0627\u0644\u062a\u062a\u0627\u0631\u064a\u0629" },
            { "dyu", "\u0627\u0644\u062f\u0627\u064a\u0644\u0627" },
            { "tw", "\u0627\u0644\u062a\u0648\u064a" },
            { "ty", "\u0627\u0644\u062a\u0627\u0647\u064a\u062a\u064a\u0629" },
            { "150", "\u0623\u0648\u0631\u0648\u0628\u0627" },
            { "key.colHiraganaQuaternary", "\u0627\u0644\u062a\u0635\u0646\u064a\u0641 \u0628\u062d\u0633\u0628 \u0627\u0644\u0643\u0627\u0646\u0627" },
            { "151", "\u0634\u0631\u0642 \u0623\u0648\u0631\u0648\u0628\u0627" },
            { "154", "\u0634\u0645\u0627\u0644 \u0623\u0648\u0631\u0648\u0628\u0627" },
            { "dzg", "\u0627\u0644\u0642\u0631\u0639\u0627\u0646\u064a\u0629" },
            { "155", "\u063a\u0631\u0628 \u0623\u0648\u0631\u0648\u0628\u0627" },
            { "ug", "\u0627\u0644\u0623\u063a\u0648\u0631\u064a\u0629" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0627\u0644\u0625\u064a\u0637\u0627\u0644\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "uk", "\u0627\u0644\u0623\u0648\u0643\u0631\u0627\u0646\u064a\u0629" },
            { "type.colCaseFirst.no", "\u062a\u0631\u062a\u064a\u0628 \u062a\u0635\u0646\u064a\u0641 \u062d\u0627\u0644\u0629 \u0627\u0644\u0623\u062d\u0631\u0641 \u0627\u0644\u0637\u0628\u064a\u0639\u064a\u0629" },
            { "type.colStrength.quaternary", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0644\u0643\u0646\u0627\u062a/\u0627\u0644\u062d\u0627\u0644\u0629/\u0627\u0644\u0639\u0631\u0636/\u0627\u0644\u0643\u0627\u0646\u0627" },
            { "type.ca.coptic", "\u0627\u0644\u062a\u0642\u0648\u064a\u0645 \u0627\u0644\u0642\u0628\u0637\u064a" },
            { "ur", "\u0627\u0644\u0623\u0631\u062f\u064a\u0629" },
            { "xal", "\u0627\u0644\u0643\u0627\u0644\u0645\u064a\u0643" },
            { "zen", "\u0627\u0644\u0632\u064a\u0646\u0627\u062c\u0627" },
            { "uz", "\u0627\u0644\u0623\u0648\u0632\u0628\u0643\u064a\u0629" },
            { "kha", "\u0627\u0644\u0643\u0627\u0632\u064a\u0629" },
            { "%%1996", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0644\u0639\u0627\u0645 1996" },
            { "nds_NL", "\u0627\u0644\u0633\u0643\u0633\u0648\u0646\u064a\u0629 \u0627\u0644\u0633\u0641\u0644\u0649" },
            { "Sylo", "\u0627\u0644\u0633\u064a\u0644\u0648\u062a\u064a \u0646\u0627\u063a\u0631\u064a" },
            { "ve", "\u0627\u0644\u0641\u064a\u0646\u062f\u0627" },
            { "type.ca.roc", "\u062a\u0642\u0648\u064a\u0645 \u0645\u064a\u0646\u062c\u0648" },
            { "vi", "\u0627\u0644\u0641\u064a\u062a\u0646\u0627\u0645\u064a\u0629" },
            { "kho", "\u0627\u0644\u062e\u0648\u062a\u0627\u0646\u064a\u0632" },
            { "khq", "\u0643\u0648\u064a\u0631\u0627 \u062a\u0634\u064a\u0646\u064a" },
            { "key.hc", "\u0646\u0638\u0627\u0645 \u0627\u0644\u062a\u0648\u0642\u064a\u062a (12 \u0645\u0642\u0627\u0628\u0644 24)" },
            { "vo", "\u0644\u063a\u0629 \u0627\u0644\u0641\u0648\u0644\u0627\u0628\u0648\u0643" },
            { "key.x", "\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u062e\u0627\u0635" },
            { "syc", "\u0633\u0631\u064a\u0627\u0646\u064a\u0629 \u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "Osma", "\u0627\u0644\u0623\u0648\u0633\u0645\u0627\u0646\u064a\u0627" },
            { "quc", "\u0643\u064a\u0634\u064a" },
            { "gaa", "\u0627\u0644\u062c\u0627" },
            { "wa", "\u0627\u0644\u0648\u0644\u0648\u0646\u064a\u0629" },
            { "gag", "\u0627\u0644\u063a\u0627\u063a\u0648\u0632" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "\u0627\u0644\u0644\u064a\u062f\u064a\u0629" },
            { "Xsux", "\u0627\u0644\u0643\u062a\u0627\u0628\u0629 \u0627\u0644\u0645\u0633\u0645\u0627\u0631\u064a\u0629 \u0627\u0644\u0623\u0643\u062f\u064a\u0629 \u0627\u0644\u0633\u0648\u0645\u0631\u064a\u0629" },
            { "wo", "\u0627\u0644\u0648\u0644\u0648\u0641" },
            { "zgh", "\u0627\u0644\u062a\u0645\u0627\u0632\u064a\u063a\u064a\u0629 \u0627\u0644\u0645\u063a\u0631\u0628\u064a\u0629 \u0627\u0644\u0642\u064a\u0627\u0633\u064a\u0629" },
            { "ar_001", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0631\u0633\u0645\u064a\u0629 \u0627\u0644\u062d\u062f\u064a\u062b\u0629" },
            { "Cans", "\u0645\u0642\u0627\u0637\u0639 \u0643\u0646\u062f\u064a\u0629 \u0623\u0635\u0644\u064a\u0629 \u0645\u0648\u062d\u062f\u0629" },
            { "gay", "\u0627\u0644\u062c\u0627\u064a\u0648" },
            { "key.colNumeric", "\u0627\u0644\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0631\u0642\u0645\u064a" },
            { "Mong", "\u0627\u0644\u0645\u063a\u0648\u0644\u064a\u0629" },
            { "mnc", "\u0627\u0644\u0645\u0627\u0646\u0634\u0648" },
            { "Latf", "\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629 - \u0645\u062a\u063a\u064a\u0631 \u0641\u0631\u0627\u0643\u062a\u0631" },
            { "gba", "\u0627\u0644\u062c\u0628\u064a\u0627" },
            { "mni", "\u0627\u0644\u0645\u0627\u0646\u064a\u0628\u0648\u0631\u064a\u0629" },
            { "Latn", metaValue_la },
            { "Latg", "\u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629 - \u0645\u062a\u063a\u064a\u0631 \u063a\u064a\u0644\u0649" },
            { "type.nu.hans", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0628\u0633\u0637\u0629" },
            { "type.nu.hant", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "xh", "\u0627\u0644\u062e\u0648\u0633\u0627" },
            { "type.nu.romanlow", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0631\u0648\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u0635\u063a\u064a\u0631\u0629" },
            { "byn", "\u0627\u0644\u0628\u0644\u064a\u0646\u064a\u0629" },
            { "Lyci", "\u0627\u0644\u0644\u064a\u0633\u064a\u0629" },
            { "osa", "\u0627\u0644\u0623\u0648\u0633\u0627\u062c" },
            { "byv", "\u0644\u063a\u0629 \u0627\u0644\u0645\u064a\u062f\u0648\u0645\u0628\u0627" },
            { "Moon", "\u0645\u0648\u0646" },
            { "moh", "\u0627\u0644\u0645\u0648\u0647\u0648\u0643" },
            { "Syrc", metaValue_syr },
            { "yi", "\u0627\u0644\u064a\u062f\u064a\u0634\u064a\u0629" },
            { "mos", "\u0627\u0644\u0645\u0648\u0633\u064a" },
            { "Dsrt", "\u0627\u0644\u062f\u064a\u0633\u064a\u0631\u064a\u062a" },
            { "yo", "\u0627\u0644\u064a\u0648\u0631\u0648\u0628\u064a\u0629" },
            { "type.nu.traditional", "\u0623\u0631\u0642\u0627\u0645 \u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "es_MX", "\u0627\u0644\u0625\u0633\u0628\u0627\u0646\u064a\u0629 \u0627\u0644\u0645\u0643\u0633\u064a\u0643\u064a\u0629" },
            { "Syrj", "\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629 \u0627\u0644\u063a\u0631\u0628\u064a\u0629" },
            { "ota", "\u0627\u0644\u062a\u0631\u0643\u064a\u0629 \u0627\u0644\u0639\u062b\u0645\u0627\u0646\u064a\u0629" },
            { "Syre", "\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629 \u0627\u0644\u0623\u0633\u062a\u0631\u0646\u062c\u064a\u0644\u064a\u0629" },
            { "vai", metaValue_vai },
            { "za", "\u0627\u0644\u0632\u0647\u064a\u0648\u0646\u062c" },
            { "Cari", "\u0627\u0644\u0643\u0627\u0631\u064a\u0629" },
            { "kln", "\u0643\u0627\u0644\u064a\u0646\u062c\u064a\u0646" },
            { "zh", "\u0627\u0644\u0635\u064a\u0646\u064a\u0629" },
            { "Bopo", "\u0627\u0644\u0628\u0648\u0628\u0648\u0645\u0648\u0641\u0648" },
            { "Perm", "\u0627\u0644\u0628\u064a\u0631\u0645\u064a\u0643\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "key.lb", "\u0646\u0645\u0637 \u0641\u0635\u0644 \u0627\u0644\u0633\u0637\u0648\u0631" },
            { "zu", "\u0627\u0644\u0632\u0648\u0644\u0648" },
            { "type.co.phonebook", "\u062a\u0631\u062a\u064a\u0628 \u0641\u0631\u0632 \u062f\u0644\u064a\u0644 \u0627\u0644\u0647\u0627\u062a\u0641" },
            { "%%MONOTON", "\u0623\u062d\u0627\u062f\u064a \u0627\u0644\u0646\u063a\u0645\u0629" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0627\u0644\u0643\u064a\u0645\u0628\u0646\u062f\u0648" },
            { "type.colCaseLevel.yes", "\u062a\u0635\u0646\u064a\u0641 \u0628\u062d\u0633\u0628 \u062d\u0633\u0627\u0633\u064a\u0629 \u0627\u0644\u0623\u062d\u0631\u0641" },
            { "type.nu.jpanfin", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u064a\u0627\u0628\u0627\u0646\u064a\u0629" },
            { "Cham", "\u0627\u0644\u062a\u0634\u0627\u0645\u064a\u0629" },
            { "gez", "\u0627\u0644\u062c\u0639\u0632\u064a\u0629" },
            { "Syrn", "\u0627\u0644\u0633\u0631\u064a\u0627\u0646\u064a\u0629 \u0627\u0644\u0634\u0631\u0642\u064a\u0629" },
            { "Narb", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0634\u0645\u0627\u0644\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "type.co.reformed", "\u062a\u0631\u062a\u064a\u0628 \u0641\u0631\u0632 \u0645\u062d\u0633\u064e\u0651\u0646" },
            { "Tglg", "\u0627\u0644\u062a\u063a\u0627\u0644\u0648\u063a\u064a\u0629" },
            { "Egyd", "\u0627\u0644\u062f\u064a\u0645\u0648\u0637\u064a\u0642\u064a\u0629" },
            { "key.colBackwards", "\u0627\u0644\u062a\u0635\u0646\u064a\u0641 \u0628\u062d\u0633\u0628 \u0627\u0644\u0644\u0643\u0646\u0629 \u0627\u0644\u0645\u0639\u0643\u0648\u0633\u0629" },
            { "Egyh", "\u0627\u0644\u0647\u064a\u0631\u0627\u0637\u064a\u0642\u064a\u0629" },
            { "ebu", "\u0625\u0645\u0628\u0648" },
            { "Egyp", "\u0627\u0644\u0647\u064a\u0631\u0648\u063a\u0644\u064a\u0641\u064a\u0629" },
            { "Geok", "\u0627\u0644\u0623\u0628\u062c\u062f\u064a\u0629 \u0627\u0644\u062c\u0648\u0631\u062c\u064a\u0629 - \u0623\u0633\u0648\u0645\u062a\u0627\u0641\u0631\u0644\u064a \u0648 \u0646\u0633\u062e\u0631\u064a" },
            { "zh_Hans", "\u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0628\u0633\u0637\u0629" },
            { "koi", "\u0643\u0648\u0645\u064a-\u0628\u064a\u0631\u0645\u0627\u064a\u0627\u0643" },
            { "Hung", "\u0627\u0644\u0645\u062c\u0631\u064a\u0629 \u0627\u0644\u0642\u062f\u064a\u0645\u0629" },
            { "kok", "\u0627\u0644\u0643\u0648\u0646\u0643\u0627\u0646\u064a\u0629" },
            { "%%1901", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0623\u0644\u0645\u0627\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "kos", "\u0627\u0644\u0643\u0648\u0633\u0631\u0627\u064a\u0646" },
            { "zh_Hant", "\u0627\u0644\u0635\u064a\u0646\u064a\u0629 \u0627\u0644\u062a\u0642\u0644\u064a\u062f\u064a\u0629" },
            { "Sund", metaValue_su },
            { "kpe", "\u0627\u0644\u0643\u0628\u064a\u0644" },
            { "type.nu.khmr", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062e\u064a\u0645\u0631\u064a\u0629" },
            { "ilo", "\u0627\u0644\u0625\u064a\u0644\u0648\u0643\u0648" },
            { "%%VALENCIA", "\u0628\u0644\u0646\u0633\u064a\u0629" },
            { "Cprt", "\u0627\u0644\u0642\u0628\u0631\u0635\u064a\u0629" },
            { "%%BAKU1926", "\u0627\u0644\u0623\u0628\u062c\u062f\u064a\u0629 \u0627\u0644\u062a\u0631\u0643\u064a\u0629 \u0627\u0644\u0644\u0627\u062a\u064a\u0646\u064a\u0629 \u0627\u0644\u0645\u0648\u062d\u062f\u0629" },
            { "mua", "\u0645\u0646\u062f\u0646\u062c" },
            { "type.nu.guru", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u063a\u0648\u0631\u0645\u0648\u062e\u064a\u0629" },
            { "mul", "\u0644\u063a\u0627\u062a \u0645\u062a\u0639\u062f\u062f\u0629" },
            { "cad", "\u0627\u0644\u0643\u0627\u062f\u0648" },
            { "key.ms", "\u0646\u0638\u0627\u0645 \u0627\u0644\u0642\u064a\u0627\u0633" },
            { "mus", "\u0627\u0644\u0643\u0631\u064a\u0643" },
            { "Glag", "\u0627\u0644\u062c\u0644\u0627\u062c\u0648\u0644\u064a\u062a\u064a\u0643" },
            { "gil", "\u0644\u063a\u0629 \u0623\u0647\u0644 \u062c\u0628\u0644 \u0637\u0627\u0631\u0642" },
            { "%%KKCOR", "\u0627\u0644\u062a\u0647\u062c\u0626\u0629 \u0627\u0644\u0639\u0627\u0645\u0629" },
            { "Cher", metaValue_chr },
            { "car", "\u0627\u0644\u0643\u0627\u0631\u064a\u0628\u064a\u0629" },
            { "cay", "\u0627\u0644\u0643\u0627\u064a\u0648\u062c\u064a\u0629" },
            { "type.nu.tamldec", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u062a\u0627\u0645\u064a\u0644\u064a\u0629" },
            { "krc", "\u0627\u0644\u0643\u0627\u0631\u0627\u062a\u0634\u0627\u064a-\u0628\u0627\u0644\u0643\u0627\u0631" },
            { "inh", "\u0627\u0644\u0625\u0646\u062c\u0648\u0634\u064a\u0629" },
            { "krl", "\u0627\u0644\u0643\u0627\u0631\u064a\u0644\u064a\u0629" },
            { "efi", "\u0627\u0644\u0625\u0641\u064a\u0643" },
            { "key.nu", "\u0627\u0644\u0623\u0631\u0642\u0627\u0645" },
            { "kru", "\u0627\u0644\u0643\u0648\u0631\u0648\u062e" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627" },
            { "type.colCaseFirst.upper", "\u062a\u0635\u0646\u064a\u0641 \u0627\u0644\u0623\u062d\u0631\u0641 \u0627\u0644\u0643\u0628\u064a\u0631\u0629 \u0623\u0648\u0644\u0627\u064b" },
            { "Telu", metaValue_te },
            { "ksf", "\u0644\u063a\u0629 \u0627\u0644\u0628\u0627\u0641\u064a\u0627" },
        };
        return data;
    }
}
