/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jruby.EvalType;
import org.jruby.RubySymbol;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.BeginEndInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Helpers;
import org.jruby.util.ByteList;

public class IREvalScript
extends IRClosure {
    private List<IRClosure> beginBlocks;
    private EvalType evalType;
    private String fileName;
    private static final ByteList EVAL_ = new ByteList(new byte[]{69, 86, 65, 76, 95});

    public IREvalScript(IRManager manager, IRScope lexicalParent, String fileName, int lineNumber, StaticScope staticScope, EvalType evalType) {
        super(manager, lexicalParent, lineNumber, staticScope, EVAL_);
        this.evalType = evalType;
        this.fileName = fileName;
        if (!this.getManager().isDryRun() && staticScope != null) {
            if (evalType == EvalType.MODULE_EVAL) {
                staticScope.setScopeType(this.getScopeType());
            } else {
                IRScope s2 = lexicalParent;
                while (s2 instanceof IREvalScript) {
                    s2 = s2.getLexicalParent();
                }
                staticScope.setScopeType(s2.getScopeType());
            }
        }
    }

    @Override
    public InterpreterContext allocateInterpreterContext(List<Instr> instructions) {
        this.interpreterContext = new BeginEndInterpreterContext((IRScope)this, instructions);
        return this.interpreterContext;
    }

    @Override
    public InterpreterContext allocateInterpreterContext(Callable<List<Instr>> instructions) {
        try {
            this.interpreterContext = new BeginEndInterpreterContext((IRScope)this, instructions);
        }
        catch (Exception e) {
            Helpers.throwException(e);
        }
        return this.interpreterContext;
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("EV" + this.closureId + "_LBL");
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.EVAL_SCRIPT;
    }

    public boolean isModuleOrInstanceEval() {
        return this.evalType == EvalType.MODULE_EVAL || this.evalType == EvalType.INSTANCE_EVAL;
    }

    @Override
    public void recordBeginBlock(IRClosure beginBlockClosure) {
        if (this.beginBlocks == null) {
            this.beginBlocks = new ArrayList<IRClosure>();
        }
        beginBlockClosure.setBeginEndBlock();
        this.beginBlocks.add(beginBlockClosure);
    }

    @Override
    public List<IRClosure> getBeginBlocks() {
        return this.beginBlocks;
    }

    @Override
    public LocalVariable getNewFlipStateVariable() {
        ByteList flipVarName = new ByteList(("%flip_" + this.allocateNextPrefixedName("%flip")).getBytes());
        RubySymbol name2 = this.getManager().getRuntime().newSymbol(flipVarName);
        LocalVariable v = this.lookupExistingLVar(name2);
        return v == null ? this.getNewLocalVariable(name2, 0) : v;
    }

    @Override
    public boolean isScriptScope() {
        return true;
    }

    @Override
    public boolean isFlipScope() {
        return true;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }
}

