/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyObjectInputStream;

@JRubyClass(name={"Java::JavaObject"})
public class JavaObject
extends RubyObject {
    private static final Object NULL_LOCK = new Object();
    private final VariableAccessor objectAccessor;
    private static final ObjectAllocator JAVA_OBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public JavaObject allocate(Ruby runtime2, RubyClass klazz) {
            return new JavaObject(runtime2, klazz, null);
        }
    };

    protected JavaObject(Ruby runtime2, RubyClass rubyClass, Object value2) {
        super(runtime2, rubyClass);
        this.objectAccessor = rubyClass.getVariableAccessorForWrite("__wrap_struct__");
        this.dataWrapStruct(value2);
    }

    @Override
    public final Object dataGetStruct() {
        return this.objectAccessor.get(this);
    }

    @Override
    public final void dataWrapStruct(Object object) {
        this.objectAccessor.set(this, object);
    }

    protected JavaObject(Ruby runtime2, Object value2) {
        this(runtime2, runtime2.getJavaSupport().getJavaObjectClass(), value2);
    }

    public static JavaObject wrap(Ruby runtime2, Object value2) {
        if (value2 != null) {
            if (value2 instanceof Class) {
                return JavaClass.get(runtime2, (Class)value2);
            }
            if (value2.getClass().isArray()) {
                return new JavaArray(runtime2, value2);
            }
        }
        return new JavaObject(runtime2, value2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject wrap(ThreadContext context, IRubyObject self2, IRubyObject object) {
        Object objectValue = JavaObject.unwrapObject(object, NEVER);
        if (objectValue == NEVER) {
            return context.nil;
        }
        return JavaObject.wrap(context.runtime, objectValue);
    }

    @Override
    public final Class<?> getJavaClass() {
        Object dataStruct = this.dataGetStruct();
        return dataStruct != null ? dataStruct.getClass() : Void.TYPE;
    }

    public final Object getValue() {
        return this.dataGetStruct();
    }

    public static RubyClass createJavaObjectClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass JavaObject2 = javaModule.defineClassUnder("JavaObject", runtime2.getObject(), JAVA_OBJECT_ALLOCATOR);
        JavaObject.registerRubyMethods(runtime2, JavaObject2);
        JavaObject2.getMetaClass().undefineMethod("new");
        JavaObject2.getMetaClass().undefineMethod("allocate");
        return JavaObject2;
    }

    protected static void registerRubyMethods(Ruby runtime2, RubyClass JavaObject2) {
        JavaObject2.defineAnnotatedMethods(JavaObject.class);
    }

    @Override
    public boolean equals(Object other) {
        Object otherValue = other instanceof IRubyObject ? JavaObject.unwrapObject((IRubyObject)other, NEVER) : other;
        if (otherValue == NEVER) {
            return false;
        }
        return this.getValue() == otherValue;
    }

    @Override
    public int hashCode() {
        Object value2 = this.dataGetStruct();
        return value2 == null ? 0 : value2.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        return JavaObject.to_s(this.getRuntime(), this.dataGetStruct());
    }

    public static IRubyObject to_s(Ruby runtime2, Object dataStruct) {
        if (dataStruct != null) {
            String stringValue = dataStruct.toString();
            if (stringValue == null) {
                return runtime2.getNil();
            }
            return RubyString.newUnicodeString(runtime2, stringValue);
        }
        return RubyString.newEmptyString(runtime2);
    }

    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        return JavaObject.equals(this.getRuntime(), this.getValue(), other);
    }

    public static RubyBoolean op_equal(JavaProxy self2, IRubyObject other) {
        return JavaObject.equals(self2.getRuntime(), self2.getObject(), other);
    }

    private static RubyBoolean equals(Ruby runtime2, Object thisValue, IRubyObject other) {
        Object otherValue = JavaObject.unwrapObject(other, NEVER);
        if (otherValue == NEVER) {
            return runtime2.getFalse();
        }
        if (thisValue == null) {
            return runtime2.newBoolean(otherValue == null);
        }
        return runtime2.newBoolean(thisValue.equals(otherValue));
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject same(IRubyObject other) {
        Ruby runtime2 = this.getRuntime();
        Object thisValue = this.getValue();
        Object otherValue = JavaObject.unwrapObject(other, NEVER);
        if (otherValue == NEVER) {
            return runtime2.getFalse();
        }
        if (!(other instanceof JavaObject)) {
            return runtime2.getFalse();
        }
        return runtime2.newBoolean(thisValue == otherValue);
    }

    private static Object unwrapObject(IRubyObject wrapped, Object defaultValue) {
        if (wrapped instanceof JavaObject) {
            return ((JavaObject)wrapped).getValue();
        }
        if (wrapped instanceof JavaProxy) {
            return ((JavaProxy)wrapped).getObject();
        }
        return defaultValue;
    }

    @JRubyMethod
    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    @JRubyMethod
    public JavaClass java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    @JRubyMethod
    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy() {
        return this.getRuntime().getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"})
    public final IRubyObject ruby_synchronized(ThreadContext context, Block block) {
        Object lock2 = this.getValue();
        Object object = lock2 != null ? lock2 : NULL_LOCK;
        synchronized (object) {
            return block.yield(context, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ruby_synchronized(ThreadContext context, Object lock2, Block block) {
        Object object = lock2 != null ? lock2 : NULL_LOCK;
        synchronized (object) {
            return block.yield(context, null);
        }
    }

    @JRubyMethod
    public IRubyObject marshal_dump(ThreadContext context) {
        if (Serializable.class.isAssignableFrom(this.getJavaClass())) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new ObjectOutputStream(baos).writeObject(this.getValue());
                return context.runtime.newString(new ByteList(baos.toByteArray(), false));
            }
            catch (IOException ex) {
                throw context.runtime.newIOErrorFromException(ex);
            }
        }
        throw context.runtime.newTypeError("no marshal_dump is defined for class " + this.getJavaClass());
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject str) {
        try {
            ByteList byteList = str.convertToString().getByteList();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            this.dataWrapStruct(new JRubyObjectInputStream(context.runtime, bais).readObject());
            return this;
        }
        catch (IOException ex) {
            throw context.runtime.newIOErrorFromException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw context.runtime.newTypeError("Class not found unmarshaling Java type: " + ex.getLocalizedMessage());
        }
    }

    @Override
    public <T> T toJava(Class<T> target) {
        Object value2 = this.getValue();
        if (value2 == null) {
            return null;
        }
        if (target.isAssignableFrom(value2.getClass())) {
            return target.cast(value2);
        }
        return super.toJava(target);
    }
}

