/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jruby.util.StrptimeToken;

public class StrptimeLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int CONVERSION = 1;
    public static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "\n\u0000\u0001\u0000\u0018\u0000\u0001\u0000\u0001\u0000\u0001\t\u0005\u0000\u0001\u0001\u0001\u0000\u0001\u0000\u0002\u0000\u0001\u0000\t\u0000\u0001\u0007\u0006\u0000\u0002\u0001\u0001\u0003\u0001\u0001\u0001\u0002\u0002\u0001\u0002\u0005\u0002\u0000\u0001\u0001\u0001\u0005\u0001\u0001\u0001\u0004\u0003\u0001\u0001\u0005\u0001\u0001\u0003\u0005\u0002\u0003\u0001\u0001\u0003\u0000\u0002\u0000\u0001\u0000\u0002\u0001\u0001\u0003\u0002\u0005\u0001\u0000\u0002\u0001\u0001\u0000\u0003\u0001\u0001\u0005\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0001\u0005\u0001\u0001\u0001\u0005\u0001\u0003\u0001\u0006\u0001\b\uff85\u0000";
    private static final char[] ZZ_CMAP = StrptimeLexer.zzUnpackCMap("\n\u0000\u0001\u0000\u0018\u0000\u0001\u0000\u0001\u0000\u0001\t\u0005\u0000\u0001\u0001\u0001\u0000\u0001\u0000\u0002\u0000\u0001\u0000\t\u0000\u0001\u0007\u0006\u0000\u0002\u0001\u0001\u0003\u0001\u0001\u0001\u0002\u0002\u0001\u0002\u0005\u0002\u0000\u0001\u0001\u0001\u0005\u0001\u0001\u0001\u0004\u0003\u0001\u0001\u0005\u0001\u0001\u0003\u0005\u0002\u0003\u0001\u0001\u0003\u0000\u0002\u0000\u0001\u0000\u0002\u0001\u0001\u0003\u0002\u0005\u0001\u0000\u0002\u0001\u0001\u0000\u0003\u0001\u0001\u0005\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0003\u0001\u0001\u0005\u0001\u0001\u0001\u0005\u0001\u0003\u0001\u0006\u0001\b\uff85\u0000");
    private static final int[] ZZ_ACTION = StrptimeLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0002\u0001\u0001\u0002\u0003\u0000\u0001\u0003\u0001\u0004\u0003\u0003\u0001\u0005\u0004\u0000";
    private static final int[] ZZ_ROWMAP = StrptimeLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\n\u0000\u0014\u0000\u001e\u0000(\u00002\u0000<\u0000F\u0000(\u0000(\u0000P\u0000Z\u0000d\u0000(\u0000n\u0000x\u0000\u0082\u0000\u008c";
    private static final int[] ZZ_TRANS = StrptimeLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\t\u0003\u0001\u0004\u0001\u0000\u0001\u0005\u0001\u0006\u0001\u0005\u0001\u0007\u0002\u0005\u0001\b\u0001\u0005\u0001\u0000\t\t\u0001\u0000\u0001\t\u0001\n\u0001\u000b\u0001\n\u0001\f\u0002\n\u0001\r\u0001\n\u0001\u000e\r\u0000\u0001\u0005\u0002\u0000\u0001\u0005\b\u0000\u0002\u0005\n\u0000\u0001\u000f\u0001\u0005\u0004\u0000\u0001\n\u0002\u0000\u0001\n\b\u0000\u0002\n\n\u0000\u0001\u0010\u0001\n\b\u0000\u0001\u0011\u0001\u0005\b\u0000\u0001\u0012\u0001\n\t\u0000\u0001\u0005\t\u0000\u0001\n\u0001\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = StrptimeLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0002\u0003\u0001\t\u0003\u0000\u0002\r\u0003\u0005\u0001\t\u0004\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    StringBuilder stringBuf = new StringBuilder();

    private static int[] zzUnpackAction() {
        int[] result2 = new int[18];
        int offset2 = 0;
        offset2 = StrptimeLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset2, result2);
        return result2;
    }

    private static int zzUnpackAction(String packed, int offset2, int[] result2) {
        int i2 = 0;
        int j = offset2;
        int l = packed.length();
        while (i2 < l) {
            int count2 = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                result2[j++] = value2;
            } while (--count2 > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result2 = new int[18];
        int offset2 = 0;
        offset2 = StrptimeLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset2, result2);
        return result2;
    }

    private static int zzUnpackRowMap(String packed, int offset2, int[] result2) {
        int i2 = 0;
        int j = offset2;
        int l = packed.length();
        while (i2 < l) {
            int high = packed.charAt(i2++) << 16;
            result2[j++] = high | packed.charAt(i2++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result2 = new int[150];
        int offset2 = 0;
        offset2 = StrptimeLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset2, result2);
        return result2;
    }

    private static int zzUnpackTrans(String packed, int offset2, int[] result2) {
        int i2 = 0;
        int j = offset2;
        int l = packed.length();
        while (i2 < l) {
            int count2 = packed.charAt(i2++);
            int value2 = packed.charAt(i2++);
            do {
                result2[j++] = --value2;
            } while (--count2 > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result2 = new int[18];
        int offset2 = 0;
        offset2 = StrptimeLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset2, result2);
        return result2;
    }

    private static int zzUnpackAttribute(String packed, int offset2, int[] result2) {
        int i2 = 0;
        int j = offset2;
        int l = packed.length();
        while (i2 < l) {
            int count2 = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                result2[j++] = value2;
            } while (--count2 > 0);
        }
        return j;
    }

    public StrptimeToken rawString() {
        String str = this.stringBuf.toString();
        this.stringBuf.setLength(0);
        return StrptimeToken.str(str);
    }

    public StrptimeToken directive(char c) {
        if (c == 'z') {
            int colons = this.yylength() - 1;
            return StrptimeToken.zoneOffsetColons(colons);
        }
        StrptimeToken token = StrptimeToken.format(c);
        if (token != null) {
            return token;
        }
        return StrptimeToken.special(c);
    }

    public StrptimeLexer(Reader in) {
        this.zzReader = in;
    }

    public StrptimeLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map2 = new char[65536];
        int i2 = 0;
        int j = 0;
        while (i2 < 110) {
            int count2 = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                map2[j++] = value2;
            } while (--count2 > 0);
        }
        return map2;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos2) {
        return this.zzBuffer[this.zzStartRead + pos2];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message2;
        try {
            message2 = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message2 = ZZ_ERROR_MSG[0];
        }
        throw new Error(message2);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public StrptimeToken yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        this.zzPushbackPos = -1;
        int zzPushbackPosL = -1;
        block12: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            boolean zzWasPushback = false;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    this.zzPushbackPos = zzPushbackPosL;
                    boolean eof2 = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    zzPushbackPosL = this.zzPushbackPos;
                    if (eof2) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 2) == 2) {
                    zzPushbackPosL = zzCurrentPosL;
                }
                if ((zzAttributes & 1) != 1) continue;
                zzWasPushback = (zzAttributes & 4) == 4;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzWasPushback) {
                this.zzMarkedPos = zzPushbackPosL;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 2: {
                    this.yybegin(0);
                    return this.directive(this.yycharat(this.yylength() - 1));
                }
                case 6: {
                    continue block12;
                }
                case 3: {
                    this.stringBuf.append(this.yycharat(0));
                }
                case 7: {
                    continue block12;
                }
                case 5: {
                    return StrptimeToken.str("%");
                }
                case 8: {
                    continue block12;
                }
                case 1: {
                    this.stringBuf.append(this.yycharat(0));
                    return this.rawString();
                }
                case 9: {
                    continue block12;
                }
                case 4: {
                    this.yybegin(1);
                }
                case 10: {
                    continue block12;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

