/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SignalFacade;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalFacade
implements SignalFacade {
    private final Map<Signal, SignalHandler> original = new HashMap<Signal, SignalHandler>();
    private final Map<String, SignalHandler> fakeOriginal = new HashMap<String, SignalHandler>();

    @Override
    public IRubyObject trap(IRubyObject recv2, IRubyObject blk, IRubyObject sig) {
        return this.trap(recv2.getRuntime(), new JRubySignalHandler(recv2.getRuntime(), blk, sig.toString()));
    }

    @Override
    public IRubyObject trap(Ruby runtime2, BlockCallback blk, String sig) {
        return this.trap(runtime2, new JRubySignalHandler(runtime2, blk, sig));
    }

    private IRubyObject trap(Ruby runtime2, JRubySignalHandler handler) {
        return this.trap(runtime2, handler.signal, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject restorePlatformDefault(IRubyObject recv2, IRubyObject sig) {
        SignalHandler handler;
        Map<Object, SignalHandler> map2;
        Ruby runtime2 = recv2.getRuntime();
        try {
            map2 = this.original;
            synchronized (map2) {
                handler = this.original.get(new Signal(sig.toString()));
            }
        }
        catch (IllegalArgumentException e) {
            handler = null;
        }
        if (handler != null) {
            return this.trap(runtime2, sig.toString(), handler);
        }
        map2 = this.fakeOriginal;
        synchronized (map2) {
            handler = this.fakeOriginal.remove(sig.toString());
        }
        return this.getSignalResult(runtime2, handler, null, true);
    }

    @Override
    public IRubyObject restoreOSDefault(IRubyObject recv2, IRubyObject sig) {
        return this.trap(recv2.getRuntime(), sig.toString(), SignalHandler.SIG_DFL);
    }

    @Override
    public IRubyObject ignore(IRubyObject recv2, IRubyObject sig) {
        return this.trap(recv2.getRuntime(), sig.toString(), SignalHandler.SIG_IGN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject trap(Ruby runtime2, String signalName, SignalHandler handler) {
        boolean handled;
        SignalHandler oldHandler;
        Signal signal2;
        try {
            signal2 = new Signal(signalName);
            oldHandler = Signal.handle(signal2, handler);
            Map<Signal, SignalHandler> map2 = this.original;
            synchronized (map2) {
                if (!this.original.containsKey(signal2)) {
                    this.original.put(signal2, oldHandler);
                }
            }
            handled = true;
        }
        catch (IllegalArgumentException e) {
            signal2 = null;
            oldHandler = this.fakeOriginal.get(signalName);
            Map<String, SignalHandler> map3 = this.fakeOriginal;
            synchronized (map3) {
                this.fakeOriginal.put(signalName, handler);
            }
            handled = signalName.equals("EXIT");
        }
        return this.getSignalResult(runtime2, oldHandler, signal2, handled);
    }

    private IRubyObject getSignalResult(Ruby runtime2, SignalHandler oldHandler, Signal signal2, boolean handled) {
        IRubyObject[] retVals = new IRubyObject[]{null, runtime2.newBoolean(handled)};
        BlockCallback callback = null;
        if (oldHandler instanceof JRubySignalHandler) {
            JRubySignalHandler jsHandler = (JRubySignalHandler)oldHandler;
            if (jsHandler.blockCallback != null) {
                callback = jsHandler.blockCallback;
            } else {
                retVals[0] = jsHandler.block;
                return RubyArray.newArrayMayCopy(runtime2, retVals);
            }
        }
        if (callback == null) {
            retVals[0] = oldHandler == SignalHandler.SIG_DFL ? runtime2.newString("SYSTEM_DEFAULT") : (oldHandler == SignalHandler.SIG_IGN ? runtime2.newString("IGNORE") : runtime2.newString("DEFAULT"));
        } else {
            RubyModule signalModule = runtime2.getModule("Signal");
            Block block = CallBlock.newCallClosure((IRubyObject)signalModule, signalModule, Signature.NO_ARGUMENTS, callback, runtime2.getCurrentContext());
            retVals[0] = RubyProc.newProc(runtime2, block, block.type);
        }
        return RubyArray.newArrayMayCopy(runtime2, retVals);
    }

    private static final class JRubySignalHandler
    implements SignalHandler {
        private final Ruby runtime;
        private final IRubyObject block;
        private final String signal;
        private final BlockCallback blockCallback;

        public JRubySignalHandler(Ruby runtime2, IRubyObject block, String signal2) {
            this(runtime2, block, null, signal2);
        }

        public JRubySignalHandler(Ruby runtime2, BlockCallback callback, String signal2) {
            this(runtime2, null, callback, signal2);
        }

        private JRubySignalHandler(Ruby runtime2, IRubyObject block, BlockCallback callback, String signal2) {
            this.runtime = runtime2;
            this.block = block;
            this.blockCallback = callback;
            this.signal = signal2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Signal signal2) {
            ThreadContext context = this.runtime.getCurrentContext();
            IRubyObject oldExc = this.runtime.getGlobalVariables().get("$!");
            try {
                RubyFixnum signum = this.runtime.newFixnum(signal2.getNumber());
                if (this.block != null) {
                    this.block.callMethod(context, "call", signum);
                } else {
                    this.blockCallback.call(context, new IRubyObject[]{signum}, Block.NULL_BLOCK);
                }
            }
            catch (RaiseException e) {
                try {
                    this.runtime.getThread().callMethod(context, "main").callMethod(context, "raise", e.getException());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.runtime.getGlobalVariables().set("$!", oldExc);
            }
            catch (MainExitException mee) {
                this.runtime.getThreadService().getMainThread().kill();
            }
            finally {
                Signal.handle(new Signal(this.signal), this);
            }
        }
    }
}

