/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\"\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/calls/CallResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getCallResolver", "()Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "checkSupportsArrayLiterals", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getArrayFunctionCallName", "Lorg/jetbrains/kotlin/name/Name;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getFunctionDescriptorForCollectionLiteral", "", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "callName", "isInsideAnnotationEntryOrClass", "", "resolveCollectionLiteral", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "collectionLiteralExpression", "resolveCollectionLiteralSpecialMethod", "Companion", "frontend"})
public final class CollectionLiteralResolver {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private static final Map<PrimitiveType, Name> PRIMITIVE_TYPE_TO_ARRAY;
    @NotNull
    private static final Name ARRAY_OF_FUNCTION;
    public static final Companion Companion;

    @NotNull
    public final KotlinTypeInfo resolveCollectionLiteral(@NotNull KtCollectionLiteralExpression collectionLiteralExpression, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(collectionLiteralExpression, "collectionLiteralExpression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!this.isInsideAnnotationEntryOrClass(collectionLiteralExpression)) {
            context.trace.report(Errors.UNSUPPORTED.on(collectionLiteralExpression, "Collection literals outside of annotations"));
        }
        this.checkSupportsArrayLiterals(collectionLiteralExpression, context);
        return this.resolveCollectionLiteralSpecialMethod(collectionLiteralExpression, context);
    }

    private final KotlinTypeInfo resolveCollectionLiteralSpecialMethod(KtCollectionLiteralExpression expression2, ExpressionTypingContext context) {
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        Call call2 = CallMaker.makeCallForCollectionLiteral(expression2);
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        Name callName = this.getArrayFunctionCallName(kotlinType);
        Collection<FunctionDescriptor> functionDescriptors2 = this.getFunctionDescriptorForCollectionLiteral(expression2, callName);
        if (functionDescriptors2.isEmpty()) {
            context.trace.report(Errors.MISSING_STDLIB.on(expression2, "Collection literal call '" + callName + "()' is unresolved"));
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = resolutionResults = this.callResolver.resolveCollectionLiteralCallWithGivenDescriptor(context, expression2, call2, functionDescriptors2);
        Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResults, "resolutionResults");
        if (!overloadResolutionResults.isSingleResult()) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        context.trace.record(BindingContext.COLLECTION_LITERAL_CALL, expression2, resolutionResults.getResultingCall());
        return TypeInfoFactoryKt.createTypeInfo(resolutionResults.getResultingDescriptor().getReturnType(), context);
    }

    private final Collection<SimpleFunctionDescriptor> getFunctionDescriptorForCollectionLiteral(KtCollectionLiteralExpression expression2, Name callName) {
        FqName fqName2 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        MemberScope memberScopeOfKotlinPackage = this.module.getPackage(fqName2).getMemberScope();
        return memberScopeOfKotlinPackage.getContributedFunctions(callName, new KotlinLookupLocation(expression2));
    }

    private final void checkSupportsArrayLiterals(KtCollectionLiteralExpression expression2, ExpressionTypingContext context) {
        if (this.isInsideAnnotationEntryOrClass(expression2) && !this.languageVersionSettings.supportsFeature(LanguageFeature.ArrayLiteralsInAnnotations)) {
            context.trace.report(Errors.UNSUPPORTED_FEATURE.on(expression2, TuplesKt.to(LanguageFeature.ArrayLiteralsInAnnotations, this.languageVersionSettings)));
        }
    }

    private final boolean isInsideAnnotationEntryOrClass(KtCollectionLiteralExpression expression2) {
        KtElementImplStub parent2 = (KtElementImplStub)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtAnnotationEntry.class, KtClass.class);
        return parent2 instanceof KtAnnotationEntry || parent2 instanceof KtClass && ((KtClass)parent2).isAnnotation();
    }

    private final Name getArrayFunctionCallName(KotlinType expectedType) {
        if (TypeUtils.NO_EXPECTED_TYPE == expectedType || !KotlinBuiltIns.isPrimitiveArray(expectedType)) {
            Name name = ARRAY_OF_FUNCTION;
            Intrinsics.checkExpressionValueIsNotNull(name, "ARRAY_OF_FUNCTION");
            return name;
        }
        ClassifierDescriptor classifierDescriptor = expectedType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Name name = ARRAY_OF_FUNCTION;
            Intrinsics.checkExpressionValueIsNotNull(name, "ARRAY_OF_FUNCTION");
            return name;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        Map<PrimitiveType, Name> map2 = PRIMITIVE_TYPE_TO_ARRAY;
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveArrayType(descriptor2);
        Name name = map2.get((Object)primitiveType);
        if (name == null) {
            Name name2 = ARRAY_OF_FUNCTION;
            name = name2;
            Intrinsics.checkExpressionValueIsNotNull(name2, "ARRAY_OF_FUNCTION");
        }
        return name;
    }

    @NotNull
    public final ModuleDescriptor getModule() {
        return this.module;
    }

    @NotNull
    public final CallResolver getCallResolver() {
        return this.callResolver;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public CollectionLiteralResolver(@NotNull ModuleDescriptor module2, @NotNull CallResolver callResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Intrinsics.checkParameterIsNotNull(callResolver, "callResolver");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        this.module = module2;
        this.callResolver = callResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    static {
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[8];
        Name name = Name.identifier("booleanArrayOf");
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"booleanArrayOf\")");
        pairArray[0] = TuplesKt.to(PrimitiveType.BOOLEAN, name);
        Name name2 = Name.identifier("charArrayOf");
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(\"charArrayOf\")");
        pairArray[1] = TuplesKt.to(PrimitiveType.CHAR, name2);
        Name name3 = Name.identifier("intArrayOf");
        Intrinsics.checkExpressionValueIsNotNull(name3, "Name.identifier(\"intArrayOf\")");
        pairArray[2] = TuplesKt.to(PrimitiveType.INT, name3);
        Name name4 = Name.identifier("byteArrayOf");
        Intrinsics.checkExpressionValueIsNotNull(name4, "Name.identifier(\"byteArrayOf\")");
        pairArray[3] = TuplesKt.to(PrimitiveType.BYTE, name4);
        Name name5 = Name.identifier("shortArrayOf");
        Intrinsics.checkExpressionValueIsNotNull(name5, "Name.identifier(\"shortArrayOf\")");
        pairArray[4] = TuplesKt.to(PrimitiveType.SHORT, name5);
        Name name6 = Name.identifier("floatArrayOf");
        Intrinsics.checkExpressionValueIsNotNull(name6, "Name.identifier(\"floatArrayOf\")");
        pairArray[5] = TuplesKt.to(PrimitiveType.FLOAT, name6);
        Name name7 = Name.identifier("longArrayOf");
        Intrinsics.checkExpressionValueIsNotNull(name7, "Name.identifier(\"longArrayOf\")");
        pairArray[6] = TuplesKt.to(PrimitiveType.LONG, name7);
        Name name8 = Name.identifier("doubleArrayOf");
        Intrinsics.checkExpressionValueIsNotNull(name8, "Name.identifier(\"doubleArrayOf\")");
        pairArray[7] = TuplesKt.to(PrimitiveType.DOUBLE, name8);
        PRIMITIVE_TYPE_TO_ARRAY = MapsKt.hashMapOf(pairArray);
        ARRAY_OF_FUNCTION = Name.identifier("arrayOf");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver$Companion;", "", "()V", "ARRAY_OF_FUNCTION", "Lorg/jetbrains/kotlin/name/Name;", "getARRAY_OF_FUNCTION", "()Lorg/jetbrains/kotlin/name/Name;", "PRIMITIVE_TYPE_TO_ARRAY", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "getPRIMITIVE_TYPE_TO_ARRAY", "()Ljava/util/Map;", "frontend"})
    public static final class Companion {
        @NotNull
        public final Map<PrimitiveType, Name> getPRIMITIVE_TYPE_TO_ARRAY() {
            return PRIMITIVE_TYPE_TO_ARRAY;
        }

        @NotNull
        public final Name getARRAY_OF_FUNCTION() {
            return ARRAY_OF_FUNCTION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

