/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.clsdescriptioneditor;

import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.cache.OWLExpressionUserCache;

public class OWLExpressionHistoryCompleter {
    private boolean suggestingContent = false;
    private OWLEditorKit eKit;
    private JTextComponent tc;
    private String lastSuggestion = null;
    private int caretLocation = 0;

    public OWLExpressionHistoryCompleter(OWLEditorKit eKit, JTextComponent tc) {
        this.eKit = eKit;
        this.tc = tc;
        tc.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                OWLExpressionHistoryCompleter.this.handleDocumentUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
            }
        });
    }

    private void handleDocumentUpdated() {
        if (!this.suggestingContent) {
            Document doc = this.tc.getDocument();
            this.caretLocation = this.tc.getCaretPosition() + 1;
            int docLength = doc.getLength();
            if (docLength == this.caretLocation) {
                try {
                    String currentText = doc.getText(0, doc.getLength());
                    this.lastSuggestion = this.suggestContent(currentText.substring(0, this.caretLocation));
                    if (this.lastSuggestion != null) {
                        this.suggestingContent = true;
                        SwingUtilities.invokeLater(() -> {
                            this.tc.setText(this.lastSuggestion);
                            this.tc.setSelectionEnd(this.lastSuggestion.length());
                            this.tc.setSelectionStart(this.caretLocation);
                            this.suggestingContent = false;
                        });
                    }
                }
                catch (BadLocationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private String suggestContent(String currentContent) {
        currentContent = this.normalise(currentContent);
        String candidate = null;
        for (String ren : this.getDescriptionHistory()) {
            if (candidate != null || !this.normalise(ren).startsWith(currentContent)) continue;
            candidate = ren;
        }
        return candidate;
    }

    private String normalise(String s) {
        s = s.replaceAll("\n", " ").replaceAll("\t", " ");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ' && (i <= 0 || s.charAt(i - 1) == ' ')) continue;
            buf.append(s.charAt(i));
        }
        return buf.toString().toLowerCase();
    }

    protected List<String> getDescriptionHistory() {
        return OWLExpressionUserCache.getInstance(this.eKit.getModelManager()).getRenderings();
    }
}

