/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.basic;

import java.util.List;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.api.StringDecoder;
import org.netbeans.modules.profiler.heapwalk.details.basic.ArrayValueView;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class StringDetailsProvider
extends DetailsProvider.Basic {
    static final String STRING_MASK = "java.lang.String";
    static final String BUILDERS_MASK = "java.lang.AbstractStringBuilder+";

    public StringDetailsProvider() {
        super(STRING_MASK, BUILDERS_MASK);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        if (STRING_MASK.equals(string)) {
            byte by = DetailsUtils.getByteFieldValue(instance, "coder", (byte)-1);
            if (by == -1) {
                int n = DetailsUtils.getIntFieldValue(instance, "offset", 0);
                int n2 = DetailsUtils.getIntFieldValue(instance, "count", -1);
                return DetailsUtils.getPrimitiveArrayFieldString(instance, "value", n, n2, null, "...");
            }
            return this.getJDK9String(heap, instance, "value", by, null, "...");
        }
        if (BUILDERS_MASK.equals(string)) {
            byte by = DetailsUtils.getByteFieldValue(instance, "coder", (byte)-1);
            if (by == -1) {
                int n = DetailsUtils.getIntFieldValue(instance, "count", -1);
                return DetailsUtils.getPrimitiveArrayFieldString(instance, "value", 0, n, null, "...");
            }
            return this.getJDK9String(heap, instance, "value", by, null, "...");
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String string, Instance instance, Heap heap) {
        return new ArrayValueView(string, instance, heap);
    }

    private String getJDK9String(Heap heap, Instance instance, String string, byte by, String string2, String string3) {
        List list;
        Object object = instance.getValueOfField(string);
        if (object instanceof PrimitiveArrayInstance && (list = ((PrimitiveArrayInstance)object).getValues()) != null) {
            StringDecoder stringDecoder = new StringDecoder(heap, by, list);
            int n = stringDecoder.getStringLength();
            int n2 = string2 == null ? 0 : string2.length();
            int n3 = string3 == null ? 0 : string3.length();
            int n4 = Math.min(n * (1 + n2), 160 + n3);
            StringBuilder stringBuilder = new StringBuilder(n4);
            int n5 = n - 1;
            for (int i = 0; i <= n5; ++i) {
                stringBuilder.append(stringDecoder.getValueAt(i));
                if (stringBuilder.length() >= 160) {
                    if (n3 <= 0) break;
                    stringBuilder.append(string3);
                    break;
                }
                if (string2 == null || i >= n5) continue;
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

